C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFFTMM                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES NT COMPLEX TO COMPLEX FORWARD FFT'S OR NT COMPLEX TO  *
C       COMPLEX INVERSE FFT'S.                                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFFTMMFR  (X,IDIR,NT,NS,WRK,IERR)                               *
C      XCFFT2  (X,IDIR,NT,NS,WRK,IERR)                                 *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      IDIR    INTEGER  ??IOU*      -                                  *
C      NT      INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      WRK     REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUN 88          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL CFFTMMFR (X, IDIR, NT, NS, WRK, IERR)                     *
C       CALL XCFFT2   (X, IDIR, NT, NS, WRK, IERR)                     *
C                                                                      *
C  PARAMETERS:                                                         *
C       X       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NT BY NS.     *
C                                                                      *
C       IDIR    INTEGER INPUT SCALAR.                                  *
C               FFT DIRECTION SWITCH: IDIR >= 0 FOR FORWARD FFT'S AND  *
C               IDIR < 0 FOR INVERSE FFT'S.                            *
C                                                                      *
C       NT      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF TRACES (ROW DIMENSION OF X).                 *
C                                                                      *
C       NS      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF COMPLEX SAMPLES PER TRACE (COLUMN DIMENSION  *
C               OF X).  NS MUST BE A NUMBER OF THE FORM                *
C               2**I * 3**J * 5**K, WHERE I, J, AND K ARE NON-NEGATIVE *
C               INTEGERS.                                              *
C                                                                      *
C       WRK     COMPLEX SCRATCH VECTOR OF LENGTH 4*NT*NS + 2*NS        *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR.                                 *
C               COMPLETION CODE.  VALUES ARE:                          *
C                   0 - NORMAL COMPLETION                              *
C                   4 - THE VALUE OF NS IS INVALID                     *
C                   8 - THE VALUE OF NT IS INVALID                     *
C                  12 - THE VALUES OF BOTH NT AND NS ARE INVALID       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       IF THE FORWARD FFT IS SELECTED, THEN CFFTMMFR PERFORMS AN IN-  *
C       PLACE COMPLEX TO COMPLEX FORWARD FFT ON NT COMPLEX TRACES      *
C       EACH OF LENGTH NS.  THE NT TRACES ARE STORED AS ROWS OF AN NT  *
C       BY NS COMPLEX MATRIX X.                                        *
C                                                                      *
C       IF THE INVERSE FFT IS SELECTED, THEN CFFTMMFR PERFORMS AN IN-  *
C       PLACE COMPLEX TO COMPLEX INVERSE FFT ON NT COMPLEX TRACES      *
C       EACH OF LENGTH NS.  THE NT TRACES ARE STORED AS ROWS OF AN NT  *
C       BY NS COMPLEX MATRIX X.                                        *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       MATH ADVANTAGE: VSMUL                                          *
C       CRAY SCILIB   : CFTFAX, CFFTMLT                                *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF THE VALUE OF NT OR NS IS INVALID (SEE ABOVE) THEN THE       *
C       COMPLETION CODE IS SET THE APPROPRIATE VALUE (SEE ABOVE) AND   *
C       THE ROUTINE IS ABORTED.                                        *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      NCFFT5  INTEGER -                                               *
C      CFTFAX          -                                               *
C      CFFTML          -                                               *
C      VSMUL           -                                               *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFFTMMFR  COMPLEX FFT - LOOPING BY ROW         REL 2.0  FEB 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE CFFTMMFR (X, IDIR, NT, NS, WRK, IERR)
      ENTRY      XCFFT2  (X, IDIR, NT, NS, WRK, IERR)
C
      REAL    X(*), WRK(*)
      INTEGER IDIR, NT, NS, IERR, IFAC(19)
C
C---------------------------------------------------------------------
C
C  VALIDATE PARAMETERS
C
      MS = NCFFT5( NS )
C
      IERR = 0
      IF (NS .NE. MS) IERR = IERR + 4
      IF (NT .LE.  0) IERR = IERR + 8
C
      IF (IERR .NE. 0) GO TO 800
C
C  INITIALIZATION
C
      IF (IDIR .GE. 0) THEN
         JDIR  = -1
         SCALE =  1.0 / FLOAT( NS )
      ELSE
         JDIR  =  1
      ENDIF
C
      IW  = NS + NS + 1
      NT2 = NT + NT
C
C  PERFORM FFT
C
      CALL CFTFAX (NS, IFAC, WRK)
      CALL CFFTMLT (X, X(2), WRK(IW), WRK, IFAC, NT2, 2, NS, NT, JDIR)
      IF (IDIR .GE. 0) CALL VSMUL (X, 1, SCALE, X, 1, 2*NS*NT)
C
  800 CONTINUE
      RETURN
      END
 
