C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CFTLP                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       FINDS A VECTOR OF VALUES OF A COMPLEX VALUED FUNCTION OF A     *
C       REAL VARIABLE BY MEANS OF A TABLE LOOK-UP.                     *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CFTLP  (TABLE,X,IX,ZR,ZI,IZ,N,ICFLG,IERR)                       *
C      CCFTLP  (TABLE,X,IX,ZR,ZI,IZ,N,ICFLG,IERR)                      *
C      XCFTLP  (TABLE,X,IX,ZR,ZI,IZ,N,ICFLG,IERR)                      *
C  ARGUMENTS:                                                          *
C      TABLE   REAL*8   ??IOU*  (*) -                                  *
C      X       REAL     ??IOU*  (*) -                                  *
C      IX      INTEGER  ??IOU*      -                                  *
C      ZR      REAL     ??IOU*  (*) -                                  *
C      ZI      REAL     ??IOU*  (*) -                                  *
C      IZ      INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      ICFLG   INTEGER  ??IOU*      -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C        1  2 VERSION:  1 -2 ASSEMBLY LANGUAGE                         *
C        1  XEA VERSION:  1  FORTRAN 77 (CFT77)                        *
C       OTHERS: FORTAN 77                                              *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAR 90          R.D. COLEMAN, QTC      *
C       REVISION 2.0            APR 92          T.C. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  CFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C       CALL CCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C       CALL XCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)         *
C                                                                      *
C  PARAMETERS:                                                         *
C       TABLE   WORD INPUT VECTOR OF IMPLIED LENGTH                    *
C               TABLE OF PACKED VALUES AND PARAMETERS:                 *
C                 WORD  FORMAT   CONTENTS                              *
C                    1  INTEGER  NTAB   - TOTAL LENGTH OF TABLE        *
C                    2  REAL     SCALE  - INDEX SCALE FACTOR           *
C                    3  REAL     OFFSET - INDEX OFFSET VALUE           *
C                    4  REAL     XMIN   - MINIMUM VALID ARGUMENT       *
C                    5  REAL     XMAX   - MAXIMUM VALID ARGUMENT       *
C               6:NTAB  PACKED   COMPLEX FUNCTION VALUES               *
C                                                                      *
C       X       REAL INPUT VECTOR OF LENGTH N                          *
C               SOURCE VECTOR                                          *
C                                                                      *
C       IX      INTEGER INPUT SCALAR                                   *
C               STRIDE OF VECTOR X                                     *
C                                                                      *
C       ZR      REAL OUTPUT VECTOR OF LENGTH N                         *
C               REAL COMPONENT OF RESULT VECTOR                        *
C                                                                      *
C       ZI      REAL OUTPUT VECTOR OF LENGTH N                         *
C               IMAGINARY COMPONENT OF RESULT VECTOR                   *
C                                                                      *
C       IZ      INTEGER INPUT SCALAR                                   *
C               STRIDE OF VECTORS ZR AND ZI                            *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               LENGTH OF VECTORS X, ZR, AND ZI.                       *
C                                                                      *
C       ICFLG   INTEGER INPUT SCALAR                                   *
C               CONJUGATE FLAG:                                        *
C                  = 0  FUNCTION VALUE RETURNED                        *
C                 != 0  CONJUGATE OF FUNCTION VALUE RETURNED           *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               COMPLETION CODE.  VALUES ARE:                          *
C                  0 - NORMAL COMPLETION                               *
C                  1 - ONE OR MORE INPUT VALUES ARE LESS THAN XMIN     *
C                  2 - ONE OR MORE INPUT VALUES ARE GREATER THAN XMAX  *
C                  3 - BOTH CONDITIONS 1 AND 2 OCCURRED.               *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THIS ROUTINE FINDS A VECTOR OF VALUES OF A COMPLEX VALUED      *
C       FUNCTION OF A REAL VARIABLE BY MEANS OF A TABLE LOOK-UP.       *
C       THE FUNCTION IS OF THE FORM Z = F(X), WHERE X IS REAL AND Z IS *
C       COMPLEX.  THE TABLE CONTAINS N = NTAB-5 VALUES OF THE FUNCTION *
C       CORRESPONDING TO N EQUALLY SPACED VALUES OF X BETWEEN XMIN AND *
C       XMAX, INCLUSELY. THE REAL AND IMAGINARY COMPONENTS OF EACH     *
C       COMPLEX VALUE ARE PACKED INTO A SINGLE 64-BIT WORD.  THE REAL  *
C       COMPONENT IS CONTAINED IN THE MOST SIGNIFICANT 32 BITS AND THE *
C       IMAGINARY COMPONENT IS CONTAINED IN THE LEAST SIGNIFICANT 32   *
C       BITS.  THE FORMAT OF EACH COMPONENT IS THE SAME AS THE  1      *
C       REAL FORMAT EXCEPT THAT THE MANTISSA IS 16 BITS INSTEAD OF 48  *
C       BITS.                                                          *
C                                                                      *
C       FOR EACH ELEMENT OF THE SOURCE VECTOR, X(J), A TABLE INDEX IS  *
C       CALCULTED: I = IFIX( SCALE * X(J) + OFFSET ).   IF X(J) < XMIN,*
C       THEN I IS SET TO THE FIRST TABLE ENTRY (6) AND BIT 0 OF IERR IS*
C       SET TO 1.  IF X(J) > XMAX, THEN I IS SET TO THE LAST TABLE ENTR*
C       (NTAB) AND BIT 1 OF IERR IS SET TO 1.  TABLE(I) IS THEN UNPACKE*
C       AND THE REAL AND IMAGINARY CONPONENTS PLACED IN ZR(J) AND ZI(J)*
C       RESPECTIVELY.                                                  *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CFT77 INTRINSICS: AND, SHIFTL (IN  1  VERSIONS ONLY)           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF ANY ELEMENT OF THE SOURCE VECTOR HAS A VALUE OUTSIDE THE    *
C       VALID RANGE, THEN THE APPROPRIATE COMPLETION CODE IS SET (SEE  *
C       ABOVE), A DEFAULT RESULT IS SUPPLIED (SEE ABOVE), AND PROCESSIN*
C       CONTINUES.                                                     *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: CFTLP     COMPLEX FUNCTION TABLE LOOK-UP       REV 2.0  APR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  CFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
      ENTRY      CCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
      ENTRY      XCFTLP (TABLE, X, IX, ZR, ZI, IZ, N, ICFLG, IERR)
C
C  PARAMETERS:
C
      INTEGER IX, IZ, N, ICFLG, IERR
      REAL    X(*), ZR(*), ZI(*)
#ifdef CRAY
      REAL    TABLE(*)
#else
      REAL*8  TABLE(*)
#endif
C
C  LOCAL VARIABLES:
C
      INTEGER NTAB, I, J, JX, JZ
      REAL    SCALE, OFFSET, XMIN, XMAX, SGN
      LOGICAL LO, HI, ERRLO, ERRHI
C
#ifdef CRAY
      INTEGER MASK
      REAL    XNTAB, TABI
C
      EQUIVALENCE (NTAB, XNTAB)
C
      PARAMETER (MASK = x'FFFFFFFF00000000')
#else
      REAL    TABI2(2)
      REAL*8  TABI, XNTAB
C
      EQUIVALENCE (TABI, TABI2), (NTAB, XNTAB)
#endif
C
C-----------------------------------------------------------------------
C
      IERR = 0
      IF (N .LE. 0) RETURN
C
      XNTAB  = TABLE(1)
      SCALE  = TABLE(2)
      OFFSET = TABLE(3)
      XMIN   = TABLE(4)
      XMAX   = TABLE(5)
C
      IF (ICFLG .EQ. 0) THEN
         SGN = 1.0
      ELSE
         SGN = -1.0
      ENDIF
C
      ERRLO = .FALSE.
      ERRHI = .FALSE.
      JX    = 1
      JZ    = 1
      DO 110 J = 1, N
         LO    = X(JX) .LT. XMIN
         HI    = X(JX) .GT. XMAX
         ERRLO = ERRLO .OR. LO
         ERRHI = ERRHI .OR. HI
C
         I = IFIX( SCALE * X(JX) + OFFSET )
#ifdef CRAY
         I = CVMGT(    6, I, LO )
         I = CVMGT( NTAB, I, HI )
#else
         IF( LO ) I = 6
         IF( HI ) I = NTAB
#endif
C
         TABI   = TABLE(I)
#ifdef CRAY
         ZR(JZ) = AND( TABI, MASK )
         ZI(JZ) = SHIFTL( TABI, 32 ) * SGN
#else
         ZR(JZ) = TABI2(1)
         ZI(JZ) = TABI2(2) * SGN
#endif
C
         JX = JX + IX
         JZ = JZ + IZ
  110 CONTINUE
C
      IF (ERRLO) IERR = IERR + 1
      IF (ERRHI) IERR = IERR + 2
      RETURN
      END
 
