 
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CXF2D                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CXF2D  (K,S,W,P,DZ,B,C,NK,NS,NW,NP,ISW,W1,W2,IW3,TABLE,IERR)    *
C      XCXF2D  (K,S,W,P,DZ,B,C,NK,NS,NW,NP,ISW,W1,W2,IW3,TABLE,IERR)   *
C  ARGUMENTS:                                                          *
C      K       REAL     ??IOU*  (*) -                                  *
C      S       REAL     ??IOU*  (*) -                                  *
C      W       REAL     ??IOU*  (*) -                                  *
C      P       REAL     ??IOU*  (*) -                                  *
C      DZ      REAL     ??IOU*  (*) -                                  *
C      B       REAL     ??IOU*      -                                  *
C      C       REAL     ??IOU*  (*) -                                  *
C      NK      INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      NW      INTEGER  ??IOU*      -                                  *
C      NP      INTEGER  ??IOU*      -                                  *
C      ISW     INTEGER  ??IOU*      -                                  *
C      W1      REAL     ??IOU*  (*) -                                  *
C      W2      REAL     ??IOU*  (*) -                                  *
C      IW3     INTEGER  ??IOU*  (*) -                                  *
C      TABLE   REAL*8   ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CCFTLP -                                                        *
C      WHENFL -                                                        *
C      GATHER -                                                        *
C      SCATTE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      EXP     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C      MOD     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       CXF2D                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES THE 2D COMPLEX EXPONENTIAL PHASE-SHIFT FUNCTION BY    *
C       MEANS OF A PACKED TABLE LOOKUP.  THIS ROUTINE DIFFERS IN TWO   *
C       WAYS FROM XCXFTP: (1) ITS FOR 2D ONLY; I.E., THERE IS ONLY     *
C       ONE K VECTOR AND ONE P VECTOR, AND (2) IT IS FOR V OF Z ONLY;  *
C       I.E., DZ IS ASSUMED TO BE A FUNCTION OF SLOWNESS: THUS, THE    *
C       VECTORS S AND DZ MUST BE THE SAME LENGTH AND ARE INDEXED BY    *
C       THE SAME INDEX.                                                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      CXF2D  (K,S,W,P,DZ,B,C,NK,NS,NW,NP,ISW,W1,W2,IW3,TABLE,IERR)    *
C      XCXF2D  (K,S,W,P,DZ,B,C,NK,NS,NW,NP,ISW,W1,W2,IW3,TABLE,IERR)   *
C  ARGUMENTS:                                                          *
C      K       REAL     ??IOU*  (*) -                                  *
C      S       REAL     ??IOU*  (*) -                                  *
C      W       REAL     ??IOU*  (*) -                                  *
C      P       REAL     ??IOU*  (*) -                                  *
C      DZ      REAL     ??IOU*  (*) -                                  *
C      B       REAL     ??IOU*      -                                  *
C      C       REAL     ??IOU*  (*) -                                  *
C      NK      INTEGER  ??IOU*      -                                  *
C      NS      INTEGER  ??IOU*      -                                  *
C      NW      INTEGER  ??IOU*      -                                  *
C      NP      INTEGER  ??IOU*      -                                  *
C      ISW     INTEGER  ??IOU*      -                                  *
C      W1      REAL     ??IOU*  (*) -                                  *
C      W2      REAL     ??IOU*  (*) -                                  *
C      IW3     INTEGER  ??IOU*  (*) -                                  *
C      TABLE   REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 92/07/23  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                DEC 90          R.D. COLEMAN, QTC      *
C       REV 2.0                 FEB 92          R.D. COLEMAN, CETech   *
C               Portable FORTRAN version, added additional entry points*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  CXF2D ( K,  S,  W,  P, DZ, B, C,                         *
C      &             NK, NS, NW, NP, ISW, W1, W2, IW3, TABLE, IERR)    *
C       CALL XCXF2D ( K,  S,  W,  P, DZ, B, C,                         *
C      &             NK, NS, NW, NP, ISW, W1, W2, IW3, TABLE, IERR)    *
C                                                                      *
C  PARAMETERS:                                                         *
C       K       REAL INPUT VECTOR OF LENGTH NK                         *
C               X WAVE NUMBERS                                         *
C                                                                      *
C       S       REAL INPUT VECTOR OF LENGTH NS                         *
C               SLOWNESS                                               *
C                                                                      *
C       W       REAL INPUT VECTOR OF LENGTH NW                         *
C               ANGULAR FREQUENCY                                      *
C                                                                      *
C       P       REAL INPUT VECTOR OF LENGTH NP                         *
C               X ANGLES                                               *
C                                                                      *
C       DZ      REAL INPUT VECTOR OF LENGTH NS                         *
C               DELTA Z                                                *
C                                                                      *
C       B       REAL INPUT SCALAR                                      *
C               MULTIPLIER (NORMALLY = 1.0 OR -1.0 TO SELECT SIGN      *
C               OF THE EXPONENT).                                      *
C                                                                      *
C       C       COMPLEX OUTPUT VECTOR OF LENGTH NC                     *
C               PHASE-SHIFT FUNCTION.                                  *
C               NC = NK * NS * NW * NP                                 *
C                                                                      *
C       NK      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR VECTOR K (MUST BE >= 1).             *
C                                                                      *
C       NS      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR VECTORS S AND DZ (MUST BE >= 1).     *
C                                                                      *
C       NW      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR VECTOR W (MUST BE >= 1).             *
C                                                                      *
C       NP      INTEGER INPUT SCALAR                                   *
C               ELEMENT COUNT FOR VECTOR P (MUST BE >= 1).             *
C                                                                      *
C       ISW     INTEGER INPUT SCALAR                                   *
C               FUNCTION SELECTOR SWITCH.                              *
C               IF ISW = 0 & Y < 0.0, THEN C(I) = EXP( -B * SQRT(-Y) ) *
C               IF ISW > 0 & Y < 0.0, THEN C(I) = 0.0                  *
C               IF ISW < 0 & Y < 0.0, THEN C(I) = 1.0                  *
C                                                                      *
C       W1      REAL SCRATCH VECTOR OF LENGTH NC                       *
C                                                                      *
C       W2      REAL SCRATCH VECTOR OF LENGTH NC                       *
C                                                                      *
C       IW3     INTEGER SCRATCH VECTOR OF LENGTH NC                    *
C                                                                      *
C       TABLE   REAL INPUT VECTOR OF IMPLIED LENGTH                    *
C               PACKED, COMPLEX FUNCTION TABLE AS GENERATED BY GCFTLP  *
C               WITH IFFLG = 2 AND XMIN = 0.0.                         *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               IERR = IERRHI + IERRLO, WHERE                          *
C                  IERRLO = 1, IF TABLE UNDERFLOW OCCURRED AND THE     *
C                              TABLE XMIN != 0.0.                      *
C                           0, OTHERWISE                               *
C                  IERRHI = 2, IF TABLE OVERFLOW OCCURRED.             *
C                         = 0, OTHERWISE                               *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE COMPUTATION OF THE COMPLEX OUTPUT VECTOR C FROM THE REAL   *
C       INPUT VECTORS K, S, W, P, AND DZ AND THE SCALAR B IS           *
C       IS DESCRIBED BY THE FOLLOWING FORTRAN EQUIVALENT.              *
C                                                                      *
C       REAL    K(*), S(*), W(*), P(*), DZ(*), B, X, Y                 *
C       COMPLEX C(*)                                                   *
C                                                                      *
C       I = 0                                                          *
C       DO 10 IP = 1, NP                                               *
C       DO 10 IW = 1, NW                                               *
C       DO 10 IS = 1, NS                                               *
C       DO 10 IK = 1, NK                                               *
C          I = I + 1                                                   *
C                                                                      *
C          Y = ( ( W(IW) * S(IS) ) ** 2                                *
C      &       - ( K(IK) - W(IW) * P(IP) ) ** 2 ) * DZ(IS)**2          *
C                                                                      *
C          X = B * SQRT( ABS( Y ) )                                    *
C                                                                      *
C          IF (Y .GE. 0.0) THEN                                        *
C             C(I) = ( COS(X), SIN(X) )                                *
C          ELSE IF (ISW .EQ. 0) THEN                                   *
C             C(I) = (EXP(-X), 0.0 )                                   *
C          ELSE IF (ISW .GT. 0) THEN                                   *
C             C(I) = ( 0.0, 0.0 )                                      *
C          ELSE                                                        *
C             C(I) = ( 1.0, 0.0 )                                      *
C          ENDIF                                                       *
C                                                                      *
C    10 CONTINUE                                                       *
C       RETURN                                                         *
C       END                                                            *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       FORTRAN INTRINSICS: SQRT, EXP                                  *
C       SCILIB ROUTINES   : WHENFLT, GATHER, SCATTER                   *
C       OTHER             : CCFTLP                                     *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF A TABLE LOOKUP ERROR OCCURS, THEN THE APPROPRIATE ERROR     *
C       CODE IS SET (SEE ABOVE) AND PROCESSING CONTINUES.              *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CCFTLP -                                                        *
C      WHENFL -                                                        *
C      GATHER -                                                        *
C      SCATTE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      EXP     GENERIC -                                               *
C      SQRT    GENERIC -                                               *
C      MOD     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: CXF2D     2D CMPLX EXP. FUNCTION (TABLE)       REV 2.0  FEB 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  CXF2D ( K,  S,  W,  P, DZ, B, C,
     &                   NK, NS, NW, NP, ISW, W1, W2, IW3, TABLE, IERR)
      ENTRY      XCXF2D ( K,  S,  W,  P, DZ, B, C,
     &                   NK, NS, NW, NP, ISW, W1, W2, IW3, TABLE, IERR)
C
      INTEGER NK, NS, NW, NP, N, ISW, IW3(*), IERR
 
#ifdef CRAY
      REAL    K(*), S(*), W(*), DZ(*), P(*),
     &        B, C(*), W1(*), W2(*), TABLE(*), KMWP, KMWPSQ
#else
      REAL    K(*), S(*), W(*), DZ(*), P(*),
     &        B, C(*), W1(*), W2(*), KMWP, KMWPSQ
      REAL*8  TABLE(*)
#endif
 
C
C---------------------------------------------------------------------
C
      N = NK * NS * NW * NP
      IF (NK .EQ. 1) GO TO 200
C
      I = 0
      DO 140 IP = 1, NP
         XP = P(IP)
         DO 130 IW = 1, NW
            XW = W(IW)
            WP = XW * XP
            DO 120 IS = 1, NS
               WS    = XW * S(IS)
               BDZ   = B * DZ(IS)
               WSSQ  = WS  * WS
               BDZSQ = BDZ * BDZ
               DO 110 IK = 1, NK
                  I     = I + 1
                  KMWP  = K(IK) - WP
                  W1(I) = (WSSQ - KMWP * KMWP) * BDZSQ
  110          CONTINUE
  120       CONTINUE
  130    CONTINUE
  140 CONTINUE
      GO TO 700
C
  200 CONTINUE
      I = 0
      DO 240 IP = 1, NP
         XP = P(IP)
         DO 230 IW = 1, NW
            XW     = W(IW)
            KMWP   = K(1) - XW * XP
            KMWPSQ = KMWP * KMWP
            DO 220 IS = 1, NS
               I     = I + 1
               WS    = XW * S(IS)
               BDZ   = B * DZ(IS)
               WSSQ  = WS  * WS
               BDZSQ = BDZ * BDZ
               W1(I) = (WSSQ - KMWPSQ) * BDZSQ
  220       CONTINUE
  230    CONTINUE
  240 CONTINUE
C
  700 CONTINUE
      IF (B .GE. 0.0) THEN
         ICFLG =  0
         SGN   = -1.0
      ELSE
         ICFLG =  1
         SGN   =  1.0
      ENDIF
C
      CALL CCFTLP (TABLE, W1, 1, C(1), C(2), 2, N, ICFLG, IERR)
C
CRDC  IF (AND(IERR,1) .EQ. 0 .OR. TABLE(4) .NE. 0.0) RETURN
      IF (MOD(IERR,2) .EQ. 0 .OR. TABLE(4) .NE. 0.0) RETURN
C
C  RESET BIT 0 OF IERR (Note: it must be set)
C
CRDC  IERR = AND( IERR, X'FFFFFFFFFFFFFFFE' )
      IERR = IERR - 1
C
      IF (ISW .LT. 0) RETURN
C
C  GET INDICES OF ARGUMENTS LESS THAN ZERO
C
      CALL WHENFLT (N, W1, 1, 0.0, IW3, M)
C
C  CALCULATE NEW REAL COMPONENTS FOR THOSE ELEMENTS
C  (NOTE: THE IMAGINARY COMPONENTS WILL ALREADY BE ZERO)
C
      IF (ISW .EQ. 0) THEN
         CALL GATHER  (M, W2, W1, IW3)
         DO 710 I = 1, M
            W2(I) = EXP( SGN * SQRT( - W2(I) ) )
  710    CONTINUE
      ELSE
         DO 720 I = 1, M
            W2(I) = 0.0
  720    CONTINUE
      ENDIF
C
C  CALCULATE THE INDICES OF THE REAL COMPONENTS
C
      DO 730 I = 1, M
         IW3(I) = IW3(I) + IW3(I) - 1
  730 CONTINUE
C
C  SCATTER THE NEW REAL COMPONENTS
C
      CALL SCATTER (M, C, IW3, W2)
C
      RETURN
      END
 
