C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       FFTFII                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Given a NX by NZ real matrix, this routine first expands it    *
C       in-place to a MK by NZ complex matrix (MK >= NK >= NX) and then*
C       computes NZ complex-to-complex forward fft's of length NK.     *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      FFTFII  (MK,NK,NX,NZ,WORK,DATA)                                 *
C  ARGUMENTS:                                                          *
C      MK      INTEGER  ??IOU*      -                                  *
C      NK      INTEGER  ??IOU*      -                                  *
C      NX      INTEGER  ??IOU*      -                                  *
C      NZ      INTEGER  ??IOU*      -                                  *
C      WORK    REAL     ??IOU*  (*) -                                  *
C      DATA    REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL FFTFII (MK, NK, NX, NZ, WORK, DATA)                       *
C                                                                      *
C  PARAMETERS:                                                         *
C       MK      INTEGER INPUT SCALAR.                                  *
C               Row dimension of DATA on output.                       *
C                                                                      *
C       NK      INTEGER INPUT SCALAR.                                  *
C               Number of complex elements per column on output.       *
C               NK must be <= MK and of the form 2**i * 3**j * 5**k    *
C               where i, j, and k are non-negative integers.           *
C                                                                      *
C       NX      INTEGER INPUT SCALAR.                                  *
C               Number of real elements per column on input (row       *
C               dimension of DATA on input).  NX must be <= NK.        *
C                                                                      *
C       NZ      INTEGER INPUT SCALAR.                                  *
C               Column dimension of DATA.                              *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH NWORK                    *
C               NWORK is system dependent. For Cray systems NWORK =    *
C               4*NK*NZ + 2*NK; otherwise NWORK = 6*NK + 18*NZ + 41.   *
C                                                                      *
C       DATA    REAL/COMPLEX INPUT/OUTPUT MATRIX OF VARIABLE DIMENSION *
C               On input, DATA is an NX by NZ real matrix.  On output, *
C               DATA is an MK by NZ complex matrix (see description for*
C               format) containing the NZ complex-to-complex fft's in  *
C               its NK by NZ principle submatrix.                      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       FFTFII first expands the NX by NZ real input matrix to a MK by *
C       NZ complex matrix in-place.  The imaginary components are set t*
C       zero and columns are padded with zeroes.  A complex-to-complex *
C       forward FFT of length NK is then performed on each of the NZ   *
C       columns.  The output data is put into natural order (as opposed*
C       to FFT order).                                                 *
C                                                                      *
C       * NOTE: The format used for storing the complex matrix is      *
C       architecture dependent.  Currently, all implementations use a  *
C       format where the real components occupy the first half of the  *
C       matrix and the imaginary components occupy the second half.    *
C       For simplification, the documentation reads as if a native     *
C       complex format is used.  Generally, the format is transparent  *
C       to the user since, normally, only other LIBMBS routines need to*
C       have direct access to the data and those routines will also    *
C       use the same architecture dependent format.                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       VCLR, VMOV, VSMUL, CFFTFAX, CFFTMLT                            *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      VCLR   -                                                        *
C      CFTFAX -                                                        *
C      CFFTML -                                                        *
C      VSMUL  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: FFTFII    FFT - FORWARD, INSERT IMAGINARIES    REV 1.0  NOV 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE FFTFII( MK, NK, NX, NZ, WORK, DATA )
C
C  SUBROUTINE PARAMETERS
C
      INTEGER MK, NK, NX, NZ
      REAL    WORK(*), DATA(*)
C
C  LOCAL VARIABLES
C
      INTEGER IFAC(19), IWRK, II, IR, JI, JR, JR1, JR2, JZ, NK1, NK2
C
C---------------------------------------------------------------------
C
C  EXPAND DATA
C
      JR1 = NX + NZ * NX
      JR2 = NX + NZ * MK
      DO 210 JZ = 1, NZ
         JR1 = JR1 - NX
         JR2 = JR2 - MK
         CALL VMOV( DATA(JR1), -1, DATA(JR2), -1, NX )
         CALL VCLR( DATA(JR2+1), 1, MK-NX )
  210 CONTINUE
C
      IR = 1
      II = IR + MK * NZ
C
      CALL VCLR( DATA(II), 1, MK*NZ )
C
C  INITIALIZE TRIG TABLE
C
      CALL CFTFAX( NK, IFAC, WORK )
C
C  PERFORM FFT'S
C
      IWRK = 2 * NK + 1
      CALL CFFTMLT( DATA(IR), DATA(II), WORK(IWRK), WORK, IFAC, 1,
     &              MK, NK, NZ, -1 )
C
C  SCALE AND PUT DATA IN NATURAL ORDER
C
      SCALE = 1.0 / FLOAT( NK )
      NK1 = NK / 2 + 1
      NK2 = NK - NK1
      JR  = IR
      JI  = II
      DO 110 JZ = 1, NZ
         CALL VMOV  (DATA(JR    ), 1, WORK, 1, NK1)
         CALL VSMUL (DATA(JR+NK1), 1, SCALE, DATA(JR    ), 1, NK2)
         CALL VSMUL (WORK        , 1, SCALE, DATA(JR+NK2), 1, NK1)
         CALL VMOV  (DATA(JI    ), 1, WORK, 1, NK1)
         CALL VSMUL (DATA(JI+NK1), 1, SCALE, DATA(JI    ), 1, NK2)
         CALL VSMUL (WORK        , 1, SCALE, DATA(JI+NK2), 1, NK1)
         JR = JR + MK
         JI = JI + MK
  110 CONTINUE
C
      RETURN
      END
