C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       GETDZ                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       GETDZ reads the delta Z parameter from a V of Z migration card *
C       file and then rewinds the file.                                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      GETDZ  (LUCRD,DZ,IERR)                                          *
C  ARGUMENTS:                                                          *
C      LUCRD   INTEGER  ??IOU* -                                       *
C      DZ      REAL     ??IOU* -                                       *
C      IERR    INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL GETDZ( LUCRD, DZ, IERR )                                  *
C                                                                      *
C  PARAMETERS:                                                         *
C       LUCRD   INTEGER INPUT SCALAR                                   *
C               Logical unit number of card file.                      *
C                                                                      *
C       DZ      REAL OUTPUT SCALAR                                     *
C               Delta Z.                                               *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               Completion code.  Returns a zero for normal completion.*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C       Card file.  A parameter card file that contains delta Z in F10.*
C       format in columns 21 through 30 of the first record that follow*
C       the first record that contains 'DEPTH' in columns 1 through 5; *
C       otherwise, returns one.                                        *
C                                                                      *
C      LUCRD  ( INPUT  SEQUENTIAL ) -                                  *
C  DESCRIPTION:                                                        *
C       GETDZ first rewinds the card file, then searchs for the first  *
C       occurance of 'DEPTH' at the beginning of a record.  After      *
C       finding the depth template record, it reads columns 21 through *
C       30 the the next record under F10.0 format and returns the value*
C       in DZ.  The card file is then rewound.                         *
C                                                                      *
C  EXAMPLE:                                                            *
C       Card file (opened as logical unit 21):                         *
C                           11111111112222222222333333333344444444445  *
C          Column: 12345678901234567890123456789012345678901234567890  *
C                                                                      *
C                  TIME       ENDTIMEMS PADTIMEMS BEGTIMEMS      DTMS  *
C                  TIME            2000       200       100            *
C                  FREQUENCY  MINFREQHZ  F2FREQHZ  F3FREQHZ MAXFREQHZ  *
C                  FREQUENCY         20        25        55        60  *
C                  DEPTH      MAX DEPTH   DELTA Z                      *
C                  DEPTH          10000        50                      *
C                  WIDTH         DELTAX  BEGTRACE  NO.TRACE            *
C                  WIDTH             80                                *
C                  MODEL                REF VELOC BEAMWIDTH  PADTRACE  *
C                  MODEL                     8000        10            *
C                                                                      *
C       Inputs:                                                        *
C               LUCRD  = 21                                            *
C                                                                      *
C       Outputs:                                                       *
C               DZ     = 50.0                                          *
C               IERR   =  0                                            *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       If an I/O error occurs, or a format conversion error occurs, or*
C       a premature end-of-file is encountered, then IERR is set to 1  *
C       and the routine is aborted.                                    *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: GETDZ     GET DELTA Z                          REV 1.0  NOV 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine getdz( lucrd, dz, ierr )
 
      integer   lucrd, ierr
      real      dz
      character card*80
 
C-----------------------------------------------------------------------
 
  900 format( a80 )
  901 format( 20x, f10.0 )
 
C-----------------------------------------------------------------------
 
      rewind( unit=lucrd, err=800 )
 
  100 continue
         read( lucrd, 900, end=800, err=800 ) card
         if( card(1:5) .ne. 'DEPTH' ) go to 100
 
      read( lucrd, 901, end=800, err=800 ) dz
      rewind( unit=lucrd, err=800 )
 
      ierr = 0
      return
 
  800 continue
      ierr = 1
      return
 
      end
