C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       GGRID                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       GGRID GENERATES A PIECEWISE REGULAR GRID.                      *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      GGRID  (NZSEG,IZSNZ,ZSDZ,ZGRID)                                 *
C  ARGUMENTS:                                                          *
C      NZSEG   INTEGER  ??IOU*          -                              *
C      IZSNZ   INTEGER  ??IOU*  (NZSEG) -                              *
C      ZSDZ    REAL     ??IOU*  (NZSEG) -                              *
C      ZGRID   REAL     ??IOU*  (*)     -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL GGRID( NZSEG, IZSNZ, ZSDZ, ZGRID )                        *
C                                                                      *
C  PARAMETERS:                                                         *
C       NZSEG   INTEGER INPUT SCALAR                                   *
C               Number of Z segments.                                  *
C                                                                      *
C       IZSNZ   INTEGER INPUT VECTOR OF LENGTH NZSEG                   *
C               IZSNZ(i) is the number of Z steps in the i-th Z segment*
C                                                                      *
C       ZSDZ    REAL INPUT VECTOR OF LENGTH NZSEG                      *
C               ZSDZ(i) is the delta Z for the i-th Z segment.         *
C                                                                      *
C       ZGRID   REAL OUTPUT VECTOR OF DIMENSION NZT                    *
C               Result grid.  NZT = SUM[ IZSNZ(i), i = 1, NZSEG ]      *
C                                                                      *
C  DESCRIPTION:                                                        *
C       GGRID calculates a vector of values for a piece wise regularly *
C       spaced grid.  The grid is specified by the number of segments  *
C       (pieces), NZSEG, the number of steps in each segment, IZSNZ(i),*
C       and the step size in each segment, ZSDZ(i).                    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       None.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       None.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: GGRID    GENERATE GRID (PIECE-WISE REGULAR)    REV 1.0  NOV 91 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE GGRID( NZSEG, IZSNZ, ZSDZ, ZGRID )
C
C  SUBROUTINE ARGUMENTS
C
      INTEGER NZSEG, IZSNZ(NZSEG)
      REAL    ZSDZ(NZSEG), ZGRID(*)
C
C  LOCAL VARIABLES
C
      INTEGER JZ, JZSEG, KZ
      REAL    DLTZ, Z
C
C-----------------------------------------------------------------------
C
      KZ = 0
      Z  = 0.0
      DO 120 JZSEG = 1, NZSEG
         DLTZ = ZSDZ(JZSEG)
         DO 110 JZ = 1, IZSNZ(JZSEG)
            KZ = KZ + 1
            Z  = Z  + DLTZ
            ZGRID(KZ) = Z
  110    CONTINUE
  120 CONTINUE
C
      RETURN
      END
