C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       NCFFT5                                               *
C  ROUTINE TYPE:  FUNCTION  INTEGER                                    *
C  PURPOSE:                                                            *
C       FINDS THE SMALLEST VALID NUMBER, M, FOR USE IN CFFTMLT THAT IS *
C       GREATER THAN OR EQUAL TO A GIVEN NUMBER, N.                    *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      NCFFT5  INTEGER  (N)                                            *
C  ARGUMENTS:                                                          *
C      N       INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                MAY 88          R.D. COLEMAN, QTC      *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       M = NCFFT5 (N)                                                 *
C                                                                      *
C  PARAMETERS:                                                         *
C       N       INTEGER INPUT SCALAR                                   *
C                                                                      *
C       M       INTEGER OUTPUT SCALAR                                  *
C                                                                      *
C  DESCRIPTION:                                                        *
C       GIVEN THE INTEGER INPUT, N, THE FUNCTION RETURNS THE INTEGER   *
C       M SUCH THAT M IS THE SMALLEST NUMBER GREATER THAN OR EQUAL TO  *
C       N SUCH THAT M = 2**I * 3**J * 5**K WHERE I, J, AND K ARE       *
C       NON-NEGATIVE INTEGERS.                                         *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE                                                           *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: NCFFT5    N FUNCTION FOR CFFTMLT               REV 1.0  MAY 88 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      FUNCTION NCFFT5 (N)
C
      PARAMETER (MAX = 166)
C
      INTEGER NUM(MAX)
C
      DATA NUM /
     &        2,    3,    4,    5,    6,    8,    9,   10,   12,   15,
     &       16,   18,   20,   24,   25,   27,   30,   32,   36,   40,
     &       45,   48,   50,   54,   60,   64,   72,   75,   80,   81,
     &       90,   96,  100,  108,  120,  125,  128,  135,  144,  150,
     &      160,  162,  180,  192,  200,  216,  225,  240,  243,  250,
     &      256,  270,  288,  300,  320,  324,  360,  375,  384,  400,
     &      405,  432,  450,  480,  486,  500,  512,  540,  576,  600,
     &      625,  640,  648,  675,  720,  729,  750,  768,  800,  810,
     &      864,  900,  960,  972, 1000, 1024, 1080, 1125, 1152, 1200,
     &     1215, 1250, 1280, 1296, 1350, 1440, 1458, 1500, 1536, 1600,
     &     1620, 1728, 1800, 1875, 1920, 1944, 2000, 2025, 2048, 2160,
     &     2187, 2250, 2304, 2400, 2430, 2500, 2560, 2592, 2700, 2880,
     &     2916, 3000, 3072, 3125, 3200, 3240, 3375, 3456, 3600, 3645,
     &     3750, 3840, 3888, 4000, 4050, 4096, 4320, 4374, 4500, 4608,
     &     4800, 4860, 5000, 5120, 5184, 5400, 5625, 5760, 5832, 6000,
     &     6075, 6144, 6250, 6400, 6480, 6561, 6750, 6912, 7200, 7290,
     &     7500, 7680, 7776, 8000, 8100, 8192/
C
C-----------------------------------------------------------------------
C
      IF (N .GT. NUM(MAX)) GO TO 200
C
      I1 = 0
      I2 = MAX
  100 CONTINUE
      I = (I1 + I2) / 2
      M = NUM(I)
      IF      (M .LT. N) THEN
         I1 = I
      ELSE IF (M .GT. N) THEN
         I2 = I
      ELSE
         GO TO 800
      ENDIF
      IF (I2 .GT. I1+1) GO TO 100
C
      M = NUM(I2)
      GO TO 800
C
  200 CONTINUE
      M = N - 1
  210 CONTINUE
         M = M + 1
         ITMP = M
C
  220    CONTINUE
            ITEST = ITMP / 2
            IF (2*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               GO TO 220
            ENDIF
C
  230    CONTINUE
            ITEST = ITMP / 3
            IF (3*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               GO TO 230
            ENDIF
C
  250    CONTINUE
            ITEST = ITMP / 5
            IF (5*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               GO TO 250
            ENDIF
C
         IF (ITMP .NE. 1) GO TO 210
C
  800 CONTINUE
      NCFFT5 = M
C
      RETURN
      END
 
