C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       PIE                                                  *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       FORTRAN EQUIVALENT OF ST-100 PROCESS PPIE.                     *
C       PERFORM A PIE FILTER ON AN NY BY NX COMPLEX MATRIX.            *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      PIE  (A,DPARM,WPARM,NX,NY,NP)                                   *
C      FPIE  (A,DPARM,WPARM,NX,NY,NP)                                  *
C  ARGUMENTS:                                                          *
C      A       REAL     ??IOU*  (2,NY,NX) -                            *
C      DPARM   REAL     ??IOU*  (6)       -                            *
C      WPARM   REAL     ??IOU*  (22)      -                            *
C      NX      INTEGER  ??IOU*            -                            *
C      NY      INTEGER  ??IOU*            -                            *
C      NP      INTEGER  ??IOU*            -                            *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUL 86          R.D. COLEMAN, QTC      *
C       REL 2.0                 JAN 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  PIE( A, DPARM, WPARM, NX, NY, NP )                       *
C       CALL FPIE( A, DPARM, WPARM, NX, NY, NP )                       *
C                                                                      *
C  PARAMETERS:                                                         *
C       A       COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION NY BY NX.     *
C                                                                      *
C       DPARM   REAL INPUT ARRAY OF LENGTH 6                           *
C               DISC FILTER PARAMETER ARRAY (SEE FDISC).               *
C                                                                      *
C       WPARM   REAL INPUT ARRAY OF DIMENSION 11 BY 2                  *
C               WEDGE FILTER PARAMETER ARRAY (SEE FWEDG).              *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.     *
C                                                                      *
C       NY      INTEGER INPUT SCALAR                                   *
C               NUMBER OF Y'S - ROW DIMENSION OF INPUT MATRIX.         *
C                                                                      *
C       NP      INTEGER INPUT SCALAR.                                  *
C               NOT USED BY THE FORTRAN VERSION.                       *
C                                                                      *
C  DESCRIPTION:                                                        *
C       PERFORMS A PIE FILTER BY CASCADING A DISC FILTER AND A         *
C       WEDGE FILTER (SEE FDISC AND FWEDG).                            *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       FDSCI, FDSCO, FWEDG                                            *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE                                                           *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FDSCI -                                                         *
C      FDSCO -                                                         *
C      FWEDG -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: PIE       PIE FILTER                           REL 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  PIE( A, DPARM, WPARM, NX, NY, NP )
      ENTRY      FPIE( A, DPARM, WPARM, NX, NY, NP )
C
      INTEGER NX, NY
      REAL    A(2,NY,NX), DPARM(6), WPARM(22), DPARI(4), DPARO(4)
C
C---------------------------------------------------------------------
C
      DPARI(1) = DPARM(1)
      DPARI(2) = DPARM(2)
      DPARI(3) = DPARM(3)
      DPARI(4) = DPARM(4)
C
      DPARO(1) = DPARM(1)
      DPARO(2) = DPARM(2)
      DPARO(3) = DPARM(5)
      DPARO(4) = DPARM(6)
C
      CALL FDSCI (A, DPARI, NX, NY, NP)
      CALL FDSCO (A, DPARO, NX, NY, NP)
      CALL FWEDG (A, WPARM, NX, NY, NP)
C
      RETURN
      END
 
