C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RCFT2                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       COMPUTES N3 COMPLEX TO COMPLEX INVERSE FFT'S AND SAVES ONLY    *
C       THE REAL COMPONENTS OF FIRST N2 ELEMENTS.                      *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RCFT2  (XR,XI,M1,N1,N2,N3,INIT,TAB,WRK,IERR)                    *
C      XRCFT2  (XR,XI,M1,N1,N2,N3,INIT,TAB,WRK,IERR)                   *
C  ARGUMENTS:                                                          *
C      XR      REAL     ??IOU*  (*) -                                  *
C      XI      REAL     ??IOU*  (*) -                                  *
C      M1      INTEGER  ??IOU*      -                                  *
C      N1      INTEGER  ??IOU*      -                                  *
C      N2      INTEGER  ??IOU*      -                                  *
C      N3      INTEGER  ??IOU*      -                                  *
C      INIT    INTEGER  ??IOU*      -                                  *
C      TAB     REAL     ??IOU*  (*) -                                  *
C      WRK     REAL     ??IOU*  (*) -                                  *
C      IERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                JUL 88          R.D. COLEMAN, QTC      *
C       REL 2.0                 APR 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL  RCFT2 (XR, XI, M1, N1, N2, N3, INIT, TAB, WRK, IERR)     *
C       CALL XRCFT2 (XR, XI, M1, N1, N2, N3, INIT, TAB, WRK, IERR)     *
C                                                                      *
C  PARAMETERS:                                                         *
C       XR      REAL INPUT/OUTPUT MATRIX OF VARIABLE DIMENSION         *
C               ON INPUT, XR CONTAINS AN N1 BY N3 REAL SUBMATRIX THAT I*
C               THE REAL COMPONENTS OF N3 COMPLEX TRACES EACH OF LENGTH*
C               N1.  ON OUTPUT, XR CONTAINS AN N2 BY N3 REAL MATRIX THA*
C               IS THE REAL COMPONENTS OF THE FIRST N2 ELEMENTS OF THE *
C               INVERSE COMPLEX-TO-COMPLEX FFT OF EACH TRACE.          *
C                                                                      *
C       XI      REAL INPUT MATRIX OF DIMENSION M1 BY N3                *
C               ON INPUT, XI CONTAINS AN N1 BY N3 REAL SUBMATRIX THAT I*
C               THE IMAGINARY COMPONENTS OF N3 COMPLEX TRACES EACH OF  *
C               LENGTH N1.                                             *
C                                                                      *
C       M1      INTEGER INPUT SCALAR.                                  *
C               ROW DIMENSION OF XR AND XI ON INPUT.                   *
C                                                                      *
C       N1      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF COMPLEX SAMPLES PER TRACE ON INPUT.          *
C               N1 MUST BE <= M1 AND OF THE FORM 2**I * 3**J * 5**K    *
C               WHERE I, J, AND K ARE NON-NEGATIVE INTEGERS.           *
C                                                                      *
C       N2      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF REAL SAMPLES PER TRACE ON OUTPUT (ROW        *
C               DIMENSION OF XR ON OUTPUT).  N2 MUST BE <= N1.         *
C                                                                      *
C       N3      INTEGER INPUT SCALAR.                                  *
C               NUMBER OF TRACES (COLUMN DIMENSION OF XR AND XI).      *
C                                                                      *
C       INIT    INTEGER INPUT SCALAR.                                  *
C               INITIALIZATION FLAG.  IF INIT <> 0, THEN PERFORM       *
C               INITIALIZATION OF TAB.                                 *
C                                                                      *
C       TAB     REAL INPUT/OUTPUT VECTOR OF LENGTH 2 * N1.             *
C               FFT COEFFICIENT TABLE.  INPUT IF INIT = 0; OTHERWISE,  *
C               COMPUTED WITHIN THIS ROUTINE.                          *
C                                                                      *
C       WRK     REAL SCRATCH VECTOR OF LENGTH 4 * N1 * N3.             *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR.                                 *
C               COMPLETION CODE.  IERR = 0 FOR NORMAL COMPLETION;      *
C               OTHERWISE, IT IS SET TO THE SUM OF THE CONDITION CODES *
C               THAT APPLY.  THE CONDITION CODE VALUES ARE:            *
C                   1 - THE VALUE OF M1 IS INVALID                     *
C                   2 - THE VALUE OF N1 IS INVALID                     *
C                   4 - THE VALUE OF N2 IS INVALID                     *
C                   8 - THE VALUE OF N3 IS INVALID                     *
C                                                                      *
C  DESCRIPTION:                                                        *
C       XRCFT2 PERFORMS A COMPLEX-TO-COMPLEX INVERSE FFT ON N3 TRACES  *
C       EACH OF LENGTH N1.  THE REAL COMPONENTS OF THE N3 TRACES ARE   *
C       STORED AS COLUMNS OF AN N1 BY N3 REAL SUBMATRIX OF THE M1 BY N3*
C       REAL MATRIX XR.  THE IMAGINARY COMPONENTS ARE SIMILARLY STORED *
C       STORED IN THE N1 BY M3 REAL SUBMATRIX SUBMATRIX XI.  ONLY THE  *
C       REAL COMPONENTS OF THE FIRST N2 ELEMENTS OF EACH RESULTING TRAC*
C       ARE SAVED.  THE SELECTED RESULTS ARE COMPRESSED TO FORM AN N2 B*
C       N3 REAL MATRIX IN THE FIRST N2*N3 WORDS OF XR.  THE REMAINER OF*
C       XR IS NOT USED ON OUTPUT.                                      *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       CRAY SCILIB: CFFTFAX, CFFTMLT                                  *
C       OTHERS     : NCFFT5                                            *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF ANY OF THE PARAMETERS M1, N1, N2, OR N3 HAS A VALUE OUTSIDE *
C       ITS VALID RANGE (SEE ABOVE), THEN THE APPROPRIATE COMPLETION   *
C       CODE IS SET (SEE ABOVE) AND THE PROCESS IS ABORTED.            *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      NCFFT5  INTEGER -                                               *
C      CFTFAX          -                                               *
C      CFFTML          -                                               *
C      VMOV            -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: RCFT2     REALS OF COMPLEX FFT (LOOPING)       REV 2.0  APR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  RCFT2 (XR, XI, M1, N1, N2, N3, INIT, TAB, WRK, IERR)
      ENTRY      XRCFT2 (XR, XI, M1, N1, N2, N3, INIT, TAB, WRK, IERR)
C
      REAL    XR(*), XI(*), TAB(*), WRK(*)
      INTEGER M1, N1, N2, N3, INIT, IERR, IFAC(19)
C
      SAVE    IFAC
C
C---------------------------------------------------------------------
C
C  CHECK PARAMETERS FOR VALIDITY
C
      K1 = NCFFT5( N1 )
C
      IERR = 0
      IF (M1 .LE.  0                ) IERR = IERR + 1
      IF (N1 .NE. K1 .OR. N1 .GT. M1) IERR = IERR + 2
      IF (N2 .LE.  0 .OR. N2 .GT. N1) IERR = IERR + 4
      IF (N3 .LE.  0                ) IERR = IERR + 8
C
      IF (IERR .NE. 0) GO TO 800
C
C  IF INIT <> 0, INITIALIZE TRIG TABLE
C
      IF (INIT .NE. 0) CALL CFTFAX (N1, IFAC, TAB)
C
C  PERFORM FFT'S
C
      CALL CFFTMLT (XR, XI, WRK, TAB, IFAC, 1, M1, N1, N3, 1)
C
C  COMPRESS SELECTED RESULTS
C
      IX = 1
      JX = 1
      DO 210 JT = 1, N3
         CALL VMOV (XR(IX), 1, XR(JX), 1, N2)
         IX = IX + M1
         JX = JX + N2
  210 CONTINUE
C
  800 CONTINUE
      RETURN
      END
 
