C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RDPIC                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Read an 'xsd' pick file which consists of a 'Units' card       *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RDPIC  (REC,TRAC,SAMP,ICOLOR,NAME,NPICKS,UNITS,OFFSET,MAXSEG,   *
C              NO_SEG,MAXPNT,NO_PNT,SZSMPD,NREC,NTRAC,NSAMP,LPRT,      *
C              LPCK,JERR)                                              *
C  ARGUMENTS:                                                          *
C      REC     REAL     ??IOU*  (*) -                                  *
C      TRAC    REAL     ??IOU*  (*) -                                  *
C      SAMP    REAL     ??IOU*  (*) -                                  *
C      ICOLOR  INTEGER  ??IOU*  (*) -                                  *
C      NAME    CHAR*20  ??IOU*  (*) -                                  *
C      NPICKS  INTEGER  ??IOU*  (*) -                                  *
C      UNITS   REAL     ??IOU*  (*) -                                  *
C      OFFSET  REAL     ??IOU*  (*) -                                  *
C      MAXSEG  INTEGER  ??IOU*      -                                  *
C      NO_SEG  INTEGER  ??IOU*      -                                  *
C      MAXPNT  INTEGER  ??IOU*      -                                  *
C      NO_PNT  INTEGER  ??IOU*      -                                  *
C      SZSMPD  INTEGER  ??IOU*      -                                  *
C      NREC    INTEGER  ??IOU*      -                                  *
C      NTRAC   INTEGER  ??IOU*      -                                  *
C      NSAMP   INTEGER  ??IOU*      -                                  *
C      LPRT    INTEGER  ??IOU*      -                                  *
C      LPCK    INTEGER  ??IOU*      -                                  *
C      JERR    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 93/08/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C  CALLING FORMAT:                                                     *
C                call rdpic(rec,trac,samp,icolor,name,npicks,          *
C    &           units,offset,maxseg,no_seg,maxpnt,no_pnt,szsmpd,      *
C    &           nrec,ntrac,nsamp,lprt,lpck,jerr)                      *
C                                                                      *
C  PARAMETERS:                                                         *
C    rec        real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the x points                   *
C                                                                      *
C    trac       real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the y points                   *
C                                                                      *
C    samp       real array input/output array of length maxseg*maxpnt  *
C               This must be dimensioned in the calling routine        *
C               This array will contain the z points                   *
C                                                                      *
C    icolor     integer array input/output array of length maxseg      *
C               This must be dimensioned in the calling routine        *
C               This array will contain the segments' color numbers    *
C                                                                      *
C    name       Character*20 array input/output array of length maxseg *
C               This must be dimensioned in the calling routine        *
C               This array will contain the segments' names            *
C                                                                      *
C    npicks     Integer input/output array of length maxseg            *
C               This must be dimensioned in the calling routine        *
C               npicks(1) = the number of points in segment one        *
C               npicks(2) = the number of points in segment two, etc.  *
C                                                                      *
C    units      Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Units measure for the x,y,z points read from file      *
C               units(1) = Units measure for the x points              *
C               units(2) = Units measure for the y points              *
C               units(3) = Units measure for the z points              *
C                                                                      *
C    offset     Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Offsets measure of x,y,z points read from file         *
C               offset(1) = offset measure for the x points            *
C               offset(2) = offset measure for the y points            *
C               offset(3) = offset measure for the z points            *
C                                                                      *
C    maxseg     Integer input scalar                                   *
C               Maximum number of segments allowable by main           *
C                                                                      *
C    no_seg     Integer output scalar                                  *
C               Actual number of segments in the pick file             *
C                                                                      *
C    maxpnt     Integer input scalar                                   *
C               Maximum number of points/segment allowed by main       *
C                                                                      *
C    no_pnt     Integer output scalar                                  *
C               Actual maximum number of points in any one segment     *
C                                                                      *
C    szsmpd     Integer input scalar (defined in lhdrsz.h)             *
C               Size of data sample                                    *
C                                                                      *
C    nrec       Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    ntrac      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    nsamp      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    lprt       Integer input scalar                                   *
C               Logical unit of printout                               *
C                                                                      *
C    lpck       Integer input scalar                                   *
C               Logical unit of pick file                              *
C                                                                      *
C    jerr       Integer input/output scalar                            *
C               Error flag                                             *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr = 50  =   No Units card found                              *
C      jerr =100  =   No Segment card found for a segment              *
C      jerr =150  =   Error allocating space for segments              *
C      jerr =175  =   No valid segments found                          *
C      jerr =200  =   EOF encountered reading picks                    *
C      jerr =300  =   Error reading picks                              *
C                                                                      *
C***********************************************************************
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      CARD   ( INPUT  INTERNAL   ) -                                  *
C      CARDL  ( INPUT  INTERNAL   ) -                                  *
C      LPCK   ( INPUT  SEQUENTIAL ) -                                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: RDPIC     READ  PICKS                          REV 1.0  AUG 93 *
C  ROUTINE:       rdpic                                                *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine rdpic(rec,trac,samp,icolor,name,npicks,
     &           units,offset,maxseg,no_seg,maxpnt,no_pnt,szsmpd,
     &           nrec,ntrac,nsamp,lprt,lpck,jerr)
 
c     maxseg is maximum segments allowable
c     no_seg is maximum segments as read from the picks file
c     maxpnt is maximum points per segment allowable
c     no_pnt is maximum points per segment as read from the picks file
C
      integer szsmpd
      character*126 cardl
      character*80  card
      character*20  name(*)
      character*6   uword
      integer npicks(*), icolor(*)
      real rec(*), trac(*), samp(*), units(*), offset(*)
 
      jerr = 0
C     if (index(cardl,'U').ne.0) we read a Units card
   50 format(a126)
   75 format(a80)
      read(lpck,50,end=200)cardl
      if(index(cardl,'U').ne.0)then
         go to 90
      else
         write(lprt,*)' No Units card found'
         jerr =  50
         return
      endif
C     We have just read a Units card
   90 continue
      read(cardl,60,end=200,err=300)uword,
     &              units(1), units(2), units(3),
     &              nrec, ntrac, nsamp,
     &              offset(1), offset(2), offset(3),
     &              no_seg, no_pnt
   60 format(a6,3(f12.6,1x),3(i5,1x),7x,3(f12.6,1x),6x,i5,1x,i5)
 
cmat  write(lprt,*)uword,units(1),units(2),units(3),
cmat &             nrec,ntrac,nsamp,
cmat &             offset(1),offset(2),offset(3),
cmat &             no_seg,no_pnt
      if(no_pnt.gt.maxpnt)then
         write(lprt,*)'Error-There are ',no_pnt,' points in a segment'
         write(lprt,*)'The maximum number allowable is ',maxpnt
         jerr = 100
         return
      endif
      if(no_seg.gt.maxseg)then
         write(lprt,*)' Error - There are ',no_seg,' segments'
         write(lprt,*)' The maximum number allowable is ',maxseg
         jerr = 100
         return
      endif
 
C     if (index(card,'S').ne.0) we read a Segment card
      k = 0
      do 150 i=1,no_seg
         read(lpck,75,end=200,err=300)card
         if(index(card,'S').ne.0)then
            read(card,70,err=300)nseg,name(i),icolor(i),npicks(i)
   70       format(10x,i5,6x,a20,10x,i5,9x,i5)
cmat        write(lprt,*)nseg,name(i),icolor(i),npicks(i)
         else
            write(lprt,*)' No segment card found for segment ',i
            jerr = 100
            return
         endif
         do 100 j=1,npicks(i)
            k = k + 1
            read(lpck,80,end=200,err=300)rec(k),trac(k),samp(k)
cmat            write(lprt,*)rec(k),trac(k),samp(k)
   80       format(3(f12.6,1x))
  100    continue
  150 continue
      write(lprt,*)no_seg,' segments read successfully '
      return
  200 continue
      write(lprt,*)' reached end of file reading picks '
      write(lprt,*)' job terminated'
      jerr = 200
      return
  300 continue
      write(lprt,*)' Error reading picks.'
      write(lprt,*)' The picks may be in the old format.  You',
     &             ' should run:'
      write(lprt,*)' '
      write(lprt,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &                '_filename'
      write(lprt,*)' '
      write(lprt,*)'   to convert the picks to the new format'
      write(lprt,*)'   and then try running this program again.'
      jerr = 300
      return
      end
