C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       RDPICK                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       Read an 'xsd' pick file which consists of a 'Units' card       *
C       then sets of 'Segment' cards with the x, y, and z points       *
C       defining that segment.                                         *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      RDPICK  (CARDL,CARDD,CARD,SREC,STRAC,SSAMP,SCOLOR,NAME,NPICKS,  *
C               UNITS,OFFSET,MAXSEG,MAXPIK,SZSMPD,NREC,NTRAC,NSAMP,    *
C               LPRT,LPCK,JERR)                                        *
C  ARGUMENTS:                                                          *
C      CARDL   CHAR*126  ??IOU*        -                               *
C      CARDD   CHAR*1    ??IOU*  (126) -                               *
C      CARD    CHAR*80   ??IOU*        -                               *
C      SREC    REAL      ??IOU*        -                               *
C      STRAC   REAL      ??IOU*        -                               *
C      SSAMP   REAL      ??IOU*        -                               *
C      SCOLOR  REAL      ??IOU*        -                               *
C      NAME    CHAR*20   ??IOU*  (*)   -                               *
C      NPICKS  INTEGER   ??IOU*  (*)   -                               *
C      UNITS   REAL      ??IOU*  (*)   -                               *
C      OFFSET  REAL      ??IOU*  (*)   -                               *
C      MAXSEG  INTEGER   ??IOU*        -                               *
C      MAXPIK  INTEGER   ??IOU*        -                               *
C      SZSMPD  INTEGER   ??IOU*        -                               *
C      NREC    INTEGER   ??IOU*        -                               *
C      NTRAC   INTEGER   ??IOU*        -                               *
C      NSAMP   INTEGER   ??IOU*        -                               *
C      LPRT    INTEGER   ??IOU*        -                               *
C      LPCK    INTEGER   ??IOU*        -                               *
C      JERR    INTEGER   ??IOU*        -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   Mary Ann Thornton                  ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C  REVISED:  Mary Ann Thornton  October 5, l992                        *
C            Changed format statement to be able to read new XSD       *
C            formatted picks.  (This version does not pick up the      *
C            name of the segments or the number picks per segment).    *
C  REVISED:  Mary Ann Thornton  December 16, l992                      *
C            Rewrote this subroutine to take advantage of the new      *
C            improved xsd formatted cards which has the number of      *
C            segments and the maximum number of points per segment     *
C            specified on the "Units" card.                            *
C  REVISED:  Mary Ann Thornton  June 11, 1993                          *
C            Improved the explanation of how to use this routine       *
C  CALLING FORMAT:                                                     *
C       call rdpick(cardl,cardd,card,prec,ptrac,psamp,pcolor,name,     *
C      &     npicks,units,offset,maxseg,maxpik,szsmpd,nrec,ntrac,nsamp,*
C      &     lprt,lpck,jerr                                            *
C                                                                      *
C  PARAMETERS:                                                         *
C    cardl      Character array input/output (defined in lpick.h)      *
C                                                                      *
C    cardd      Character array input/output (defined in lpick.h)      *
C                                                                      *
C    card       Character array input/output (defined in lpick.h)      *
C                                                                      *
C    prec       Pointer to real array of x points (defined in lpick.h) *
C               This array will be returned as array 'rec'             *
C                                                                      *
C    ptrac      Pointer to real array of y points (defined in lpick.h) *
C               This array will be returned as array 'trac'            *
C                                                                      *
C    psamp      Pointer to real array of z points (defined in lpick.h) *
C               This array will be returned as array 'samp'            *
C                                                                      *
C    pcolor     Pointer to integer array of segment colors             *
C               (defined in lpick.h)                                   *
C               This array will be returned as array 'icolor'          *
C                                                                      *
C    name       Character*20 array input/output array of length 1000   *
C               This must be dimensioned 1000 in the calling routine   *
C                                                                      *
C    npicks     Integer input/output array of length 1000              *
C               This must be dimensioned 1000 in the calling routine   *
C               npicks(1) = the number of points in segment one        *
C               npicks(2) = the number of points in segment two, etc.  *
C                                                                      *
C    units      Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Units measure for the x,y,z points read from file      *
C               units(1) = Units measure for the x points              *
C               units(2) = Units measure for the y points              *
C               units(3) = Units measure for the z points              *
C                                                                      *
C    offset     Real input/output array of length 3                    *
C               This must be dimensioned 3 in the calling routine      *
C               Offsets measure of x,y,z points read from file         *
C               offset(1) = offset measure for the x points            *
C               offset(2) = offset measure for the y points            *
C               offset(3) = offset measure for the z points            *
C                                                                      *
C    maxseg     Integer output scalar                                  *
C               Number of segments in the picks file                   *
C                                                                      *
C    maxpik     Integer output scalar                                  *
C               Maximum number of picks in any one segment             *
C                                                                      *
C    szsmpd     Integer input scalar (defined in lhdrsz.h)             *
C               Size of data sample                                    *
C                                                                      *
C    nrec       Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    ntrac      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    nsamp      Integer output scalar                                  *
C               No. records in original 'picked' dataset               *
C                                                                      *
C    lprt       Integer input scalar                                   *
C               Logical unit of printout                               *
C                                                                      *
C    lpck       Integer input scalar                                   *
C               Logical unit of pick file                              *
C                                                                      *
C    jerr       Integer input/output scalar                            *
C               Error flag                                             *
C                                                                      *
C  DESCRIPTION:  This routine reads an 'xsd' pick file and returns     *
C      arrays containing the x, y, and z points; color; and name       *
C      for each segment - these arrays will be one-dimensional arrays  *
C                If offsets and color are not                          *
C      found in the picks file, these values are set to 0.  The        *
C      space for the arrays is allocated within this routine. The      *
C      calling program should include the following lines:             *
C                                                                      *
C         #include <f77/lpick.h>                                       *
C         #include <f77/lhdrsz.h>                                      *
C               dimension npicks(1000), offset(3), units(3)            *
C               dimension rec(1), trac(1), samp(1), icolor(1)          *
C               character*20 name(1000)                                *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C      galloc    - allocate space (ut library)                         *
C      vclr      - clear space (Mathadvantage)                         *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C      jerr =  0  =   No errors                                        *
C      jerr = 50  =   No Units card found                              *
C      jerr =100  =   No Segment card found for a segment              *
C      jerr =150  =   Error allocating space for segments              *
C      jerr =175  =   No valid segments found                          *
C      jerr =200  =   EOF encountered reading picks                    *
C      jerr =300  =   Error reading picks                              *
C                                                                      *
C--------------------------------------------------------------------- *
C***********************************************************************
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      GALLOC -                                                        *
C      VCLR   -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      INDEX   INTEGER -                                               *
C  FILES:                                                              *
C      CARD   ( INPUT  INTERNAL   ) -                                  *
C      CARDL  ( INPUT  INTERNAL   ) -                                  *
C      LPCK   ( INPUT  SEQUENTIAL ) -                                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      POINTER (SREC,REC),(STRAC,TRAC),(SSAMP,SAMP),(SCOLOR            *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 97/02/13 ==================   *
C NAME: RDPICK    READ  PICKS                          REV 2.0  DEC 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      subroutine rdpick(cardl,cardd,card,srec,strac,ssamp,scolor,
     &name,npicks,units,offset,maxseg,maxpik,szsmpd,nrec,ntrac,nsamp,
     &lprt,lpck,jerr)
C
      integer szsmpd
      character*126 cardl
      character*1   cardd(126)
      character*80  card
      character*20  name(*)
      integer npicks(*),color(1)
      real rec(1),trac(1),samp(1)
      real units(*),offset(*)
      pointer (srec,rec),(strac,trac),(ssamp,samp),(scolor,color)
 
      jerr = 0
C     if (index(cardl,'U').ne.0) we read a Units card
   50 format(a126)
   75 format(a80)
      read(lpck,50,end=200)cardl
      if(index(cardl,'U').ne.0)then
         go to 90
      else
         write(lprt,*)' No Units card found'
         jerr =  50
         return
      endif
C     We have just read a Units card
   90 continue
      read(cardl,60,end=200,err=300)uword,units(1),units(2),units(3),
     &nrec,ntrac,nsamp,offset(1),offset(2),offset(3),maxseg,maxpik
   60 format(a6,3(f12.6,1x),3(i5,1x),6x,3(f12.6,1x),7x,i5,1x,i5)
cmat  write(lprt,*)uword,units(1),units(2),units(3),
cmat &nrec,ntrac,nsamp,offset(1),offset(2),offset(3),maxseg,maxpik
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCc
CCCCC  malloc space and zero it
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCc
      iabort = 0
      ierr = 0
C     array rec
      lbytes = maxseg * maxpik * szsmpd
      call galloc(srec, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(rec,1,lwords)
C     array trac
      call galloc(strac, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(trac,1,lwords)
C     array samp
      call galloc(ssamp, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(samp,1,lwords)
C     array color
      lbytes = maxseg * szsmpd
      call galloc(scolor, lbytes, ierr, iabort)
      if(ierr.ne.0)then
         write(lprt,*)' error allocating space = ', ierr
         jerr = 150
         return
      endif
      lwords = lbytes / szsmpd
      call vclr(color,1,lwords)
 
C     if (index(card,'S').ne.0) we read a Segment card
      k = 0
      do 150 i=1,maxseg
         read(lpck,75,end=200,err=300)card
         if(index(card,'S').ne.0)then
            read(card,70,err=300)nseg,name(i),color(i),npicks(i)
   70       format(10x,i5,6x,a20,10x,i5,9x,i5)
cmat        write(lprt,*)nseg,name(i),color(i),npicks(i)
         else
            write(lprt,*)' No segment card found for segment ',i
            jerr = 100
            return
         endif
         do 100 j=1,npicks(i)
            k = k + 1
            read(lpck,80,end=200,err=300)rec(k),trac(k),samp(k)
cmat        write(lprt,*)rec(k),trac(k),samp(k)
   80       format(3(f12.6,1x))
  100    continue
  150 continue
      write(lprt,*)maxseg,' segments read successfully '
      return
  200 continue
      write(lprt,*)' reached end of file reading picks '
      write(lprt,*)' job terminated'
      jerr = 200
      return
  300 continue
      write(lprt,*)' error reading picks '
      write(lprt,*)' job terminated'
      jerr = 300
      return
      end
