C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       VZDCI                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      VZDCI  (CA,PHAS,PSI,PLNR,PLNI,MK,NK,NZ)                         *
C      CVZDCI  (CA,PHAS,PSI,PLNR,PLNI,MK,NK,NZ)                        *
C      XVZDCI  (CA,PHAS,PSI,PLNR,PLNI,MK,NK,NZ)                        *
C  ARGUMENTS:                                                          *
C      CA      COMPLEX  ??IOU*      -                                  *
C      PHAS    COMPLEX  ??IOU*  (*) -                                  *
C      PSI     COMPLEX  ??IOU*  (*) -                                  *
C      PLNR    REAL     ??IOU*  (*) -                                  *
C      PLNI    REAL     ??IOU*  (*) -                                  *
C      MK      INTEGER  ??IOU*      -                                  *
C      NK      INTEGER  ??IOU*      -                                  *
C      NZ      INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 97/02/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      REAL    REAL -                                                  *
C      AIMAG   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C********************************************************************C
C NAME: VZDCI   V OF Z DOWNWARD CONT. & IMAGE   REV 3.0     FEB 92   C
C********************************************************************C
C
C  PURPOSE:
C       DOWNWARD CONTINUES AND IMAGES IN THE K-Z PLANE WHERE VELOCITY
C       IS A FUNCTION OF Z ONLY.
C
C  LANGUAGE:
C       CRAY 2 VERSION:   CRAY ASSEMBLY LANGUAGE
C       CRAY-XEA VERSION: CRAY ASSEMBLY LANGUAGE
C       OTHERS: FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JUN 87          R.D. COLEMAN, QTC
C       REVISION 2.0            SEP 87          R.D. COLEMAN, QTC
C               SPLIT PLANE INTO COMPLEX COMPONENTS
C       REVISION 3.0            FEB 92          T.P. COLEMAN, CETech
C               Portable FORTRAN version, additional entry points
C               added.
C
C  CALLING FORMAT:
C       CALL  VZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
C       CALL CVZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
C       CALL XVZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
C
C  PARAMETERS:
C       CA      COMPLEX INPUT SCALAR
C               PHASE-SHIFT SCALE FACTOR.
C
C       PHAS    COMPLEX INPUT VECTOR OF LENGTH NK
C               PHASE-SHIFT OPERATOR.  CONTENTS OF PHAS ARE MODIFIED
C               BY THIS ROUTINE.
C
C       PSI     COMPLEX INPUT/OUTPUT VECTOR OF LENGTH NK
C               ON INPUT PSI CONTAINS THE WAVE FIELD AT THE TOP (Z=0).
C               ON OUTPUT PSI CONTAINS THE WAVE FIELD AT THE BOTTOM.
C
C       PLNR    REAL INPUT/OUTPUT MATRIX OF DIMENSION MK X NZ
C               PLANE CONTAINS THE REAL COMPONENTS OF THE IMAGE IN
C               THE K-Z PLANE IN THE FIRST NK ROWS.
C
C       PLNI    REAL INPUT/OUTPUT MATRIX OF DIMENSION MK X NZ
C               PLANE CONTAINS THE IMAGINARY COMPONENTS OF THE IMAGE IN
C               THE K-Z PLANE IN THE FIRST NK ROWS.
C
C       MK      INTEGER INPUT SCALAR
C               TOTAL NUMBER OF K'S (WAVE NUMBERS); I.E., ROW DIMENSION
C               OF PLNR AND PLNI.  MK MUST BE >= NK.
C
C       NK      INTEGER INPUT SCALAR
C               NUMBER OF K'S (WAVE NUMBERS).
C
C       NZ      INTEGER INPUT SCALAR
C               NUMBER OF Z'S.
C
C
C  DESCRIPTION:
C       THE ACTION OF XVZDCI IS DESCRIBED BY THE FOLLOWING PSEUDO
C       CODE:
C
C       PHAS(1:NK) = CA * PHAS(1:NK)
C       DO J = 1, NZ
C          PSI(1:NK)    = PHAS(1:NK) * PSI(1:NK)
C          PLNR(1:NK,J) = PLNR(1:NK,J) + REAL( PSI(1:NK) )
C          PLNI(1:NK,J) = PLNI(1:NK,J) + IMAG( PSI(1:NK) )
C       ENDDO
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE  VZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
      ENTRY      CVZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
      ENTRY      XVZDCI (CA, PHAS, PSI, PLNR, PLNI, MK, NK, NZ)
C
      COMPLEX CA, PHAS(*), PSI(*)
      REAL    PLNR(*), PLNI(*)
C
C---------------------------------------------------------------------
C
      DO 100 I = 1, NK
         PHAS(I) = CA * PHAS(I)
  100 CONTINUE
C
      JZ = 1
      DO 130 J = 1, NZ
         IZ = JZ
         DO 120 I = 1, NK
            PSI(I)   = PHAS(I) * PSI(I)
            PLNR(IZ) = PLNR(IZ) + REAL ( PSI(I) )
            PLNI(IZ) = PLNI(IZ) + AIMAG( PSI(I) )
            IZ = IZ + 1
  120    CONTINUE
         JZ = JZ + MK
  130 CONTINUE
C
      RETURN
      END
