C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       VZPK4                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       IMAGES A K-Z PLANE WHERE VELOCITY IS A FUNCTION OF Z ONLY.     *
C       DOWNWARD CONTINUATION IS PERFORMED FOR A LIMITED RANGE OF      *
C       K VALUES WHICH ARE A FUNCTION OF THE ANGLE, P.                 *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      VZPK4  (MK,NK,NP,NZS,NZT,NX,NW,JW,OMEGA,AK,P,KLIM,IZSNZ,ZSDZ,   *
C              ZSSLOI,ZSSLOR,PSI,WORK,PLANE,CXFTAB,IERR)               *
C      XVZPK4  (MK,NK,NP,NZS,NZT,NX,NW,JW,OMEGA,AK,P,KLIM,IZSNZ,ZSDZ,  *
C               ZSSLOI,ZSSLOR,PSI,WORK,PLANE,CXFTAB,IERR)              *
C  ARGUMENTS:                                                          *
C      MK      INTEGER  ??IOU*          -                              *
C      NK      INTEGER  ??IOU*          -                              *
C      NP      INTEGER  ??IOU*          -                              *
C      NZS     INTEGER  ??IOU*          -                              *
C      NZT     INTEGER  ??IOU*          -                              *
C      NX      INTEGER  ??IOU*          -                              *
C      NW      INTEGER  ??IOU*          -                              *
C      JW      INTEGER  ??IOU*          -                              *
C      OMEGA   REAL     ??IOU*          -                              *
C      AK      REAL     ??IOU*  (NK)    -                              *
C      P       REAL     ??IOU*  (NP)    -                              *
C      KLIM    INTEGER  ??IOU*  (2,NP)  -                              *
C      IZSNZ   INTEGER  ??IOU*  (NZS)   -                              *
C      ZSDZ    REAL     ??IOU*  (NZS)   -                              *
C      ZSSLOI  REAL     ??IOU*  (NZS)   -                              *
C      ZSSLOR  REAL     ??IOU*  (NZS)   -                              *
C      PSI     COMPLEX  ??IOU*  (MK,NP) -                              *
C      WORK    REAL     ??IOU*  (*)     -                              *
C      PLANE   REAL     ??IOU*  (*)     -                              *
C      CXFTAB  REAL     ??IOU*  (*)     -                              *
C      IERR    INTEGER  ??IOU*          -                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                APR 90          R.D. COLEMAN, QTC      *
C               MODIFICATION OF XVZPK3 WITH THE DATA IN PSI AND        *
C               PLANE IN NATURAL ORDER AS OPPOSED TO FFT ORDER.        *
C               ALSO THE ORDER OF THE LOOPS HAS BEEN REVERSED AND      *
C               NEW K LIMITS ARE CALCULATED IN THE Z LOOP              *
C               IN ORDER TO ELIMINATE UNNECESSARY (ZERO) ELEMENTS      *
C               IN THE PHASE SHIFT VECTOR.                             *
C       REL 2.0                 APR 92          T.P. COLEMAN, CETech   *
C               PORTABLE FORTRAN VERSION, ADDITIONAL ENTRY POINTS ADDED*
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL XVZPK4 (MK, NK, NP, NZS, NZT, NX, NW, JW, OMEGA, AK, P,   *
C      &             KLIM, IZSNZ, ZSDZ, ZSSLOI, ZSSLOR, PSI, WORK,     *
C      &             PLANE, CXFTAB, IERR)                              *
C       CALL  VZPK4 (MK, NK, NP, NZS, NZT, NX, NW, JW, OMEGA, AK, P,   *
C      &             KLIM, IZSNZ, ZSDZ, ZSSLOI, ZSSLOR, PSI, WORK,     *
C      &             PLANE, CXFTAB, IERR)                              *
C                                                                      *
C  PARAMETERS:                                                         *
C                                                                      *
C       MK      INTEGER INPUT SCALAR                                   *
C               ROW DIMENSION OF MATRIX PSI.  MK MUST BE >= NK.        *
C                                                                      *
C       NK      INTEGER INPUT SCALAR                                   *
C               NUMBER OF K'S (WAVE NUMBERS).  NK MUST BE AN EVEN      *
C               INTEGER OF THE FORM 2**I * 3**J * 5**K WHERE I, J,     *
C               AND K ARE NON-NEGATIVE INTEGERS.                       *
C                                                                      *
C       NP      INTEGER INPUT SCALAR                                   *
C               NUMBER OF P'S (ANGLES).                                *
C                                                                      *
C       NZS     INTEGER INPUT SCALAR                                   *
C               NUMBER OF Z SEGMENTS.                                  *
C                                                                      *
C       NZT     INTEGER INPUT SCALAR                                   *
C               TOTAL NUMBER OF Z'S (NZT = SUM(IZSNZ(I), I = 1, NZS).  *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               NUMBER OF X'S.  NX MUST BE <= NK.                      *
C                                                                      *
C       NW      INTEGER INPUT SCALAR                                   *
C               NUMBER OF W'S (FREQUENCIES).                           *
C                                                                      *
C       JW      INTEGER INPUT SCALAR                                   *
C               FREQUENCY INDEX.                                       *
C                                                                      *
C       OMEGA   REAL INPUT SCALAR                                      *
C               ANGULAR FREQUENCY.                                     *
C                                                                      *
C       AK      REAL INPUT VECTOR OF LENGTH NK                         *
C               K (WAVE NUMBER) VECTOR.                                *
C                                                                      *
C       P       REAL INPUT VECTOR OF LENGTH NP                         *
C               P (ANGLE) VECTOR.                                      *
C                                                                      *
C       KLIM    INTEGER INPUT ARRAY OF DIMENSION 2 X NP                *
C               KLIM(1,J) AND KLIM(2,J) CONTAIN THE LOWER AND UPPER    *
C               K LIMITS FOR ANGLE P(J), RESPECTIVELY.                 *
C                                                                      *
C       IZSNZ   INTEGER INPUT VECTOR OF LENGTH NZS                     *
C               IZSNZ(I) = NUMBER OF Z'S FOR THE I-TH Z SEGMENT.       *
C                                                                      *
C       ZSDZ    REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSDZ(I) = DELTA Z FOR THE I-TH Z SEGMENT.              *
C                                                                      *
C       ZSSLOI  REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSSLOI(I) = INDICENT  SLOWNESS FOR THE I-TH Z SEGMENT. *
C                                                                      *
C       ZSSLOR  REAL INPUT VECTOR OF LENGTH NZS                        *
C               ZSSLOR(I) = REFLECTED SLOWNESS FOR THE I-TH Z SEGMENT. *
C                                                                      *
C       PSI     COMPLEX INPUT MATRIX OF DIMENSION MK X NP              *
C               WAVE FIELD AT THE TOP (Z=0).  ON OUTPUT PSI CONTAINS   *
C               THE WAVE FIELD AT THE BOTTOM.  THE DATA IS CONTAINED   *
C               IN THE FIRST NK ROWS OF PSI.  THE REMAINING ROWS (IF   *
C               ANY) ARE NEVER ACCESSED.  PSI IS IN NATURAL ORDER.     *
C                                                                      *
C       WORK    REAL SCRATCH VECTOR OF LENGTH NWRK                     *
C               NWRK = MAX( 4*NK*NZT+2*NK, 7*NK, 7*NZS )               *
C                                                                      *
C       PLANE   REAL INPUT/OUTPUT MATRIX OF DIMENSION (NK+1) * NZT * 2 *
C               IF JW < NW, THEN PLANE CONTAINS COMPLEX IMAGE IN THE   *
C               K-Z PLANE WHICH MUST BE INPUT ON THE NEXT CALL.        *
C               IF JW = NW, THEN PLANE CONTAINS THE REAL IMAGE IN THE  *
C               X-Z PLANE IN THE FIRST NX*NZT WORDS.  THE COMPLEX DATA *
C               IS IN NATURAL ORDER.                                   *
C                                                                      *
C       CXFTAB  REAL INPUT VECTOR OF IMPLIED LENGTH                    *
C               TABLE FOR XCXF2D AS GENERATED BY GCFTLP.               *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               THE LOGICAL OR OF ALL THE XCXF2D COMPLETION CODES.     *
C               IF NOT ZERO, THEN THE RANGE OF CXFTAB IS INSUFFICIENT. *
C                                                                      *
C  DESCRIPTION:                                                        *
C       THE ACTION OF XVZPK4 IS DESCRIBED BY THE FOLLOWING PSEUDO      *
C       CODE:                                                          *
C                                                                      *
C       IF JW = 1, THEN PLANE(1:NK,1:NZT) = 0.0                        *
C                                                                      *
C       IZS = 0                                                        *
C       DO JZS = 1, NZS                                                *
C          DO JP = 1, NP                                               *
C             COMPUTE K1 AND K2 (ACTUAL K INDEX RANGE) FOR P(JP)       *
C             COMPUTE PHAS(K1:K2) (PHASE-SHIFT OPERATOR) FOR P(JP)     *
C             DO JZ = 1, IZSNZ(JZS)                                    *
C                IZ = IZS + JZ                                         *
C                PSI(K1:K2,JP) = PHAS(K1:K2) * PSI(K1:K2,JP)           *
C                PLANE(K1:K2,IZ) = PLANE(K1:K2,IZ) + PSI(K1:K2,JP)     *
C             ENDDO                                                    *
C          ENDDO                                                       *
C          IZS = IZS + IZSNZ(JZS)                                      *
C       ENDDO                                                          *
C                                                                      *
C       IF (JW = NW) THEN                                              *
C          CONVERT PLANE TO FFT ORDER                                  *
C          CALL XRCFT2 (PLANE, NK, NX, NZT, 1, WORK, IERR)             *
C       ENDIF                                                          *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       XCXF2D, CVZDCI, XRCFT2                                         *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       IF AN ERROR OCCURS IN SUBROUTINE XCXF2D, THEN THE APPROPRIATE  *
C       ERROR CODE IS SET AND PROCESSING CONTINUES.                    *
C                                                                      *
C----------------------------------------------------------------------*
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR         -                                                  *
C      XCXF2D       -                                                  *
C      OR      REAL -                                                  *
C      CVZDCI       -                                                  *
C      VMOV         -                                                  *
C      XRCFT2       -                                                  *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      IFIX    INTEGER -                                               *
C      CMPLX   COMPLEX -                                               *
C      MAX0    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: VZPK4     IMAGE V OF Z PLANE - K LIMITS        REV 2.0  JAN 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE  VZPK4 (MK, NK, NP, NZS, NZT, NX, NW, JW, OMEGA, AK, P,
     &                   KLIM, IZSNZ, ZSDZ, ZSSLOI, ZSSLOR, PSI, WORK,
     &                   PLANE, CXFTAB, IERR)
      ENTRY      XVZPK4 (MK, NK, NP, NZS, NZT, NX, NW, JW, OMEGA, AK, P,
     &                   KLIM, IZSNZ, ZSDZ, ZSSLOI, ZSSLOR, PSI, WORK,
     &                   PLANE, CXFTAB, IERR)
C
      PARAMETER (BI = 1.0, BR = 1.0, ICXFLG = 1)
C
      INTEGER MK, NK, NP, NZS, NZT, NX, NW, JW, KLIM(2,NP), IZSNZ(NZS),
     &        IERR
      REAL    OMEGA, AK(NK), P(NP), ZSDZ(NZS), ZSSLOI(NZS), ZSSLOR(NZS),
     &        WORK(*), PLANE(*), CXFTAB(*)
      COMPLEX PSI(MK,NP), CA
C
C-----------------------------------------------------------------------
C
C     ALLOCATE WORK SPACE
C
      INC = MAX0( NK, NZS )
      I1  = 1
      I2  = I1 + 2*NZS
      I3  = I2 + 2*NK
      I4  = I3 + INC
      I5  = I4 + INC
C
C     IF JW = 1, CLEAR PLANE
C
      NKP1 = NK + 1
      IF (JW .EQ. 1) THEN
         NN = 2 * NKP1 * NZT
C         PLANE(1:NN) = 0.0
         CALL VCLR( PLANE(1), 1, NN )
      ENDIF
C
C     INITIALIZE SOME STUFF
C
      IERR  = 0
      IPR   = 1
      IPI   = IPR + NKP1 * NZT
      KBIAS = (NK + 1) / 2
      DK    = AK(1+KBIAS)
C
C     LOOP OVER ANGLE
C
      DO 130 JP = 1, NP
         IK1 = KLIM(1,JP) + KBIAS
         IK2 = KLIM(2,JP) + KBIAS
C
         IF (IK1 .GT. NK .OR. IK2 .LT. 1 .OR. IK1 .GT. IK2) THEN
C            PSI(1:NK,JP) = (0.0,0.0)
            CALL VCLR( PSI(1,JP), 1, 2*NK )
            GO TO 130
         ENDIF
 
         IF (IK1 .LT.  1) IK1 = 1
         IF (IK2 .GT. NK) IK2 = NK
         LK = IK2 - IK1 + 1
C
C        CLEAR PSI OUTSIDE K LIMITS
C
         IF (IK1 .GT.  1) THEN
C           PSI( 1:IK1-1,JP) = (0.0,0.0)
            CALL VCLR( PSI(1,JP), 1, 2*(IK1-1) )
         ENDIF
         IF (IK2 .LT. NK) THEN
C           PSI(IK2+1:NK,JP) = (0.0,0.0)
            CALL VCLR( PSI(IK2+1,JP), 1, 2*(NK-IK2) )
         ENDIF
C
         CALL XCXF2D (0.0, ZSSLOI, OMEGA,  P(JP), ZSDZ, BI, WORK(I1),
     &                  1,    NZS,     1,      1, ICXFLG,
     &                WORK(I3), WORK(I4), WORK(I5), CXFTAB, JERR)
         IERR = OR( IERR, JERR )
C
C        LOOP OVER Z SEGMENTS
C
         JPR = IPR - 1
         JPI = IPI - 1
         J1  = I1
         DO 110 JZS = 1, NZS
            CA = CMPLX( WORK(J1), WORK(J1+1) )
            IF (CA .EQ. (0.0,0.0)) THEN
C              PSI(IK1:IK2,JP) = (0.0,0.0)
               CALL VCLR( PSI(IK1,JP), 1, 2*(IK2-IK1+1) )
               GO TO 120
            ENDIF
C
            NZ   = IZSNZ(JZS)
            DZ   = ZSDZ(JZS)
            SLOI = ZSSLOI(JZS)
            SLOR = ZSSLOR(JZS)
C
C           COMPUTE K LIMITS
C
            AKMIN = OMEGA * (P(JP) - SLOR)
            AKMAX = OMEGA * (P(JP) + SLOR)
            JK1   = IFIX( AKMIN / DK ) + KBIAS
            JK2   = IFIX( AKMAX / DK ) + KBIAS
C
C           CHECK LOWER K LIMIT
C
            IF (JK1 .GT. IK1) THEN
               IF (JK1 .LE. IK2) THEN
C                 PSI(IK1:JK1-1,JP) = (0.0,0.0)
                  CALL VCLR( PSI(IK1,JP), 1, 2*(JK1-IK1) )
                  IK1 = JK1
                  LK  = IK2 - IK1 + 1
               ELSE
C                 PSI(IK1:IK2,JP) = (0.0,0.0)
                  CALL VCLR( PSI(IK1,JP), 2, 2*(IK2-IK1+1) )
                  GO TO 120
               ENDIF
            ENDIF
C
C           CHECK UPPER K LIMIT
C
            IF (JK2 .LT. IK2) THEN
               IF (JK2 .GE. IK1) THEN
C                 PSI(JK2+1:IK2,JP) = (0.0,0.0)
                  CALL VCLR( PSI(JK2+1,JP), 1, 2*(IK2-JK2) )
                  IK2 = JK2
                  LK  = IK2 - IK1 + 1
               ELSE
C                 PSI(IK1:IK2,JP) = (0.0,0.0)
                  CALL VCLR( PSI(IK1,JP), 1, 2*(IK2-IK1+1) )
                  GO TO 120
               ENDIF
            ENDIF
C
C           COMPUTE PHASE-SHIFT OPERATOR THEN DOWNWARD CONTINUE AND
C           IMAGE FOR THE FIRST K INDEX RANGE FOR P(IP)
C
            CALL XCXF2D (AK(IK1), SLOR, OMEGA, P(JP), DZ, BR, WORK(I2),
     &                        LK,    1,     1,     1, -1,
     &                   WORK(I3), WORK(I4), WORK(I5), CXFTAB, JERR)
            IERR = OR( IERR, JERR )
            CALL CVZDCI (CA, WORK(I2), PSI(IK1,JP),
     &                   PLANE(IK1+JPR), PLANE(IK1+JPI), NKP1, LK, NZ)
C
            JPR = JPR + NKP1 * NZ
            JPI = JPI + NKP1 * NZ
            J1  = J1 + 2
  110    CONTINUE
  120    CONTINUE
  130 CONTINUE
C
C  IF LAST FREQUENCY, THEN EXTRACT REAL IMAGE, ELSE RETURN
C
      IF (JW .NE. NW) RETURN
C
C  PUT DATA IN FFT ORDER
C
      NK1 = NK / 2 + 1
      NK2 = NK - NK1
      JPR = IPR
      JPI = IPI
      DO 210 JZ = 1, NZT
         CALL VMOV (PLANE(JPR    ), 1, WORK          , 1, NK2)
         CALL VMOV (PLANE(JPR+NK2), 1, PLANE(JPR)    , 1, NK1)
         CALL VMOV (WORK          , 1, PLANE(JPR+NK1), 1, NK2)
         CALL VMOV (PLANE(JPI    ), 1, WORK          , 1, NK2)
         CALL VMOV (PLANE(JPI+NK2), 1, PLANE(JPI)    , 1, NK1)
         CALL VMOV (WORK          , 1, PLANE(JPI+NK1), 1, NK2)
         JPR = JPR + NKP1
         JPI = JPI + NKP1
  210 CONTINUE
C
C  FFT AND KEEP THE REAL COMPONENTS
C
      I1 = 2 * NK + 1
      CALL XRCFT2 (PLANE(IPR), PLANE(IPI), NKP1, NK, NX, NZT, 1,
     &             WORK, WORK(I1), JERR)
C
      RETURN
      END
