C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       WRM2FI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C       WRITES A MATRIX TO A RANDOM ACCESS FILE.                       *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      WRM2FILE  (DATA,L,M,N,LUFILE,LOCBEG,LOCINC)                     *
C  ARGUMENTS:                                                          *
C      DATA    REAL     ??IOU*  (*) -                                  *
C      L       INTEGER  ??IOU*      -                                  *
C      M       INTEGER  ??IOU*      -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      LUFILE  INTEGER  ??IOU*      -                                  *
C      LOCBEG  INTEGER  ??IOU*      -                                  *
C      LOCINC  INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                APR 92          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL WRM2FILE( DATA, L, M, N, LUFILE, LOCBEG, LOCINC )         *
C                                                                      *
C  PARAMETERS:                                                         *
C       DATA    REAL INPUT MATRIX                                      *
C               SOURCE MATRIX.                                         *
C                                                                      *
C       L       INTEGER INPUT SCALAR                                   *
C               INCREMENT BETWEEN THE START OF EACH DATA VECTOR.       *
C                                                                      *
C       M       INTEGER INPUT SCALAR                                   *
C               LENGTH OF EACH DATA VECTOR.                            *
C                                                                      *
C       N       INTEGER INPUT SCALAR                                   *
C               NUMBER OF DATA VECTORS.                                *
C                                                                      *
C       LUFILE  INTEGER INPUT SCALAR                                   *
C               LOGICAL UNIT NUMBER OF OUPUT FILE                      *
C                                                                      *
C       LOCBEG  INTEGER INPUT SCALAR                                   *
C               LOCATION (RECORD NUMBER) TO WRITE FIRST DATA VECTOR    *
C                                                                      *
C       LOCINC  INTEGER INPUT SCALAR                                   *
C               INCREMENT BETWEEN FILE LOCATION FOR EACH DATA VECTOR IN*
C               RECORDS.                                               *
C                                                                      *
C  DESCRIPTION:                                                        *
C       WRM2FILE writes the M by N principle submatrix of a L by N     *
C       matrix to a random access, fixed record length file.  The matri*
C       is written a column (vector) at a time.  The first column is   *
C       written to record LOCBEG and each subsequent column is written *
C       with a record stride of LOCINC.  The length of a column        *
C       ( M words ) must not exceed the record length for the file.    *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       NONE.                                                          *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       NONE.                                                          *
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUFILE  ( OUTPUT DIRECT     ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: WRM2FILE  WRITE MATRIX TO FILE                 REL 1.0  APR 92 *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE WRM2FILE( DATA, L, M, N, LUFILE, LOCBEG, LOCINC )
C
      INTEGER L, M, N, LUFILE, LOCBEG, LOCINC, I, I1, I2, J, LOC
      REAL    DATA(*)
C
C-----------------------------------------------------------------------
C
      LOC = LOCBEG
      I1  = 1
      I2  = M
      DO 110 J = 1, N
         WRITE( LUFILE, REC=LOC ) ( DATA(I), I = I1, I2 )
         LOC = LOC + LOCINC
         I1  = I1 + L
         I2  = I2 + L
  110 CONTINUE
C
      RETURN
      END
