C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C                                                                      *
C  ROUTINE:       WRREC                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C      WRREC WRITES ALL OF THE TRACES FOR AN ENTIRE SIS RECORD TO THE  *
C      OUTPUT DATA SET.                                                *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      WRREC  (LUOUT,LUERR,IREC,NZ,IZ,NX,IX,TRACE,HEADER,DATA,IERR)    *
C  ARGUMENTS:                                                          *
C      LUOUT   INTEGER  ??IOU*             -                           *
C      LUERR   INTEGER  ??IOU*             -                           *
C      IREC    INTEGER  ??IOU*             -                           *
C      NZ      INTEGER  ??IOU*             -                           *
C      IZ      INTEGER  ??IOU*             -                           *
C      NX      INTEGER  ??IOU*             -                           *
C      IX      INTEGER  ??IOU*             -                           *
C      TRACE   REAL     ??IOU*  (*)        -                           *
C      HEADER  INTEGER*2  ??IOU*  (NTRHDR,*) -                         *
C      DATA    REAL     ??IOU*  (*)        -                           *
C      IERR    INTEGER  ??IOU*             -                           *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 92/07/22  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 97/02/18  *
C       FORTRAN 77                                                     *
C                                                                      *
C  HISTORY:                                                            *
C       ORIGINAL                NOV 91          R.D. COLEMAN, CETech   *
C                                                                      *
C  CALLING FORMAT:                                                     *
C       CALL WRREC( LUOUT, LUERR, IREC, NZ, IZ, NX, IX, TRACE,         *
C      &            HEADER, DATA, IERR )                               *
C                                                                      *
C  PARAMETERS:                                                         *
C       LUOUT   INTEGER INPUT SCALAR                                   *
C               Logical unit number of output SIS dataset.             *
C                                                                      *
C       LUERR   INTEGER INPUT SCALAR                                   *
C               Logical unit number for error messages.  If LUERR < 0, *
C               then error messages are suppressed.                    *
C                                                                      *
C       IREC    INTEGER INPUT SCALAR                                   *
C               Record index of the output record.                     *
C                                                                      *
C       NZ      INTEGER INPUT SCALAR                                   *
C               Number of Z's - logical row dimension of input matrix. *
C                                                                      *
C       IZ      INTEGER INPUT SCALAR                                   *
C               Stride in the Z dimension (i.e., between elements of th*
C               same column).                                          *
C                                                                      *
C       NX      INTEGER INPUT SCALAR                                   *
C               Number of X's - logical column dimension of input matri*
C                                                                      *
C       IX      INTEGER INPUT SCALAR                                   *
C               Stride in the X dimension (i.e., between elements of th*
C               same row).                                             *
C                                                                      *
C       TRACE   REAL SCRATCH VECTOR OF LENGTH NZ+NWHDR                 *
C               Work space.  Note: NWHDR = 128 for Cray systems        *
C                                        =  64 otherwise               *
C                                                                      *
C       HEADER  INTEGER*2/INTEGER INPUT MATRIX OF DIMENSION 128 BY NX  *
C               Trace header array.  Note: The array is INTEGER*2 on   *
C               non- 1  systems and INTEGER on  1  systems             *
C                                                                      *
C       DATA    REAL INPUT MATRIX OF LOGICAL DIMENSION NZ BY NX        *
C               Data array.  Note: The physical dimensions are a       *
C               function of the strides IZ and IX.                     *
C                                                                      *
C       IERR    INTEGER OUTPUT SCALAR                                  *
C               Completion code.  IERR = 0 for normal completion       *
C                                     != 0 otherwise                   *
C                                                                      *
C  DESCRIPTION:                                                        *
C       WRREC contructs SIS traces from the trace header array, HEADER,*
C       and the data array, DATA.  Element 106 of each trace header is *
C       set to IREC and element 107 is set to the trace index.  The    *
C       traces are then written to LUOUT.                              *
C                                                                      *
C       The strides IX and IZ allow the data contained in DATA to be   *
C       transposed and/or a submatrix.  Typically, IZ = 1 and IX = NZ. *
C                                                                      *
C  SUBPROGRAMS CALLED:                                                 *
C       VMOV, WRTAPE                                                   *
C                                                                      *
C  ERROR CONDITIONS:                                                   *
C       If an error is reported by WRTAPE, then an error message is    *
C       written to LUERR, IERR is set to -1, and the routine is aborted*
C                                                                      *
C--------------------------------------------------------------------- *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      WRTAPE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUERR  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 92/07/22 ==================   *
C NAME: WRREC     WRITE SIS RECORD                     REV 1.0  NOV 91 *
C  =============================== DATE: 97/02/13 ==================   *
C      HEADER  INTEGER  ??IOU*  (NTRHDR,*) -                           *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
      SUBROUTINE WRREC( LUOUT, LUERR, IREC, NZ, IZ, NX, IX, TRACE,
     &                  HEADER, DATA, IERR )
C
C  SYMBOLIC CONSTANTS
C
      INTEGER NTRHDR, NWBYTE, NHBYTE, NWHDR
      PARAMETER( NTRHDR = 128 )
#ifdef CRAY
      PARAMETER( NWBYTE = 8, NHBYTE = 8 )
#else
      PARAMETER( NWBYTE = 4, NHBYTE = 2 )
#endif
      PARAMETER( NWHDR = NTRHDR * NHBYTE / NWBYTE )
C
C  SUBROUTINE ARGUMENTS
C
      INTEGER   LUOUT, LUERR, IREC, NZ, IZ, NX, IX, IERR
      REAL      DATA(*), TRACE(*)
#ifdef CRAY
      INTEGER   HEADER(NTRHDR,*)
#else
      INTEGER*2 HEADER(NTRHDR,*)
#endif
C
C  LOCAL VARIABLES
C
      INTEGER   IDATA, JH, JX, KX, NBYTES
      REAL      AHEADR(NWHDR)
#ifdef CRAY
      INTEGER   IHEADR(NTRHDR)
#else
      INTEGER*2 IHEADR(NTRHDR)
#endif
C
      EQUIVALENCE ( IHEADR, AHEADR )
C
C-----------------------------------------------------------------------
C
  991 FORMAT (/' ', '***** TAPE WRITE ERROR IN WRREC - RECORD', I5,
     &              ' TRACE', I5, ' *****' /)
C
C-----------------------------------------------------------------------
C
      NBYTES = NWBYTE * NZ + NHBYTE * NTRHDR
      IDATA  = 1 + NWHDR
C
      KX = 1
      DO 120 JX = 1, NX
         DO 110 JH = 1, NTRHDR
            IHEADR(JH) = HEADER(JH,JX)
  110    CONTINUE
C
         IHEADR(106) = IREC
         IHEADR(107) = JX
C
         CALL VMOV( AHEADR, 1, TRACE, 1, NWHDR )
         CALL VMOV( DATA(KX), IZ, TRACE(IDATA), 1, NZ )
C
         CALL WRTAPE (LUOUT, TRACE, NBYTES)
C
         IF (NBYTES .EQ. 0) THEN
            IF( LUERR .GE. 0 ) WRITE (LUERR, 991) IREC, JX
            IERR = -1
            RETURN
         ENDIF
C
         KX = KX + IX
  120 CONTINUE
C
      IERR = 0
      RETURN
      END
