%{
/*
 */


#include <stdlib.h>
#include <string.h>
#include "y.tab.h"

extern void line_feed();

#define YYLMAX 2000

%}

letter		[a-zA-Z_]
digit		[0-9]
hex		[a-fA-F0-9]
esc		\\([abfnrtv"'?\\]|[0-7]{1,3}|x[0-9a-fA-F]+)
alphanum	[a-zA-Z0-9\-\+\.\_\(\)\,\=\:]
blank		[ \t]
colon           :
other		.


%%


"#"{blank}+{digit}.*$	{ } 

^{blank}*"#".*$		{ }

"Xui_File"              { return XUI_FILE; }

"ProgramLibrary:"       { return P_LIB; }

"ProgramModule:"        { return P_MOD; }

"ProgramExec:"          { return P_EXEC; }

"ProgramHelp:"          { return P_HELP; }

"ProgramInput:"         { return P_INPUT; }

"ProgramOutput:"        { return P_OUTPUT; }

"ProgramDiagnostic:"    { return P_DIAG; }

"Label:"                { return LABEL; } 

"Text:"                 { return TEXT; } 

"FileBox:"              { return FILEBOX; } 

"Toggle:"               { return TOGGLE; } 

"RadioButton:"          { return RADIOBUTTON; }

"List:"                 { return LIST; }

"Slider:"               { return SLIDER; }

"Tab:"                  { return TAB; }

"Char:"                 { return CHAR; }

"Set_X:"                { return SET_X; }

"Set_Y:"                { return SET_Y; }

"Space:"                { return SPACE; }

"Blank_Line:"           { return BLANK_LINE; }

"Frame:"                { return FRAME; }

"RadioBox:"             { return RADIOBOX; }

"Separator:"            { return SEPARATOR; }

"Name:"                 { return NAME; }

"Columns:"              { return COLUMNS; }

"Rows:"                 { return ROWS; }

"Horizontal:"           { return HORIZONTAL; }

"Vertical:"             { return VERTICAL; }

"Sticky:"               { return STICKY; }

"Socket:"               { return SOCKET; }

"Stdin:"                { return STDIN; }

"Stdout:"               { return STDOUT; }

"Type:"                 { return TYPE; }

"Min:"                  { return MIN; }

"Max:"                  { return MAX; }

"Position:"             { return POSITION; }

"Variable:"             { return VARIABLE; }

"Default:"              { return DEFAULT; }

"Help:"                 { return HELP; }

"{"                     { return LB; }

"}"                     { return RB; }

{alphanum}*	        { yylval.s=strdup(yytext);       
                          return STRING; }

L?\"([^"\\\n]|{esc}|[\\"])*\"	 { yylval.s=yytext; 
                          if (yylval.s[0]=='"') {
                            strcpy(yylval.s,yylval.s+1);
                            if (yylval.s[strlen(yylval.s)-1]=='"')
                            yylval.s[strlen(yylval.s)-1]=0;
                          }
                          while (strstr(yylval.s,"\\\"")!=NULL)
                             strcpy(strstr(yylval.s,"\\\""),
                                    strstr(yylval.s,"\\\"")+1);
                          return STRING; }

"\\n"  		         { line_feed(); }

{blank}+		{  }

{other}			{  }

%%

/*

*/

echo()
{
  fprintf(stdout,"%s",yytext);
/* fprintf(stderr,"%s",yytext); */
}








