/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include "Panel.h"

extern void panel_update_message(Widget,char *);

static char buf1[1024],buf2[1024],buf3[1024];

static XtArgVal GetPixel(colorstr)
char *colorstr;
{
   XrmValue from, to;
 
   from.size = strlen(colorstr) +1;
   if (from.size < sizeof(String)) 
     from.size = sizeof(String);
   from.addr = colorstr;
   to.addr = NULL;
   XtConvert(top_level, XmRString, &from, XmRPixel, &to);
 
   return ((XtArgVal) *((XtArgVal *) to.addr));
}

char **panel_process(Panel *item,Pixel bg)
{
  Attribute *attribute;
  char *ptr,*str;
  static char *values[1000];
  int value_count=0;
  int tmp,n;
  short position;
  float value,value1;

  if ( item->program_library != NULL)
	sprintf(buf1,"program_library: %s ",item->program_library);
  else
	buf1[0] = '\0';
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;

  if (item->program_mod != NULL)
	sprintf(buf1,"program_module: %s ",item->program_mod);
  else
	buf1[0] = '\0';
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;

  if (item->program_exec != NULL)
  	sprintf(buf1,"program_exec: %s ",item->program_exec);
  else
	buf1[0] = '\0';
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;

  attribute=item->attribute;
  while (attribute!=NULL) {
    strcpy(buf1,"");
    switch (attribute->widget_type) {
    case RADIOBUTTON_WIDGET:
    case TOGGLE_WIDGET:
      if (XmToggleButtonGetState(attribute->w)) {
	sprintf(buf1,"%s ",attribute->variable);
      }
      break;
    case FILEBOX_WIDGET:
    case TEXT_WIDGET:
      XtVaGetValues(attribute->w,
		    XmNvalue,&str,
		    NULL);
      for (n=0; n<strlen(str); n++)
        if (!isalnum(str[n])&&!ispunct(str[n])) 
          str[n]=' ';
      if (strlen(str)!=0) {
				/* If first char is "$" then 
				   string must be a variable. */
	if (str[0]!='$') 
				/* Check type of input. */
	  switch (attribute->type) {
	  case NOT_TYPED:
	    break;
	  case INTEGER:
	    tmp=(int)strtol(str,&ptr,0);
	    if (strlen(ptr)!=0) {
	      XtVaSetValues(attribute->w,
			    XmNcursorPosition,(XmTextPosition)strlen(str),
			    XmNbackground, GetPixel("#ff0000"),
			    NULL);
	      XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
	      XBell(display,100);
	      panel_update_message(item->message_window,"Integer value only.");
	      values[0]=NULL;
	      return(values);
	    }
	    if (strlen(attribute->min_value)!=0) {
	      sscanf(attribute->min_value,"%f",&value1);
	      if (tmp<value1) {
		XtVaSetValues(attribute->w,
			      XmNcursorPosition,(XmTextPosition)strlen(str),
			      XmNbackground, GetPixel("#ff0000"),
			      NULL);
		sprintf(buf2,"Minimum acceptable integer value is %d.",
			(int)value1);
		XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
		XBell(display,100);
		panel_update_message(item->message_window,buf2);
		values[0]=NULL;
		return(values);
	      }
	    }
	    if (strlen(attribute->max_value)!=0) {
	      sscanf(attribute->max_value,"%f",&value1);
	      if (tmp>value1) {
		XtVaSetValues(attribute->w,
			      XmNcursorPosition,(XmTextPosition)strlen(str),
			      XmNbackground, GetPixel("#ff0000"),
			      NULL);
		sprintf(buf2,"Maximum acceptable integer value is %d.",
			(int)value1);
		XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
		XBell(display,100);
		panel_update_message(item->message_window,buf2);
		values[0]=NULL;
		return(values);
	      }
	    }
	    
	    break;
	  case FLOAT:
	    value=(float)strtod(str,&ptr);
	    if (strlen(ptr)!=0) {
	      XtVaSetValues(attribute->w,
			    XmNcursorPosition,(XmTextPosition)strlen(str),
			    XmNbackground, GetPixel("#ff0000"),
			    NULL);
	      XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
	      XBell(display,100);
	      panel_update_message(item->message_window,"Floating-point value only.");
	      values[0]=NULL;
	      return(values);
	    }
	    if (strlen(attribute->min_value)!=0) {
	      sscanf(attribute->min_value,"%f",&value1);
	      if (value<value1) {
		XtVaSetValues(attribute->w,
			      XmNcursorPosition,(XmTextPosition)strlen(str),
			      XmNbackground, GetPixel("#ff0000"),
			      NULL);
		sprintf(buf2,"Minimum acceptable integer value is %f.",value1);
		XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
		XBell(display,100);
		panel_update_message(item->message_window,buf2);
		values[0]=NULL;
		return(values);
	      }
	    }
	    if (strlen(attribute->max_value)!=0) {
	      sscanf(attribute->max_value,"%f",&value1);
	      if (value>value1) {
		XtVaSetValues(attribute->w,
			      XmNcursorPosition,(XmTextPosition)strlen(str),
			      XmNbackground, GetPixel("#ff0000"),
			      NULL);
		sprintf(buf2,"Maximum acceptable integer value is %f.",value1);
		XmProcessTraversal(attribute->w,XmTRAVERSE_CURRENT);
		XBell(display,100);
		panel_update_message(item->message_window,buf2);
		values[0]=NULL;
		return(values);
	      }
	    }
	    break;
	  case STRING:
	    break;
	  }
	panel_update_message(item->message_window,"");
	XtVaSetValues(attribute->w,
		      XmNbackground,bg,
		      NULL);
	XmUpdateDisplay(attribute->w);

	if (attribute->sticky) {
	  sprintf(buf1,"%s%s ",attribute->variable,str);
	} else {
	  sprintf(buf1,"%s %s ",attribute->variable,str);
	}
      }
      break;
    case SLIDER_WIDGET:
      XtVaGetValues(attribute->w,
		    XmNvalue,&tmp,
		    XmNdecimalPoints,&position,
		    NULL);
      if (position==0) {
	if (attribute->sticky) {
	  sprintf(buf1,"%s%d ",attribute->variable,tmp);
	} else {
	  sprintf(buf1,"%s %d ",attribute->variable,tmp);
	}
      } else {
	value=(double)tmp/pow(10.0,(double)position);
	if (attribute->sticky) {
	  sprintf(buf1,"%s%f ",attribute->variable,value);
	} else {
	  sprintf(buf1,"%s %f ",attribute->variable,value);
	}
      }
      break;
    }
    if (strlen(buf1)!=0) {
      if (values[value_count]!=NULL)
	free(values[value_count]);
      values[value_count]=strdup(buf1);
      value_count++;
      if (value_count>1000) {
	fprintf(stderr,"Internal error (value_count too large)\n");
	exit(1);
      }
    }
    attribute=attribute->next;
  }

  values[value_count]=NULL;
  return(values);
}


char **get_panel_defaults(Panel *item)
{
  Attribute *attribute;
  static char *values[1000];
  int value_count=0;

  sprintf(buf1,"program_library: %s ",item->program_library);
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;
  sprintf(buf1,"program_module: %s ",item->program_mod);
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;
  sprintf(buf1,"program_exec: %s ",item->program_exec);
  if (values[value_count]!=NULL)
    free(values[value_count]);
  values[value_count]=strdup(buf1);
  value_count++;

  attribute=item->attribute;
  while (attribute!=NULL) {
    strcpy(buf1,"");
    switch (attribute->widget_type) {
    case RADIOBUTTON_WIDGET:
    case TOGGLE_WIDGET:
      if (strcmp(attribute->default_value,"On")==0)
	sprintf(buf1,"%s ",attribute->variable);
      break;
    case FILEBOX_WIDGET:
    case TEXT_WIDGET:
      if (strlen(attribute->default_value)!=0) {
	if (attribute->sticky) {
	  sprintf(buf1,"%s%s ",attribute->variable,attribute->default_value);
	} else {
	  sprintf(buf1,"%s %s ",attribute->variable,attribute->default_value);
	}
      }
      break;
    case SLIDER_WIDGET:
      if (strlen(attribute->default_value)!=0) {
	if (attribute->sticky) {
	  sprintf(buf1,"%s%s ",attribute->variable,attribute->default_value);
	} else {
	  sprintf(buf1,"%s %s ",attribute->variable,attribute->default_value);
	}
      }
      break;
    }
    if (strlen(buf1)!=0) {
      if (values[value_count]!=NULL)
	free(values[value_count]);
      values[value_count]=strdup(buf1);
      value_count++;
      if (value_count>1000) {
	fprintf(stderr,"Internal error (value_count too large)\n");
	exit(1);
      }
    }
    attribute=attribute->next;
  }

  values[value_count]=NULL;
  return(values);
}

Attribute *get_panel_attribute(Panel *item,char *keyword)
{
  Attribute *attribute,*return_attribute=NULL;
  int len=0;

/* modified the code below to check first strlen(attribute->variable) characters
   of keyword, which now contains all unprocessed arguments. This allows multi-
   argument variables in the pattern files to work correctly.
					- 	Joe M. Wade 1/5/95
*/
  attribute=item->attribute;
  while (attribute!=NULL) {
    if (strlen(attribute->variable)>0) 
      if (strncmp(keyword,attribute->variable,  /* was strstr() != NULL */
		strlen(attribute->variable)) == 0) {
	if ((strlen(attribute->variable)>len)&&
	    (attribute->set_flag==0)) {	/* Make sure it is not set already. */
	  len=strlen(attribute->variable);
	  attribute->set_flag=1; /* Mark attribute as being set. */
	  if (return_attribute!=NULL)
	    return_attribute->set_flag=0; /* Unset flag. */
	  return_attribute=attribute;
	}
      }
    attribute=attribute->next;
  }
  return(return_attribute);
}

void set_panel(Panel *item,char *values)
{
  Attribute *attribute;
  char keyword[1024];

  attribute=item->attribute;
  while (attribute!=NULL) {
    attribute->set_flag=0;
    attribute=attribute->next;
  }

  strcpy(buf1,values);
  do {
    strcpy(keyword,"");
    sscanf(buf1,"%s",keyword);
    if (strlen(keyword)==0) {
      strcpy(buf1,"");
    } else {
/* this was (item,keyword) - we now want to pass all remaining arguments  */
       attribute=get_panel_attribute(item,strstr(buf1,keyword));
      
      if (attribute!=NULL) {
/*	if (strstr(keyword,attribute->variable)!=NULL) */
	  strcpy(buf1,strstr(buf1,attribute->variable)+
		 strlen(attribute->variable));
	
	
	switch (attribute->widget_type) {
	case RADIOBUTTON_WIDGET:
	case TOGGLE_WIDGET:
	  XmToggleButtonSetState(attribute->w,True,True);
	  break;
	case FILEBOX_WIDGET:
	case SLIDER_WIDGET:
	case TEXT_WIDGET:
	  sscanf(buf1,"%s",buf2);
	  if (buf2[0]=='"') {
	    strcpy(buf2,(char *)strchr(buf1,'"'));
	    if (strchr(buf2+1,'"')==NULL) {
	      fprintf(stderr,"Miss match \" in %s\n",values);
	      return;
	    }
	    strcpy(buf1,(char *)strchr(buf2+1,'"')+1);
	    strcpy((char *)strchr(buf2+1,'"'),"\"");
	  } else {
	    strcpy(buf1,strstr(buf1,buf2)+strlen(buf2));
	  }
	  XtVaSetValues(attribute->w,
			XmNvalue,buf2,
			NULL);
	  break;
	}
      } else {
	fprintf(stderr,"Unknown option %s\n",keyword);
	strcpy(buf1,strstr(buf1,keyword)+strlen(keyword));
      }
    }
  } while (strlen(buf1)>0);
}
