/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
number [0-9]
letter [a-zA-Z]
name {letter}*{number}*

%{

#include <stdio.h>

void create_wrapper();
%}


%%

"XmCreate"{name}    { create_wrapper(); }
.                   {   }            
"\n"                {   }

%%

FILE *out_cc,*out_h;

main()
{
  out_cc=fopen("XmCreateVa.c","w");
  out_h=fopen("XmCreateVa.h","w");

  yylex();

  fclose(out_h);
  fclose(out_cc);
}

yywrap()
{
  return(1); 
}

void create_wrapper()
{
  static int init=1;

  if (init) {
    fprintf(out_h,"#define XtNmanageChild \"XtNmanageChild\"\n");
  }
  fprintf(out_h,"extern Widget %sVa(Widget,String,...);\n",yytext); 

  if (init) {
    fprintf(out_cc,"#include <X11/Xlib.h>\n#include <X11/Xutil.h>\n");
    fprintf(out_cc,"#include <X11/Intrinsic.h>\n#include <X11/Shell.h>\n");
    fprintf(out_cc,"#include <X11/StringDefs.h>\n#include <X11/cursorfont.h>\n");
    fprintf(out_cc,"#include <Xm/XmAll.h>\n");
    fprintf(out_cc,"#include <stdarg.h>\n\n");
  }

  init=0;
  fprintf(out_cc,"Widget %sVa(Widget parent,String name,...)\n",yytext); 
  fprintf(out_cc,"{\n");
  fprintf(out_cc,"  va_list ap;\n");
  fprintf(out_cc,"  Widget tmp_widget;\n");
  fprintf(out_cc,"  String argname;\n");
  fprintf(out_cc,"  Arg args[50];\n");
  fprintf(out_cc,"  int i=0,manage_child=1;\n\n");
  fprintf(out_cc,"  va_start(ap,name);\n\n");
  fprintf(out_cc,"  while ((argname=va_arg(ap,String)) != (char *)0) { \n");
  fprintf(out_cc,"    if (strcmp(argname,\"XtNmanageChild\")==0) {\n");
  fprintf(out_cc,"      manage_child=(int)va_arg(ap,XtArgVal);\n");
  fprintf(out_cc,"    } else {\n");
  fprintf(out_cc,"      XtSetArg(args[i],argname,va_arg(ap,XtArgVal));\n");
  fprintf(out_cc,"      i++;\n");
  fprintf(out_cc,"    }\n");
  fprintf(out_cc,"  }\n\n");
  fprintf(out_cc,"  va_end(ap);\n\n");
  fprintf(out_cc,"  tmp_widget=%s(parent,name,args,i);\n\n",yytext);
  fprintf(out_cc,"  if (manage_child) \n");
  fprintf(out_cc,"    XtManageChild(tmp_widget);\n");
  fprintf(out_cc,"  return(tmp_widget);\n");
  fprintf(out_cc,"}\n\n\n");
}


