C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine uspclall (icon)

c******************************************************************
c******************************************************************
c******************************************************************
c
c Close all files associated with connection icon.
c
c******************************************************************
c******************************************************************
c******************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>


#ifdef SUNSYSTEM
      implicit   none
#endif

      integer    icon

      integer    nblen

      integer    icomp, jcomp, luin

      character  rname*(*)
      parameter (rname = 'uspclall()')

#include "uspinfo.h"



c
c    Deallocate any associated trace transpose buffer.
c
 
      call usptbf(icon)

 
c
c    Look for files to close
c

      do icomp = 1, maxcomp

          luin =
     1 LUIOMC(icomp,icon)
 
          if (luin .ge. 0) then
 
              do jcomp = 1, icomp - 1
                  if (luin .eq.
     1 LUIOMC(jcomp,icon)
     1                           ) then
c    Already closed this one! Skip it.
                      goto 100
                  endif
              enddo
 
c    OK, we haven't closed it already; close it.
 
              write (LERR, *) name(1:nblen(name)), ' ', rname,
     1        ': Closing logical unit ', luin, '.'
#ifdef SUNSYSTEM
              call flush(LERR)
#endif
              call lbclos (luin)
 
 100          continue
          endif

      enddo

      return
      end
