C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function uspdeadtrace(trace)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c uspdeadtrace:
c
c        Tell you whether a USP trace is live or dead.
c
c return value:
c     0: This trace is live
c     1: This trace is dead
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      real trace(*)
      integer uspdeadtrace
      integer stacor

#include "uspdeadtrace.h"

 
c
c    By convention, a "Station Correction" of 30000 is used as
c    a dead trace flag.
c
      call saver2(trace, ifmt_StaCor, l_StaCor,
     1                     ln_StaCor, stacor, TRACEHEADER)

      if (stacor .eq. 30000) then
c
c    The trace is dead!
c
          uspdeadtrace = 1
      else
c
c    The trace is alive!
c
          uspdeadtrace = 0
      endif

      return
      end
