C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c If this is defined, then getting a "partially successful open"
c (say, you wanted it read/write but only managed to open it for
c reading) will count as a "serious error", resulting in abortion
c of the opening process. If this is not defined then you'll get an
c error message but the file will still be opened. If you try to
c read or write to the file later and can't, you'll get a non-fatal
c error (with a return code from usprtrace or uspwtrace) at that time.
c
#define PARTIAL_OPEN_UNACCEPTABLE

      subroutine uspmic(ierror)

c**********************************************************************
c**********************************************************************
c**********************************************************************
c
c Make sure that a given unit is only opened ONCE. (It's perfectly
c OK to have multiple units reading from the same disk file, but
c they're going to step on each other's toes if they try to read
c from the same pipe.)
c
c Also check that if we've asked to read from or write to a file, we
c can actually do it.
c
c**********************************************************************
c**********************************************************************
c**********************************************************************

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer ierror

      integer icomp
      integer ifile, mcomp, ncomp, nblen, jcomp
      integer canr, canw, canrs, canws

      integer cfd1, cfd2, lucfd

      character  rname*(*)
      parameter (rname = 'uspmic()')
 
#include "uspinfo.h"


c
c Save the current values of these
c
      canrs = canread(curcon)
      canws = canwrite(curcon)


c
c Only check the first component of single-input files, because
c all the components will be associated with the same file.
c
      if (multiin(curcon) .eq. MI_PIPE .and. nc(curcon) .gt. 0) then
          mcomp = 1
      else
          mcomp = nc(curcon)
      endif

      do icomp = 1, mcomp
c
c Don't bother checking inputs that we didn't actually find!
c (Don't bother indenting this one either, for some reason.)
c
      if (
     1 LUIOMC(icomp,curcon)
     1                     .ge. 0) then


c
c First check to see that the read/write mode is consistent
c with what we need it to be. For now this will just result in
c a warning message.
c

          call lucrw(
     1 LUIOMC(icomp,curcon),
     1                       canr, canw)


          if (canread(curcon) .ne. 0 .and. canr .eq. 0) then

              write (LERR, *) name(1:nblen(name)), ' ', rname,
     1           ': Cannot read from connection ',
     1           curcon, ', file'
              write (LERR, *) '           ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        ''' as requested.'

#ifdef SUNSYSTEM
              call flush(LERR)
#endif

              write (LER , *) name(1:nblen(name)), ' ', rname,
     1           ': Cannot read from connection ',
     1           curcon, ', file'
              write (LER, *) '           ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        ''' as requested.'

              canrs = 0

#ifdef PARTIAL_OPEN_UNACCEPTABLE
              ierror = ierror + 1
#endif

          endif


          if (canwrite(curcon) .ne. 0 .and. canw .eq. 0) then

              write (LERR, *) name(1:nblen(name)), ' ', rname,
     1           ': Cannot write to connection ',
     1           curcon, ', file'
              write (LERR, *) '           ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        ''' as requested.'

#ifdef SUNSYSTEM
              call flush(LERR)
#endif

              write (LER , *) name(1:nblen(name)), ' ', rname,
     1           ': Cannot write to connection ',
     1           curcon, ', file'
              write (LER, *) '           ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1        ''' as requested.'

              canws = 0

#ifdef PARTIAL_OPEN_UNACCEPTABLE
              ierror = ierror + 1
#endif

          endif


c
c Now check this new stream with all previous ones.
c
          do ifile = 1, curcon
              if (ifile .eq. curcon) then
                  if (multiin(ifile) .eq. MI_PIPE) then
                      ncomp = 0
                  else
                      ncomp = icomp - 1
                  endif
              else
                  if (multiin(ifile) .eq. MI_PIPE .and.
     1                                       nc(ifile) .gt. 0) then
                      ncomp = 1
                  else
                      ncomp = nc(ifile)
                  endif
              endif

              do jcomp = 1, ncomp

c
c The IO is really done through C, not Fortran, so to check whether
c two streams are really the same we have to compare the associated
c C file descriptors. The routine "lucfd" converts a Fortran logical
c unit number back into a C file descriptor.
c
                  cfd1 = lucfd(
     1 LUIOMC(jcomp,ifile))
                  cfd2 = lucfd(
     1 LUIOMC(icomp,curcon))


#ifdef DEBUG
                  write (LERR, *) name(1:nblen(name)), ' ', rname,
     1 LUIOMC(jcomp,ifile),
     1 LUIOMC(icomp,curcon),
     1            ';    cfd1=', cfd1, ',    cfd2=', cfd2
#endif


c
c If the C file descriptors are the same we've got a problem!
c
                  if (cfd1 .eq. cfd2) then

                      write (LERR, *) name(1:nblen(name)), ' ', rname,
     1                ': Connection to ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1                ''' reused.'
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
                      write (LER , *) name(1:nblen(name)), ' ', rname,
     1                ': Connection to ''',
     1 FINAME(icomp,curcon)
     1 (1:nblen(FINAME(icomp,curcon))),
     1                ''' reused.'

                      ierror = ierror + 1
c
c One goof is already enough; don't bother to keep looking for more.
c
                      goto 100
                  endif
              enddo
          enddo


 100      continue
      endif
      enddo

c
c If even one component has the wrong permissions it disables reading
c or writing on the whole thing. (We didn't just change canread and
c canwrite directly so we would keep getting error messages for each
c screwed-up component file.)
c
      canread(curcon) = canrs
      canwrite(curcon) = canws

      return
      end
