C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function usppass(icon, lcount)

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#ifdef SUNSYSTEM
      implicit   none
#endif

      integer icon, lcount, usppass

      integer usprwtrace

      integer ii, jj, lucbefore
      integer nblen

      character  rname*(*)
      parameter (rname = 'usppass()')
 
#include "uspinfo.h"



      usppass = 0

c
c    We need to pass along
c    lcount - (lucount+1)
c    traces.
c
      lucbefore = lucount(icon)


#ifdef DEBUG
          write (LERR,*)
     1    'Passing through ', lcount - (lucbefore + 1), ' traces.'
#endif


      do ii = 1, lcount - (lucbefore + 1)
#ifdef DEBUG
          write (LERR,*)
     1    'Passing through trace ', lucbefore + ii
#endif

          if (0 .ne. usprwtrace(icon, READ,
     1                             scrtrace, trlen(icon),
     1                             lucbefore + ii)) then
              usppass = 1
              return
          endif

c
c    Search all the outputs opened after this one, to see if
c    they go with this one.
c
          do jj = icon + 1, curcon
              if (cinput(jj) .gt. 0 .and. cinput(jj) .eq. icon) then

c
c    Check this output isn't "tangled". (That is, the writing has
c    gotten AHEAD of the reading, or the writing has fallen behind
c    the reading and we can't seek.)
c
                  if ((lucount(jj) + 1 .gt. lucbefore + ii) .or.
     1                (lucount(jj) + 1 .lt. lucbefore + ii .and.
     1                 luseek(jj) .eq. 0)) then

                      write (LERR,*) name(1:nblen(name)), ' ', rname,
     1                ': Output ', jj, ', passed through from input ',
     1                icon, ',', ' is tangled.'
#ifdef SUNSYSTEM
                      call flush(LERR)
#endif
                      write (LER ,*) name(1:nblen(name)), ' ', rname,
     1                ': Output ', jj, ', passed through from input ',
     1                icon, ',', ' is tangled.'

c
c    Output jj is now thoroughly screwed up. Close it down.
c
                      canread(jj) = 0
                      canwrite(jj) = 0

                      usppass = 1

                  else

                      if (0 .ne. usprwtrace(jj, WRITE,
     1                             scrtrace, trlen(icon),
     1                             lucbefore + ii)) then
                          usppass = 1
                          return
                      endif

                  endif

              endif
          enddo

      enddo

      return
      end
