/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 * Memory management stuff that I couldn't do from Fortran.
 *
 * usptba allocates space for trace transpose buffers.
 * usptbr hands back the requested trace transpose buffer pointer.
 * usptbf frees a trace transpose buffer.
 * uspsta allocates space for scratch and null traces.
 *
 */

#include <stdio.h>
#include <malloc.h>


#ifndef F_USPTBA
#define F_USPTBA usptba_
#endif

#ifndef F_USPTBR
#define F_USPTBR usptbr_
#endif

#ifndef F_USPTBF
#define F_USPTBF usptbf_
#endif

#ifndef F_USPSTA
#define F_USPSTA uspsta_
#endif


static char   **trbuf = NULL;
static float   *scratch_trace = NULL;
static float   *null_trace = NULL;

static int      first_time = 1;

int
F_USPTBA (curcon, nbytes, maxfile, ierror)
    long           *curcon;
    long           *nbytes;
    long           *maxfile;
    long           *ierror;
{
int             ii;

    if (first_time)
    {
	first_time = 0;

	trbuf = (char **) malloc (
				  (unsigned) (sizeof (char *) * *maxfile));

	if (trbuf == NULL)
	{
	    (*ierror)++;
	    return 1;
	}
	else
	{
	    for (ii = 0; ii < *maxfile; ii++)
	    {
		trbuf[ii] = NULL;
	    }
	}
    }

    if (trbuf[*curcon] != NULL)
	(void) free ((char *) trbuf[*curcon]);

    trbuf[*curcon] = (char *) malloc ((unsigned) *nbytes);
    if (trbuf[*curcon] == NULL)
    {
	(*ierror)++;
	return 1;
    }

    return 0;
}

void
F_USPTBR (bufpointer, curcon, ierror)
    char          **bufpointer;
    long           *curcon;
    long           *ierror;
{
    if (trbuf[*curcon] == NULL)
	(*ierror)++;

    *bufpointer = trbuf[*curcon];

    return;
}

void
F_USPTBF (curcon)
    long           *curcon;
{
    if (first_time)
    {
/*
 * No trace transpose buffers were ever allocated. Just return.
 */
	return;
    }

    if (trbuf[*curcon] != NULL)
    {
	(void) free ((char *) trbuf[*curcon]);

	trbuf[*curcon] = NULL;
    }

    return;
}

int
F_USPSTA (maxtrlen, pscrtrace, pnulltrace)
    long           *maxtrlen;
    float         **pscrtrace;
    float         **pnulltrace;
{

    if (scratch_trace != NULL)
	(void) free ((char *) scratch_trace);

    scratch_trace = (float *) malloc ((unsigned) (*maxtrlen));


    if (null_trace != NULL)
	(void) free ((char *) null_trace);

    null_trace = (float *) calloc ((unsigned) (*maxtrlen), (unsigned) 1);



    if (scratch_trace == NULL || null_trace == NULL)
	return 1;
    else
    {
	*pscrtrace = scratch_trace;
	*pnulltrace = null_trace;
	return 0;
    }
}
