* Modified based on HeapSortAlgorithm.java
* 06/12/2001 G. Xia
*
* @(#)HeapSortAlgorithm.java   1.0 95/06/23 Jason Harrison
*
* Copyright (c) 1995 University of British Columbia
*
* Permission to use, copy, modify, and distribute this software
* and its documentation for NON-COMMERCIAL purposes and without
* fee is hereby granted provided that this copyright notice
* appears in all copies. Please refer to the file "copyright.html"
* for further important copyright and licensing information.
*
* UBC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
* THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
* TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE, OR NON-INFRINGEMENT. UBC SHALL NOT BE LIABLE FOR
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
*/
**
*
* @author Jason Harrison@cs.ubc.ca
* @version     1.0, 23 Jun 1995
*/

       subroutine hsort4(N,x,y,z,t)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y,z,t.             * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           y(N) - real array of size N                            * C
C *           z(N) - real array of size N                            * C
C *           t(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C *           z(N) rearranged according to x(N)                      * C
C *           t(N) rearranged according to x(N)                      * C
C ******************************************************************** C
       integer N,k,k0,M
       real x(*),y(*),z(*),t(*)
       real tx,ty,tz,tt

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         tz = z(k0)
         tt = t(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           z(k0) = z(j)
           t(k0) = t(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       z(k0) = tz
       t(k0) = tt
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         tz = z(1)
         tt = t(1)
         x(1) = x(M)
         y(1) = y(M)
         z(1) = z(M)
         t(1) = t(M)
         x(M) = tx
         y(M) = ty
         z(M) = tz
         t(M) = tt
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
         tz = z(k)
         tt = t(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             z(k) = z(j)
             t(k) = t(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty
         z(k) = tz
         t(k) = tt

         goto 2
       endif
       return
       end

       subroutine hsort3(N,x,y,z)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y,z.               * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           y(N) - real array of size N                            * C
C *           z(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C *           z(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       real x(*),y(*),z(*)
       real tx,ty,tz

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         tz = z(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           z(k0) = z(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       z(k0) = tz
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         tz = z(1)
         x(1) = x(M)
         y(1) = y(M)
         z(1) = z(M)
         x(M) = tx
         y(M) = ty
         z(M) = tz
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
         tz = z(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             z(k) = z(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty
         z(k) = tz

         goto 2
       endif
       return
       end

       subroutine hsort2(N,x,y)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y.                 * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           y(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       real x(*),y(*)
       real tx,ty

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         x(1) = x(M)
         y(1) = y(M)
         x(M) = tx
         y(M) = ty
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty


         goto 2
       endif
       return
       end

       subroutine hsorti(N,x,y)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y.                 * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           y(N) - integer array of size N                         * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       real    x(*)
       integer y(*)
       real    tx
       integer ty

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         x(1) = x(M)
         y(1) = y(M)
         x(M) = tx
         y(M) = ty
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty

         goto 2
       endif
       return
       end

       subroutine hsort1(N,x)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm.                   * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C ******************************************************************** C

       integer N, M, k, k0
       real x(*)
       real tx

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         x(1) = x(M)
         x(M) = tx
         M = M-1
         k = 1
         tx = x(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx

         goto 2
       endif
       return
       end

       subroutine hsort(N,x)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm.                   * C
C *                                                                  * C
C *    INPUT: x(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C ******************************************************************** C

       integer N, k, k0, M
       real x(*)
       real tx

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         x(1) = x(M)
         x(M) = tx
         M = M-1
         k = 1
         tx = x(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx

         goto 2
       endif
       return
       end

       subroutine hsrti2(N,x,y)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y.                 * C
C *                                                                  * C
C *    INPUT: x(N) - integer array of size N                         * C
C *           y(N) - real array of size N                            * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C ******************************************************************** C


c      INPUT: x(N) - array of size N
c             N    - size of the array
c      OUPUT: x(N) sorted in acending order
c
       integer N,k,k0,M
       integer x(*)
       real    y(*)
       integer tx
       real    ty

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         x(1) = x(M)
         y(1) = y(M)
         x(M) = tx
         y(M) = ty
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty

         goto 2
       endif
       return
       end

       subroutine isort2(N,x,y)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y.                 * C
C *                                                                  * C
C *    INPUT: x(N) - integer array of size N                         * C
C *           y(N) - integer array of size N                         * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       integer x(*)
       integer y(*)
       integer tx
       integer ty

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         x(1) = x(M)
         y(1) = y(M)
         x(M) = tx
         y(M) = ty
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty

         goto 2
       endif
       return
       end

       subroutine isort1(N,x)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm.                   * C
C *                                                                  * C
C *    INPUT: x(N) - integer array of size N                         * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C ******************************************************************** C

       integer  N, k, k0, M
       integer  x(*)
       integer  tx

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         x(1) = x(M)
         x(M) = tx
         M = M-1
         k = 1
         tx = x(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx

         goto 2
       endif
       return
       end

       subroutine isort3(N,x,y,z)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y,z.               * C
C *                                                                  * C
C *    INPUT: x(N) - integer array of size N                         * C
C *           y(N) - integer array of size N                         * C
C *           z(N) - integer array of size N                         * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C *           z(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       integer x(*),y(*),z(*)
       integer tx,ty,tz

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         tz = z(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           z(k0) = z(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       z(k0) = tz
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         tz = z(1)
         x(1) = x(M)
         y(1) = y(M)
         z(1) = z(M)
         x(M) = tx
         y(M) = ty
         z(M) = tz
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
         tz = z(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             z(k) = z(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty
         z(k) = tz

         goto 2
       endif
       return
       end

       subroutine isort4(N,x,y,z,t)
C ******************************************************************** C
C *  Subroutine to sort array X of length N into ascending           * C
C *  numerical order using the Heapsort algorithm, while making      * C
C *  the corresponding rearrangement of the array y,z,t.             * C
C *                                                                  * C
C *    INPUT: x(N) - integer array of size N                         * C
C *           y(N) - integer array of size N                         * C
C *           z(N) - integer array of size N                         * C
C *           t(N) - integer array of size N                         * C
C *           N    - size of the array                               * C
C *    OUPUT: x(N) sorted in acending order                          * C
C *           y(N) rearranged according to x(N)                      * C
C *           z(N) rearranged according to x(N)                      * C
C *           t(N) rearranged according to x(N)                      * C
C ******************************************************************** C

       integer N,k,k0,M
       integer x(*),y(*),z(*),t(*)
       integer tx,ty,tz,tt

       M = N
c - construct the heap
       do k = M/2, 1, -1
         k0 = k
         tx = x(k0)
         ty = y(k0)
         tz = z(k0)
         tt = t(k0)
         
 10      continue
         if (k0 .le. M/2) then
           j = k0 + k0
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
           endif
         endif
         if (tx .ge. x(j) ) then
           goto 20
         else
           x(k0) = x(j)
           y(k0) = y(j)
           z(k0) = z(j)
           t(k0) = t(j)
           k0 = j
         endif
         goto 10
       endif
 20    x(k0) = tx
       y(k0) = ty
       z(k0) = tz
       t(k0) = tt
       enddo


c - pop up the root and retain the heap shape
 2     continue
       if (M .gt. 1) then
         tx = x(1)
         ty = y(1)
         tz = z(1)
         tt = t(1)
         x(1) = x(M)
         y(1) = y(M)
         z(1) = z(M)
         t(1) = t(M)
         x(M) = tx
         y(M) = ty
         z(M) = tz
         t(M) = tt
         M = M-1
         k = 1
         tx = x(k)
         ty = y(k)
         tz = z(k)
         tt = t(k)
 30      continue
         if (k .le. M/2) then
           j = k + k
           if(j.lt.M) then
             if(x(j).lt.x(j+1)) then
               j = j + 1
             endif
           endif
           if (tx .ge. x(j) ) then
             goto 40
           else
             x(k) = x(j)
             y(k) = y(j)
             z(k) = z(j)
             t(k) = t(j)
             k = j
           endif
           goto 30
         endif
 40      x(k) = tx
         y(k) = ty
         z(k) = tz
         t(k) = tt

         goto 2
       endif
       return
       end
