C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       BUTT                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      BUTT  (FREQLC,FREQHC,SPS,FI,G)                                  *
C  ARGUMENTS:                                                          *
C      FREQLC  REAL    ??IOU*      -                                   *
C      FREQHC  REAL    ??IOU*      -                                   *
C      SPS     REAL    ??IOU*      -                                   *
C      FI      REAL*4  ??IOU*  (8) -                                   *
C      G       REAL    ??IOU*      -                                   *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      FILCO -                                                         *
C      GAIN  -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      2 DETECTED                               *
C      COMPLEX*                                                        *
C      REAL*                                                           *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE BUTT(FREQLC,FREQHC,SPS,FI,G)
C     BUTTERWORTH FILTER PROGRAM
C  CALCULATES AND OUTPUTS THE FILTER COEFFICIENTS AND GAIN REQUIRED
C    FOR THE FILTER PERFORM PROGRAM
C
C     PARAMETERS OF EACH FILTER TO BE DESIGNED ARE READ IN ON A SEPARATE
C     THESE ARE:
C     FREQLC   LOW CUT FREQUENCY,IN HZ, WHERE GAIN IS TO BE DOWN BY 3 DB
C             (6 DB. IF FILTER IS USED IN ZERO PHASE-SHIFT WAY)
C     FREQHC  HIGH CUT FREQUENCY,IN HZ, WHERE GAIN IS TO BE DOWN BY 3 DB
C             (6 DB. IF FILTER IS USED IN ZERO PHASE-SHIFT WAY)
C     SPS     NUMBER OF SAMPLES PER SECOND FOR THE DATA WHICH IS TO BE F
C
      COMPLEX*8 Z P BW(4)
      REAL*4 FI(8)
      Z P BW(1)=(-0.9239,+0.3827)
      Z P BW(2)=(-0.9239,-0.3827)
      Z P BW(3)=(-0.3827,+0.9239)
      Z P BW(4)=(-0.3827,-0.9239)
      CALL FILCO(FREQLC,FREQHC,SPS ,Z P BW,FI)
      III = 3000
      CALL GAIN(FREQLC,FREQHC,SPS,III,FI,G)
      DO 1 I=1,8
    1 IF(ABS(FI(I)) .LT. 1.E-10) FI(I)=0.
C     WRITE(6,200) (FI(I),I=1,8)
C 200 FORMAT(' BUTTERWORTH COEFFS= ',(5E12.4))
C     WRITE(6,201) G
C 201 FORMAT(' BUTTERWORTH GAIN= ',E12.4)
      RETURN
      END
