C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CROSS                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CROSS  (LX,X,LY,Y,LG,G)                                         *
C  ARGUMENTS:                                                          *
C      LX      INTEGER  ??IOU*      -                                  *
C      X       REAL     ??IOU*  (*) -                                  *
C      LY      INTEGER  ??IOU*      -                                  *
C      Y       REAL     ??IOU*  (*) -                                  *
C      LG      INTEGER  ??IOU*      -                                  *
C      G       REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      DOTPR -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MIN0    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE CROSS(LX,X,LY,Y,LG,G)
C
C     CROSS COMPUTES THE CROSS PRODUCT BETWEEN TWO VECTORS.
C     REFERENCE: EAR MULTICHANNEL VOLUME, P. 27.
C
C     INPUTS ARE
C         LX=  LENGTH OF X SERIES
C         X=   X SERIES
C         LY=  LENGTH OF Y SERIES
C         Y= Y SERIES
C         LG=  NUMBER OF LAGS,FROM 0 TO LG-1,DESIRED IN CROSS PRODUCT
C     OUTPUT IS
C         G=   CROSS PRODUCT GIVEN BY (WHERE THE SUM IS OVER ALL I)
C
C
C              G(K) = SUM X(I+K)*Y(I)
C
C              WHERE VALUES OF X AND Y OUTSIDE OF THEIR RANGES ARE
C              TAKEN TO BE ZERO.
C
      DIMENSION X(*),Y(*),G(*)

      if(lg .gt. 0) then

         DO 1 I=1,LG
    1       call dotpr(x(i),1,y,1,g(i),min0(ly+i-1,lx)-i+1)
c   1       CALL DOT(MIN0(LY+I-1,LX)-I+1,X(I),Y,G(I))

      else if(lg .lt. 0) then

            lg2=-lg
            lg1=lg2+1
            do 2 i=1,lg1
               call dotpr(x(i),1,y,1,g(i+lg2-1),min0(ly+i-1,lx)-i+1)
c              call dot(min0(ly+i-1,lx)-i+1,x(i),y,g(i+lg2-1))
    2       continue
            do 3 i=1,lg2
               ii=lg2-i+1
               call dotpr(y(i),1,x,1,g(ii),min0(lx+i-1,ly)-i+1)
c              call dot(min0(lx+i-1,ly)-i+1,y(i),x,g(ii))
    3       continue

      endif

      RETURN
      END
