C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CROSS0                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CROSS0  (LX,X,LY,Y,LG,G)                                        *
C  ARGUMENTS:                                                          *
C      LX      INTEGER  ??IOU*       -                                 *
C      X       REAL     ??IOU*  (LX) -                                 *
C      LY      INTEGER  ??IOU*       -                                 *
C      Y       REAL     ??IOU*  (LY) -                                 *
C      LG      INTEGER  ??IOU*       -                                 *
C      G       REAL     ??IOU*  (LG) -                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      DOT -                                                           *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      MIN0    INTEGER -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE CROSS0(LX,X,LY,Y,LG,G)
C
C     CROSS COMPUTES THE CROSS PRODUCT BETWEEN TWO VECTORS.
C     REFERENCE: EAR MULTICHANNEL VOLUME, P. 27.
C
C     INPUTS ARE                                                        CRO70040
C         LX=  LENGTH OF X SERIES                                       CRO70050
C         X=   X SERIES                                                 CRO70060
C         LY=  LENGTH OF Y SERIES                                       CRO70070
C         Y= Y SERIES                                                   CRO70080
C         LG=  NUMBER OF LAGS,FROM 0 TO LG-1,DESIRED IN CROSS PRODUCT   CRO70090
C     OUTPUT IS                                                         CRO70100
C         G=   CROSS PRODUCT GIVEN BY (WHERE THE SUM IS OVER ALL I)     CRO70110
C                                                                       CRO70120
C                                                                       CRO70130
C              G(K) = SUM X(I+K)*Y(I)                                   CRO70140
C                                                                       CRO70150
C              WHERE VALUES OF X AND Y OUTSIDE OF THEIR RANGES ARE      CRO70160
C              TAKEN TO BE ZERO.                                        CRO70170
C
      DIMENSION X(LX),Y(LY),G(LG)
      DO 1 I=1,LG                                                       CRO70180
    1 CALL DOT(MIN0(LY+I-1,LX)-I+1,X(I),Y,G(I))                         CRO70190
      RETURN                                                            CRO70200
      END
