C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  fit (X, Y, nsamp, stdd, iflag, A, B, stdda, stddb, 
     1                 chi2)

#include <f77/iounit.h>

c   fit equation of the form  Y = B*X + A to data points Y(i) & X(i)
c   with std devs STDD(i) by minimizing the Chi **2
c   B = slope
c   A = intercept
c   iflag = 0 assumes STDD(i) are all 0
c   iflag > 0 assumes STDD(i) != 0

      real    X(*), Y(*), STDD(*)
      real    A, B, stdda, stddb, chi2, sum
      integer iflag, nsamp

      xx  = 0
      yy  = 0.
      tt2 = 0.
      b   = 0.

      IF (iflag .ne. 0) THEN

         sum = 0.
         do  i = 1, nsamp
             sum = sum + STDD(i)
         enddo
         if (sum .eq. 0.0) then
            write(LERR,*)'Std deviations all zero in fit -- FATAL'
            write(LER ,*)'Std deviations all zero in fit -- FATAL'
            call ccexit(666)
         endif

         tt = 0.
         do  i = 1, nsamp
             wt = 1./(STDD(i) **2)
             tt = tt + wt
             xx = xx + x(i)*wt
             yy = yy + y(i)*wt
         enddo

      ELSE

         do  i = 1, nsamp
             xx = xx + x(i)
             yy = yy + y(i)
         enddo

         tt = float(nsamp)

      ENDIF

      xxott = xx/tt

      IF (iflag .ne. 0) THEN

         do  i = 1, nsamp
             t = (x(i) - xxott)/STDD(i)
             tt2 = tt2 + t*t
             B = B + t*y(i)/STDD(i)
         enddo

      ELSE

         do  i = 1, nsamp
             t = x(i) - xxott
             tt2 = tt2 + t*t
             b = b + t*y(i)
         enddo

      ENDIF

      b = b/tt2
      a = (yy - xx*b)/tt
      STDDA = sqrt((1. + xx*xx/(tt*tt2))/tt)
      STDDB = sqrt(1./tt2)
      CHI2 = 0.

      IF (iflag .eq. 0) THEN

         do  i = 1, nsamp
             CHI2 = CHI2 + (y(i) - A - B*x(i)) **2
         enddo

         ttdddat = sqrt(CHI2/float(nsamp-2))
         STDDA = STDDA * ttdddat
         STDDB = STDDB * ttdddat

      ELSE

         do  i = 1, nsamp
             CHI2 = CHI2 + (y(i) - A - B*x(i))/STDD(i)**2
         enddo

      ENDIF

      return
      end
 


