C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FOLD                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:                                                            *
C      This subroutine finds the complete transient convolution of the *
C      vectors A and B.                                                *
C  ENTRY POINTS:                                                       *
C      FOLD  (LA,A,LB,B,LC,C)                                          *
C  ARGUMENTS:                                                          *
C      LA  I*4  I - LENGTH OF VECTOR A IN SAMPLES                      *
C      A       REAL     ??IOU*  (*) -                                  *
C      LB  I*4  I - THE LENGTH OF VECTOR B IN SAMPLES                  *
C      B       REAL     ??IOU*  (*) -                                  *
C      LC  I*4  O - THE LENGTH OF VECTOR C (LA + LB - 1)               *
C      C       REAL     ??IOU*  (*) -                                  *
C  CATEGORY:  UTILITY ARRAY CONVOLVE FILTER                            *
C  KEYWORDS:  CONVOLUTION                                              *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:    ?                               ORIGIN DATE:     96/02/08*
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      MOVE     - USED TO ZERO THE VECTOR C ARRAY BEFORE CONVOLUTION   *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:                                                     *
C  GENERAL DESCRIPTION:                                                *
C            NOTE: THIS SUBROUTINE ZEROS THE VECTOR C PRIOR            *
C                  TO CONVOLUTION                                      *
C                                                                      *
C  REVISED BY:  JOE M.WADE                    REVISION DATE: 02/15/89  *
C                                                                      *
C               SIMULATES ORIGINAL FOLD ROUTINE                        *
C               USING FILTERG ROUTINE IN CRAY SCIENTIFIC LIBRARY       *
C                                                                      *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 96/02/08 ==================   *
C  ROUTINE TYPE:  SUBROUTINE  SINGLE_ENTRY                             *
C      A   R*4  I  ( 2 ) - THE VECTOR A A(1),A(2),.....,A(LA)          *
C      B   R*4  I  ( 2 ) - THE VECTOR B B(1),B(2),.....,B(LA)          *
C      C   R*4  O  ( 2 ) - THE COMPLETE TRANSIENT CONVOLUTION VECTOR C *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
#include <f77/localsys.h>
      SUBROUTINE FOLD (LA,A,LB,B,LC,C)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       FOLD
C  ROUTINE TYPE:  SUBROUTINE  SINGLE_ENTRY
C  PURPOSE:
C      This subroutine finds the complete transient convolution of the
C      vectors A and B.
C  ARGUMENTS:
C      LA  I*4  I - LENGTH OF VECTOR A IN SAMPLES
C      A   R*4  I  ( 2 ) - THE VECTOR A A(1),A(2),.....,A(LA)
C      LB  I*4  I - THE LENGTH OF VECTOR B IN SAMPLES
C      B   R*4  I  ( 2 ) - THE VECTOR B B(1),B(2),.....,B(LA)
C      LC  I*4  O - THE LENGTH OF VECTOR C (LA + LB - 1)
C      C   R*4  O  ( 2 ) - THE COMPLETE TRANSIENT CONVOLUTION VECTOR C
C  CATEGORY:  UTILITY ARRAY CONVOLVE FILTER
C  KEYWORDS:  CONVOLUTION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    ?                               ORIGIN DATE:     ?
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      MOVE     - USED TO ZERO THE VECTOR C ARRAY BEFORE CONVOLUTION
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  ERROR HANDLING:
C  GENERAL DESCRIPTION:
C            NOTE: THIS SUBROUTINE ZEROS THE VECTOR C PRIOR
C                  TO CONVOLUTION
C
C  REVISED BY:  JOE M.WADE                    REVISION DATE: 02/15/89
C
C               SIMULATES ORIGINAL FOLD ROUTINE
C               USING FILTERG ROUTINE IN CRAY SCIENTIFIC LIBRARY
C
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C     THIS IS A CONFIDENTIAL AMOCO PRODUCTION COMPANY PROGRAM           NE
C
C     THIS SUBROUTINE FINDS THE COMPLETE TRANSIENT CONVOLUTION OF THE
C     VECTORS A AND B
C
C     INPUTS ARE
C        LA=LENGTH OF THE VECTOR A    INTEGER*4
C         A=THE VECTOR A, A(1),A(2),...A(LA)      REAL*4
C        LB=LENGTH OF THE VECTOR B      INTEGER*4
C         B=THE VECTOR B, B(1),B(2),...B(LB)    REAL*4
C     OUTPUTS ARE
C        LC=LA+LB-1=LENGTH OF THE VECTOR C     INTEGER*4
C         C=THE COMPLETE TRANSIENT CONVOLUTION VECTOR C     REAL*4
C
C     NOTE--THIS SUBROUTINE ZEROS THE VECTOR C PRIOR TO CONVOLUTION
C
C          THIS SUBROUTINE IS MAINTAINED BY A. DOWDY
C
      DIMENSION A(*),B(*),C(*)
#ifdef CRAYSYSTEM
      DIMENSION A2(24000),B2(12000)
#endif
      LC=LA+LB-1
      CALL MOVE(0,C,0,LC*4)
#ifndef CRAYSYSTEM
      DO 10 I=1,LA
      DO 10 J=1,LB
      K=I+J-1
   10 C(K)=A(I)*B(J)+C(K)
#else
C
C   perform same operation using filterg routine
C
      LAG = LB - 1
      call MOVE(0,A2(1),0,LAG*8)
      call MOVE(1,A2(LAG+1),A,LA*8)
      call MOVE(0,A2(LAG+LA+1),0,LAG*8)
      call MOVE(1,B2,B,LB*8)
      call VRVRS(B2,1,LB)
      LA2 = LA + (2 * LB) - 2
      call FILTERG(B2,LB,A2,LA2,C)
#endif
      RETURN
      END
