/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*	These routines were designed to provide a generic date
	and time interface for both fortran and C programs. It
	is to be called as a function. Called from fortran, the 
	calling program must provide the character*8 variable
	into which the result is saved. Called from C, this 
	program returns a character pointer to malloc'ed 
	memory containing the date or time.
					- joe m. wade 05/30/91
*/

#include <stdio.h>
#include <sys/types.h>
#include <ut_defs.h>

#if defined( SUNSYSTEM ) || defined( HPUXSYSTEM ) || defined( AIXSYSTEM )
#include <sys/timeb.h>
#endif

#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

#include <time.h>

#ifndef CRAYSYSTEM
void F_FGTIME(ftime,len_ftime)
char *ftime;
long int len_ftime;
#else
#ifdef CRAYSYSTEM
void F_FGTIME(fcd_time)
_fcd fcd_time;
#endif
#endif
{
#ifdef CRAYSYSTEM
	char *ftime = _fcdtocp(fcd_time);
	unsigned len_ftime = _fcdlen(fcd_time);
#endif
	char *cgtime();
	char *ctime = cgtime();
	strncpy(ftime,ctime,(int)len_ftime);
	free(ctime);
	return;
}

char *cgtime()
{
	void generic_time();
	char *ctime = (char *)malloc(9*sizeof(char));
	generic_time(ctime);
	return(ctime);
}

void generic_time(gtime)
char *gtime;
{
	struct tm *ltime;
	time_t timeoday;

	timeoday = time((time_t *)0);
	ltime = localtime(&timeoday);
	sprintf(gtime,"%02d:%02d:%02d",
		ltime->tm_hour,ltime->tm_min,ltime->tm_sec);
}

#ifndef CRAYSYSTEM
void F_FGDATE(fdate,len_fdate)
char *fdate;
long int len_fdate;
#else
void F_FGDATE(fcd_date)
_fcd fcd_date;
#endif
{
#ifdef CRAYSYSTEM
	char *fdate = _fcdtocp(fcd_date);
	unsigned len_fdate = _fcdlen(fcd_date);
#endif
	char *cgdate();
	char *cdate = cgdate();
	strncpy(fdate,cdate,len_fdate);
	free(cdate);
	return;
}

char *cgdate()
{
	void generic_date();
	char *cdate = (char *)malloc(9*sizeof(char));
	generic_date(cdate);
	return(cdate);
}

void generic_date(gdate)
char *gdate;
{
	struct tm *ltime;
	time_t timeoday;

	timeoday = time((time_t *)0);
	ltime = localtime(&timeoday);
	ltime->tm_year = ltime->tm_year % 100;	/* Y2K fix */
	sprintf(gdate,"%02d/%02d/%02d",
		ltime->tm_mon+1,ltime->tm_mday,ltime->tm_year);
}

