C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ICOPEN                                               *
C  ROUTINE TYPE:  FUNCTION  INTEGER                                    *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ICOPEN  INTEGER  (NAME,IUNIT)                                   *
C      COPEN  INTEGER  (NAME,IUNIT)                                    *
C  ARGUMENTS:                                                          *
C      NAME    CHAR*(*)  ??IOU* -                                      *
C      IUNIT   INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR          -                                               *
C      LENTH   INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      0      ( OUTPUT SEQUENTIAL ) -                                  *
C      IUNIT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C This is the preliminary version of a routine that will be used	C
C to maintain the usage of editable card images as a useful input	C
C system in UNIX operating system environments.				C
C In particular, it is designed to replace existing calls to 'open'	C
C in various FORTRAN programs.  It reads the card image information	C
C from the commandline string assocaited with 'name', which is then	C	
C written out in 80 character chunks to a scratch connected to the 	C
C passed in logical unit 'iunit'.  Hopefully this will make the		C
C change in operating systems nearly invisible to existing FORTRAN	C
C programs.  It appears to work on the test files in this directory,	C
C but has not been practically or usefully tested.  Robert Read 5/27/87 C
C                                                                       C
C ** revisions:                                                         C
C  The BLANK = 'ZERO' option was added to the OPEN statement for the    C
C  logical unit to which the data cards were written. This change was   C
C  necessary to correct a problem in the handling of implied decimal    C
C  places.                                      - Joe M. Wade 9/2/87    C
C                                                                       C
C ** revisions:                                                         C
C  Upon conversion to the Sun, the unit number passed in is closed      C
C  before opening as a scratch file to correct for the case where unit  C
C  5 is associated with stdin.                  - Joe M. Wade 11/15/87  C
C                                                                       C
C ** revisions:                                                         C
C  The "FILE=" parameter has been added to the open statement for the   C
C  scratch file to correct for a bug on the Cray. This should not       C
C  affect the performance in any way and the file should still be       C
C  allocated with a temporay name and deleted upon completion of the    C
C  host program.                                - Joe M. Wade 12/15/87  C
C                                                                       C
C ** revisions:                                                         C
C  Changed for compatibility with argstr subroutine in new fortran      C
C  utility library. The call was previously a function call. The return C
C  value is now checked to see if the card file was found.              C
C                                               - Joe M. Wade  2/15/89  C
C ** revisions:								C
C  Dropped the "FILE=" with the advent of Unicos 6.0 and cft77.3.1	C
C						- Joe M. Wade 01/08/89  C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      function icopen(name,iunit)
      entry copen(name,iunit)
      character*(*) name
      character*80 card
      character*20480 str
      integer i,copen,iunit,len
C
      close(UNIT=iunit,STATUS='DELETE')
C
C         The FILE= parameter has been added to get by a bug on the
C         Cray version of this program. The file (at least at this time)
C         is never actually written except to a tmp.---- file. If any
C         files start cropping up with the name icopen.tmp, please
C         contact me.                       - Joe M. Wade
C         *** dropped the FILE= with the advent of Unicos 6.0 and
C         cft77.3.1.                        - Joe M. Wade 01/08/89
C
      open(UNIT=iunit, IOSTAT=i, ERR = 20, BLANK = 'ZERO',
     1     STATUS = 'SCRATCH')
c     open(UNIT=iunit, IOSTAT=i, ERR = 20, BLANK = 'ZERO',
c    1     STATUS = 'SCRATCH',FILE='icopen.tmp')
      call argstr(name,str,'error','error')
      if (str .eq. 'error') then
c               write(0,*) 'icopen: argument ',name,' not found.'
                icopen = 0
                copen = 0
                return
      endif
      len = lenth(str)
      do 30 i = 1,len,80
                card = str(i:i+79)
                write(iunit,10) card
30    continue
      rewind(iunit)
10    format(A80)
      icopen = len
      copen = len
      return
20    write(0,*) 'icopen: error opening scratch file',i
      end
