C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       MDIAN2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      MDIAN2  (X,N,XMED)                                              *
C  ARGUMENTS:                                                          *
C      X       REAL     ??IOU*  (*) -                                  *
C      N       INTEGER  ??IOU*      -                                  *
C      XMED    REAL     ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ABS     GENERIC -                                               *
C      MIN     GENERIC -                                               *
C      MAX     GENERIC -                                               *
C      MOD     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine mdian2 (x, n, xmed)
 
c   routine to compute median of an array x of n numbers
 
c   method is an iterative one that does not require sorting the data
 
      parameter (big=1.e30, afac=1.5, amp=1.5)
      real       x(*)
 
      ipas =  0
      a    =  .5 * (x(1) + x(n))
      eps  =  abs(x(n) - x(1))
      ap   =  big
      am   = -big
 
1     continue
 
      ipas = ipas + 1
      sum  =  0.
      sumx =  0.
      np   =  0
      nm   =  0
      xp   =  big
      xm   = -big
 
      do  11  j = 1, n
 
          xx = x(j)
          if (xx .ne. a) then
 
             if     (xx .gt. a) then
                     np = np + 1
                     if (xx .lt. xp) xp = xx
             elseif (xx .lt. a) then
                     nm = nm + 1
                     if (xx .gt.  xm) xm = xx
             endif
             dum  = 1./(eps + abs(xx-a))
             sum  = sum + dum
             sumx = sumx + xx * dum
          endif
11    continue
 
      if (np-nm .gt. 2) then
 
         am = a
         aa = xp + max(0., sumx/sum - a) * amp
         if (aa .gt. ap) aa = .5 * (a + ap)
         eps = afac * abs(aa - a)
         a = aa
         go to 1
 
      elseif (nm-np .gt. 2) then
 
         ap = a
         aa = xm + min(0.,sumx/sum - a) * amp
         if (aa .lt. am) aa = .5 * (a + am)
         eps = afac * abs(aa - a)
         a = aa
         go to 1
 
      else
 
         if (mod(n,2) .eq. 0) then
            if (np .eq. nm) then
               xmed = .5 * (xp + xm)
            elseif (np .gt. nm) then
               xmed = .5 * (a + xp)
            else
               xmed = .5 * (xm + a)
            endif
         else
            if (np .eq. nm) then
               xmed = a
            elseif (np .gt. nm) then
               xmed = xp
            else
               xmed = xm
            endif
         endif
 
      endif
 
      return
      end
