C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       OPNLST                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      OPNLST  (LUPRT,LUER,LUTEMP,NAME)                                *
C  ARGUMENTS:                                                          *
C      LUPRT   INTEGER   ??IOU* -                                      *
C      LUER    INTEGER   ??IOU* -                                      *
C      LUTEMP  INTEGER   ??IOU* -                                      *
C      NAME    CHAR*(*)  ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGSTR         -                                                *
C      GETPPS         -                                                *
C      INTSTR  CHAR*3 -                                                *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUER   ( OUTPUT SEQUENTIAL ) -                                  *
C      LUPRT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      2000  ( 1) -                                                    *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/localsys.h>
c***********************************************************************
c                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c  routine:       opnlst                                               *
c  routine type:  subroutine                                           *
c  purpose:                                                            *
c      on cray unicos system, open logical unit luprt to receive the   *
c      output run time listing of the calling program.  the name of    *
c      the file to receive the listing is derived in three ways:       *
c      1) if -L is not specified on the command line, the output       *
c      listing file name is build using subroutine openpr, which is    *
c      compatible with the startjob system for program control.        *
c      2) if -L is present on the command line with no argument, the   *
c      output listing file name is generated from the calling program  *
c      and the process i.d. (pid) and parent process i.d. (ppid)       *
c      numbers using gutowski's method.                                *
c      3) if -L is present on the command line with an argument after  *
c      the -L flag, that argument is used as the file name.            *
c      note that any calling program using a command line input flag   *
c      of -L for some other purpose will conflict with this routine.   *
c                                                                      *
c  entry points:                                                       *
c      opnlst  (luprt,luer,lutemp,name)                                *
c  arguments:                                                          *
c      luprt   integer     i - logical unit assigned to listing file   *
c      luer    integer     i - standard error output for error message *
c      lutemp  integer     i - logical unit used by openpr             *
c      name    char*(*)    i - name of calling program                 *
c       +------------------------------------------------------+       *
c       |               development information                |       *
c       +------------------------------------------------------+       *
c  author:   bill done                          origin date: 87/05/27  *
c  language: fortran 77                  date last compiled: 88/03/29  *
c       +------------------------------------------------------+       *
c       |                 external environment                 |       *
c       +------------------------------------------------------+       *
c  routines called:                                                    *
c      getpps         - gets pid and ppid                              *
c      intstr  char*3 - converts integer argument to character string  *
c  intrinsic functions called:  none                                   *
c  files:                                                              *
c      luer  ( output sequential )  - standard error output            *
c      luprt  ( output sequential ) - logical unit for run listing     *
c  common:           none                                              *
c  stop codes:       none                                              *
c       +------------------------------------------------------+       *
c       |             other documentation details              |       *
c       +------------------------------------------------------+       *
c  error handling:                                                     *
c      error exit if logical unit luprt not opened successfully.       *
c      an error message is printed to luer (standard error) if this    *
c      occurs.                                                         *
c                                                                      *
c  general description:  see purpose                                   *
c                                                                      *
c  revised by:  bill done                     revision date: 87/06/16  *
c      modify to all name for output sysout file to be specified       *
c      on command line as well as generated automatically.             *
c                                                                      *
c  revised by:  bill done                     revision date: 88/04/04  *
c      modify to handle startjob system.  replace call ccexit with     *
c      stop.  renamed to opnlst from opnpid, upon which this is based. *
c                                                                      *
c  revised by:  bill done                     revision date: 89/05/22  *
c      using C preprocessor commands, combine the function of routine  *
c      opnsun into opnlst.                                             *
c                                                                      *
c  revised by:  Joe Wade                     revision date: 94/02/24   *
c      Changed the code to have conditions for all architectures, not  *
c      just Sun and Cray.					       *
c                                                                      *
c       +------------------------------------------------------+       *
c       |                 analysis information                 |       *
c       +------------------------------------------------------+       *
c  nonstandard features:   none detected                               *
c*******************   end of documentation package   ******************
c***********************************************************************
      subroutine opnlst (luprt, luer, lutemp, name)
      character*(*) name
      character*79 runlst, sysout
      character*3 pid6, ppid6, intstr
      character*2 name2
      integer pid, ppid
c
c     check command line for output run listing file, flag -L
c
#ifdef CRAYSYSTEM
      call argstr ('-L', runlst, 'default', ' ')
#else
      call argstr ('-L', runlst, ' ', ' ')
#endif
c
c     build filename, depending on value of runlst
c
      if (runlst .eq. ' ') then
#ifndef CRAYSYSTEM
c
c        runlst is ' ', build file name from process i.d.
c
         call getpps (pid, ppid)
         ppid6 = intstr (ppid)
         pid6 = intstr (pid)
         sysout = name//'.'//ppid6//'.'//pid6
         open (luprt, file=sysout, iostat=ierr)
#else
c
c        open printout file compatible with startjob system.
c        name2 will consist of the 2 leftmost letters of name.
c
         name2 = name
         call openpr (lutemp, luprt, name2, ierr)
         if (ierr .ne. 0) then
            write (luer,1000)
 1000       format(' OPNLST:  error opening listing file with openpr')
            stop 1000
         endif
       else if (runlst .eq. 'default') then
c
c        runlst is 'default', build file name from process i.d.
c
         call getpps (pid, ppid)
         ppid6 = intstr (ppid)
         pid6 = intstr (pid)
         sysout = name//'.'//ppid6//'.'//pid6
         open (luprt, file=sysout, iostat=ierr)
#endif
       else
c
c        runlst is explicitly set in command line
c
         sysout = runlst
         open (luprt, file=sysout, iostat=ierr)
      endif
c
c     error check on runlst not equal to blank case
c
      if (runlst .ne. ' ') then
         if (ierr .ne. 0) then
            write (luer,2000) sysout
2000        format(/' Error opening output listing file:'/1x,a79//)
            stop 2000
         endif
         write (luprt,3000) sysout
3000     format(1x,a79)
      endif
      return
      end
