C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ORDFFT                                               *
C  ROUTINE TYPE:  FUNCTION  INTEGER                                    *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      ORDFFT  INTEGER  (NPTS)                                         *
C  ARGUMENTS:                                                          *
C      NPTS    INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ALOG10  REAL -                                                  *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      integer function ordfft (npts)
c
c     Written by:  Bill Done
c
c     Given the integer npts, not necessarily a power of 2, this function
c     computes that power of 2 (nu) such that 2**nu >= npts.
c
      if (npts .ge. 2) then
         nu = alog10(float(npts))/alog10(2.)
         if (npts .gt. 2**nu) then
            nu = nu + 1
         endif
       else
         nu = 1
      endif
      ordfft = nu
      return
      end
