/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
 * pipchk: Check the status of an IKP socket
 *
 * pipchk(pipe, status)
 *
 * int *pipe: An IKP socket number
 * int *status: Status of that pipe
 *              -1 unconnected
 *               0 OK
 *               1 connected to ground
 *
 * Return value is number of OK pipes, to match return value of pipcnt.
 * (Since this program only looks at one pipe, it's either 0 or 1!)
 *
 *                                               Joe Dellinger
 *                                               Oct 10 1994
 *
 * Hacked from "pipcnt" by Joe Wade
 */

#include <stdio.h>
#include <localsys.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ut_defs.h>

int
F_PIPCHK (pipe, status)
     int *pipe;
     int *status;
{
ino_t null_inode;
struct stat buf;
int pipe_count;

    pipe_count = 0;

/* get the inode number for /dev/null for comparison purposes */

    if (stat ("/dev/null", &buf) != 0)
      {
	  fprintf (stderr, "pipchk: unable to determine inode number of /dev/null\n");
	  exit (1);
      }
    else
      {
	  null_inode = buf.st_ino;
      }

    if (fstat (*pipe, &buf) == 0)
      {
	  if (buf.st_ino != null_inode)
	    {
		*status = 0;
		pipe_count++;
	    }
	  else
	    {
		*status = 1;
	    }
      }
    else
      {
	  *status = -1;
      }

    return pipe_count;
}
