C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PRMMLT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      PRMMLT  (NT,NTNEW,M2,M3,M5,LUOUT)                               *
C  ARGUMENTS:                                                          *
C      NT      INTEGER  ??IOU* -                                       *
C      NTNEW   INTEGER  ??IOU* -                                       *
C      M2      INTEGER  ??IOU* -                                       *
C      M3      INTEGER  ??IOU* -                                       *
C      M5      INTEGER  ??IOU* -                                       *
C      LUOUT   INTEGER  ??IOU* -                                       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      POWERP -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LUOUT  ( OUTPUT SEQUENTIAL ) -                                  *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE PRMMLT(NT,NTNEW , M2    , M3    , M5    , luout   )
C
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C_______________________________________________________________________
C     FIND THE MULTIPLE OF A PRIME NUMBER THAT IS CLOSEST TO NT FROM
C     ABOVE
C_______________________________________________________________________
C_______________________________________________________________________
C     FIND POWERS OF PRIME NUMBERS.
C_______________________________________________________________________
      CALL POWERP( NT, NT2, K2, 2)
      CALL POWERP( NT, NT3, K3, 3)
      CALL POWERP( NT, NT5, K5, 5)
C
C
      NTNEW = NT2
      M2    = 1
      M3    = 0
      M5    = 0
C
      DO 30 I=1,K2
         DO 20 J=0,K3
            DO 10 K=0,K5
               NTEST=(2**I)*(3**J)*(5**K)
               IF(NTEST .GE. NT .AND. NTEST .LE. NTNEW) THEN
                  NTNEW=NTEST
                  M2=I
                  M5=J
                  M5=K
               ENDIF
10          CONTINUE
20       CONTINUE
30    CONTINUE
C
      WRITE(luout,*) ' INPUT LENGTH  = ',NT
      WRITE(luout,*) ' M2,2**M2      = ',M2,2**M2
      WRITE(luout,*) ' M3,3**M3      = ',M3,3**M3
      WRITE(luout,*) ' M5,5**M5      = ',M5,5**M5
      WRITE(luout,*) ' OUTPUT LENGTH = ',NTNEW
C
      RETURN
C
      END
