/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/* This subroutine has the responsibility of getting
   values out of line headers and trace headers based 
   on a specified set of keywords (see save.h in ~usp/include/)

   I have built this shotgun version of code based on 
   previous fortran and c versions designed by Bob
   Herrmann. It should handle calls from fortran and c
   on both the Cray-2 system at MSC and the local Sun
   network.

   I added a return status to the code which can 
   be checked to see if the requested key was found. Even
   if this is ignored by the calling program, a message is
   written to stderr.

   Calling sequences:

   fortran:
   #include <f77/localsys.h>
   integer linhed(*),nsamp,recnum,status
   .
   .
   status = savew(linhed, 'NumSmp', nsamp, LINHED)
   call saver(linhed, 'RecNum', recnum, TRCHED)
   .
   .
  

   c:
   #include <localsys.h>
   int line_header[],nsamp,recnum;
   .
   .
   if(!savew(line_header, "NoSmp", nsamp, LINEHEADER))
     fprintf(stderr,"Couldn't find the keyword\n");
   saver(line_header, "RecNum", &recnum, LINEHEADER);
   .
   .

   where savew writes info and saver reads it

						- Joe M. Wade 9/20/89
*/
                           
/*
	I have added the code to handle new keywords which have
	been installed for VANL analysis headers. See save.h for
	a description of the new keywords.
						- Joe M. Wade 03/12/90
*/
/*
	changed long declarations to int; these are NOT the same!
	Note that many of the comments and the defined SAVE_LONG_DEF
        actually refer to int variables.
						- joe m. wade 5/26/95
*/

#include <stdio.h>
#include <sys/types.h>
#include <localsys.h>
#include <save.h>

#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

int	strncmp();
short	FORTRAN = 0;

void saverl(),saverr(),savers(),saverc();
void savewl(),savewr(),savews(),savewc();

#ifndef CRAYSYSTEM
int F_SAVELU(keystr,format,index,length,lintrc,length_of_keystr)
char *keystr;
unsigned length_of_keystr;
#else
int F_SAVELU(keystr,format,index,length,lintrc)
_fcd keystr;
#endif
int	*lintrc;
int	*format,*index,*length;
{
	int status;
/*	char c_keystr[7]; */
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));
	strncpy(c_keystr,keystr, length_of_keystr);
        c_keystr[length_of_keystr] = '\0';

	status = C_SAVELU(c_keystr,format,index,length,*lintrc);
	free(c_keystr);
	(*index)++;
	return(status);
}
int C_SAVELU(str,format,index,length,line_trace)
char *str;
int *format,*index,*length;
int line_trace;
{
	struct hdr *hd;

	if(line_trace == LINEHEADER)
		hd = lhdr;
	else if(line_trace == TRACEHEADER)
		hd = thdr;
	else if(line_trace == VANLHEADER)
		hd = vnlhdr;
	else if(line_trace == VSPNHEADER)
		hd = vspn_hdr;
	else if(line_trace == SEGYLINEHEADER)
		hd = segy_lhdr;
	else if(line_trace == SEGYTRACEHEADER)
		hd = segy_thdr;
	else
		{
		fprintf(stderr,"Error save: invalid header flag %d\n",
				line_trace);
		return((int) 0);
		}

	for(; hd->str != (char *)0;hd++){
		if(strncmp(str,hd->str,strlen(hd->str)) == 0){
			*format = hd->ind;
			*index = hd->pos;
			*length = hd->length;
			return((int) 1);
			}
		}

	fprintf(stderr,"Warning save: could not find key %s in ",str);
	switch (line_trace) {
	  case (LINEHEADER):
	    fprintf(stderr,"USP line header\n");
	    break;
	  case (TRACEHEADER):
	    fprintf(stderr,"USP line header\n");
	    break;
	  case (VANLHEADER):
	    fprintf(stderr,"VANL header\n");
	    break;
	  case (VSPNHEADER):
	    fprintf(stderr,"VSPN header\n");
	    break;
	  case (SEGYLINEHEADER):
	    fprintf(stderr,"SEGY line header\n");
	    break;
	  case (SEGYTRACEHEADER):
	    fprintf(stderr,"SEGY line header\n");
	    break;
	  }
	abort();

	return((int) 0);
}

#ifndef CRAYSYSTEM
int F_SAVER(itr,keystr,ival,lintrc,length_of_keystr)
char *keystr;
unsigned length_of_keystr;
#else
int F_SAVER(itr,keystr,ival,lintrc)
_fcd keystr;
#endif

int	itr[];
caddr_t	ival;
int	*lintrc;
{
	int status;
/*	char c_keystr[7]; */
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));
	strncpy(c_keystr,keystr, length_of_keystr);
        c_keystr[length_of_keystr] = '\0';

        FORTRAN = 1;
	status = savr(itr,c_keystr,ival,*lintrc,0); 
	free(c_keystr);
	return(status);
}

#ifndef CRAYSYSTEM
int F_SAVEW(itr,keystr,ival,lintrc,length_of_keystr)
char *keystr;
unsigned length_of_keystr;
#else
int F_SAVEW(itr,keystr,ival,lintrc)
_fcd keystr;
#endif

int	itr[];
caddr_t	ival;
int	*lintrc;
{
	int status;
/*	char c_keystr[7]; */
	char *c_keystr;

#ifdef CRAYSYSTEM
	unsigned length_of_keystr = _fcdlen(keystr);
#endif
	c_keystr = (char *) malloc((length_of_keystr+1)*sizeof(char));
	strncpy(c_keystr,keystr, length_of_keystr);
        c_keystr[length_of_keystr] = '\0';

        FORTRAN = 1;
	status = savr(itr,c_keystr,ival,*lintrc,1);
	free(c_keystr);
	return(status);
}

int F_SAVER2(itr,format,index,length,ival,lintrc)
int itr[];
int *format,*index,*length,*lintrc;
caddr_t ival;
{
	FORTRAN = 1;
	return(savr2(itr,*format,*index-1,*length,ival,*lintrc,0));
}

int F_SAVEW2(itr,format,index,length,ival,lintrc)
int itr[];
int *format,*index,*length,*lintrc;
caddr_t ival;
{
	FORTRAN = 1;
	return(savr2(itr,*format,*index-1,*length,ival,*lintrc,1));
}

int C_SAVER2(itr,format,index,length,val,lintrc)
int itr[];
int format,index,length,lintrc;
caddr_t val;
{
	FORTRAN = 0;
	return(savr2(itr,format,index,length,val,lintrc,0));
}

int C_SAVEW2(itr,format,index,length,val,lintrc)
int itr[];
int format,index,length,lintrc;
int val;
{
	FORTRAN = 0;
	return(savr2(itr,format,index,length,&val,lintrc,1));
}

int C_SAVER(itr,str,val,line_trace)
int	itr[];
char	*str;
caddr_t	val;
int	line_trace;
{
        FORTRAN = 0;
	return(savr(itr,str,val,line_trace,0));
}

int C_SAVEW(itr,str,val,line_trace)
int	itr[];
char	*str;
int	val;
int	line_trace;
{
        FORTRAN = 0;
	return(savr(itr,str,&val,line_trace,1));
}

int savr(itr,str,val,line_trace,irdwr)
int	itr[];
char	*str;
caddr_t	val;
int	line_trace;
int	irdwr;
{
	struct hdr *hd;
	char *temp_str;

	if(line_trace == LINEHEADER)
		hd = lhdr;
	else if(line_trace == TRACEHEADER)
		hd = thdr;
	else if(line_trace == VANLHEADER)
		hd = vnlhdr;
	else if(line_trace == VSPNHEADER)
		hd = vspn_hdr;
	else if(line_trace == SEGYLINEHEADER)
		hd = segy_lhdr;
	else if(line_trace == SEGYTRACEHEADER)
		hd = segy_thdr;
	else
		{
		fprintf(stderr,"Error save: invalid header flag %d\n",
				line_trace);
		return((int) 0);
		}

	for(; hd->str != (char *)0;hd++){
		if(strncmp(str,hd->str,strlen(hd->str)) == 0){
			if (irdwr == READHEADER) {
				switch(hd->ind){
				  case SAVE_CHAR_DEF:
					saverc(itr,val,hd->pos,hd->length);
					break;
				  case SAVE_SHORT_DEF:
					savers(itr,val,hd->pos,hd->length);
					break;
				  case SAVE_LONG_DEF:
					saverl(itr,val,hd->pos,hd->length);
					break;
				  case SAVE_FLOAT_DEF:
					saverr(itr,val,hd->pos,hd->length);
					break;
				  case SAVE_FKFLT_DEF:
/*
 - switched to using get_indexed_hw_val for flexibility - joe m. wade 3/7/2001
*/
/* switched back - 5/14/01 - prototyping errors on SGI */
					C_GETFP2(itr,hd->ind,hd->pos,
						hd->length,val,line_trace);
/*
					get_indexed_hw_val(itr,hd->ind,hd->pos,
						hd->length,line_trace,val);
*/
					break;
				  }
				}
			else if (irdwr == WRITEHEADER) {
				switch(hd->ind){
				  case SAVE_CHAR_DEF:
					savewc(itr,val,hd->pos,hd->length);
					break;
				  case SAVE_SHORT_DEF:
					savews(itr,(int *)val,hd->pos,hd->length);
					break;
				  case SAVE_LONG_DEF:
					savewl(itr,(int *)val,hd->pos,hd->length);
					break;
				  case SAVE_FLOAT_DEF:
					savewr(itr,(float *)val,hd->pos,hd->length);
					break;
				  case SAVE_FKFLT_DEF:
/*
 - switched to using put_indexed_hw_val for flexibility - joe m. wade 3/7/2001
*/
/* switched back - 5/14/01 - prototyping errors on SGI */
					C_PUTFP2(itr,hd->ind,hd->pos,
						hd->length,*(float *)val,line_trace);
/*
					put_indexed_hw_val(itr,hd->ind,hd->pos,
					  hd->length,line_trace,*(float *)val);
*/
					break;
				  }
				}
		return((int) 1);
		}
	}

	fprintf(stderr,"Warning save: could not find key %s in ",str);
	switch (line_trace) {
	  case (LINEHEADER):
	    fprintf(stderr,"USP line header\n");
	    break;
	  case (TRACEHEADER):
	    fprintf(stderr,"USP line header\n");
	    break;
	  case (VANLHEADER):
	    fprintf(stderr,"VANL header\n");
	    break;
	  case (VSPNHEADER):
	    fprintf(stderr,"VSPN header\n");
	    break;
	  case (SEGYLINEHEADER):
	    fprintf(stderr,"SEGY line header\n");
	    break;
	  case (SEGYTRACEHEADER):
	    fprintf(stderr,"SEGY line header\n");
	    break;
	  }
	abort();

	return((int) 0);
}

int savr2(itr,format,index,length,val,line_trace,irdwr)
int	itr[];
int	format,index,length;
caddr_t	val;
int	line_trace;
int	irdwr;
{
	struct hdr *hd;
	char *temp_str;

	if(line_trace == LINEHEADER)
		hd = lhdr;
	else if(line_trace == TRACEHEADER)
		hd = thdr;
	else if(line_trace == VANLHEADER)
		hd = vnlhdr;
	else if(line_trace == VSPNHEADER)
		hd = vspn_hdr;
	else if(line_trace == SEGYLINEHEADER)
		hd = segy_lhdr;
	else if(line_trace == SEGYTRACEHEADER)
		hd = segy_thdr;
	else
		{
		fprintf(stderr,"Error save: invalid header flag %d\n",
				line_trace);
		return((int) 0);
		}

	if (index < 0) {
		fprintf(stderr,"Error save: negative index value %d\n",index);
		return((int) 0);
		}

	if (length < 1) {
		fprintf(stderr,"Error save: non-positive length value %d\n",
			length);
		return((int) 0);
		}

	if (irdwr == READHEADER) {
		switch(format){
		  case SAVE_CHAR_DEF:
			saverc(itr,val,index,length);
			break;
		  case SAVE_SHORT_DEF:
			savers(itr,val,index,length);
			break;
		  case SAVE_LONG_DEF:
			saverl(itr,val,index,length);
			break;
		  case SAVE_FLOAT_DEF:
			saverr(itr,val,index,length);
			break;
		  case SAVE_FKFLT_DEF:
/*
 - switched to using put_indexed_hw_val for flexibility - joe m. wade 3/7/2001
*/
/* switched back - 5/14/01 - prototyping errors on SGI */
			C_GETFP2(itr,format,index,length,val,line_trace);
/*
					get_indexed_hw_val(itr,format,index,
						length,line_trace,val);
*/
			break;
		  default: 
			fprintf(stderr,"Error save: invalid format flag %d\n",
				format);
			return((int) 0);
		  }
		}
	else if (irdwr == WRITEHEADER) {
		switch(format){
		  case SAVE_CHAR_DEF:
			savewc(itr,val,index,length);
			break;
		  case SAVE_SHORT_DEF:
			savews(itr,(int *)val,index,length);
			break;
		  case SAVE_LONG_DEF:
			savewl(itr,(int *)val,index,length);
			break;
		  case SAVE_FLOAT_DEF:
			savewr(itr,(float *)val,index,length);
			break;
		  case SAVE_FKFLT_DEF:
/*
 - switched to using put_indexed_hw_val for flexibility - joe m. wade 3/7/2001
*/
/* switched back - 5/14/01 - prototyping errors on SGI */
			C_PUTFP2(itr,format,index,length,*(float *)val,line_trace);
/*
			put_indexed_hw_val(itr,format,index,length,
					  line_trace,*(float *)val);
*/
			break;
		  default: 
			fprintf(stderr,"Error save: invalid format flag %d\n",
				format);
			return((int) 0);
		  }
		}
	return((int) 1);
}
void saverl(itr,val,pos,length) /* read long int from position pos return as val */
/* val = itr[pos] */
int	itr[];
int	*val,
	pos,
	length;
{
	int i;
	for (i=0; i<length; i++) {
	  *(val+i) = itr[pos+i];
	  }
}

void saverr(itr,val,pos,length)
/* save real in line header itr[pos] = val */
float	itr[];
float	*val;
int	pos,
	length;
{
	int i;
	for (i=0; i<length; i++) {
	  *(val+i) = itr[pos+i] ;
	  }
}

void savers(itr,val,pos,length)
/* val = itr[pos] */
short	itr[];
int	*val,
	pos,
	length;
{
	int i;
	for (i=0; i<length; i++) {
	  *(val+i) = (int)itr[pos+i];
	  }
}

void saverc(itr,val,pos,length)
char	*itr;
char	*val;
int	pos,
	length;
{

#ifndef CRAYSYSTEM
	strncpy(val, (char *)(itr+pos), length);
#else
	strncpy(_fcdtocp(val), (char *)(itr+pos), length);
#endif
}

void savewl(itr,val,pos,length)
/* save long integer in line header itr[pos] = val */
int	itr[];
int	*val,
	pos,
	length;
{
	int i;
	for (i=0;i<length;i++) {
	  itr[pos+i] = *(val+i);
	  }
}

void savewr(itr,val,pos,length)
/* save real in line header itr[pos] = val */
float	itr[];
float	*val;
int	pos,
	length;
{
	int i;
	for (i=0;i<length;i++) {
	  itr[pos+i] = *(val+i);
	  }
}

void savews(itr,val,pos,length)
/* save short integer in line header itr[pos] = (short)val */
short	itr[];
int	*val,
	pos,
	length;
{
	int i;
	for (i=0;i<length;i++) {
	  itr[pos+i] = (short)*(val+i);
	  }
}

void savewc(itr,val,pos,length)
char	*itr;
char	*val;
int	pos;
int	length;
{
#ifndef CRAYSYSTEM
	if (FORTRAN)
	  strncpy((char *)(itr+pos), val, length);
	else
	  strncpy((char *)(itr+pos), (char *)*(int *)val, length);
#else
	if (FORTRAN)
	  strncpy((char *)(itr+pos), _fcdtocp(val), length);
	else
	  strncpy((char *)(itr+pos), (char *)*(int *)val, length);
#endif
}
