C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SEISFL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SEISFLUSH  (LU,NTAP,ITR2,LBYTES,MODE)                           *
C  ARGUMENTS:                                                          *
C      LU      INTEGER    ??IOU*      -                                *
C      NTAP    CHAR*(*)   ??IOU*      -                                *
C      ITR2    INTEGER*2  ??IOU*  (*) -                                *
C      LBYTES  INTEGER    ??IOU*      -                                *
C      MODE    CHAR       ??IOU*      -                                *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      LBCLOS -                                                        *
C      LBOPEN -                                                        *
C      RTAPE  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine SeisFlush(lu,ntap,itr2,lbytes,mode)
 
#include <f77/iounit.h>
 
c -----
c
c     routine to assure that the pipe is flushed.  The dataset
c     is closed then opened with the pointer positioned at the
c     onset of trace 1.  The routine will return the LineHeader
c     in itr2 and the length of the line header in bytes in
c     lbytes
c
c -----
 
      integer*2  itr2(*)
      integer    lu, lbytes
 
      character ntap*(*),mode
 
      call lbclos(lu)
 
      call lbopen(lu,ntap,mode)
 
      call rtape  ( lu, itr2, lbytes)
 
      if(lbytes .eq. 0) then
 
         write(LER,*)'SeisFlush: no header read from unit ',lu
         write(LER,*)'FATAL'
         stop
 
      endif
 
      return
      end
