C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SHAPE                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SHAPE  (LB,B,LD,D,LA,A,LC,C,ASE,PREW,SPACE)                     *
C  ARGUMENTS:                                                          *
C      LB      INTEGER  ??IOU*      -                                  *
C      B       REAL     ??IOU*  (*) -                                  *
C      LD      INTEGER  ??IOU*      -                                  *
C      D       REAL     ??IOU*  (*) -                                  *
C      LA      INTEGER  ??IOU*      -                                  *
C      A       REAL     ??IOU*  (*) -                                  *
C      LC      INTEGER  ??IOU*      -                                  *
C      C       REAL     ??IOU*  (*) -                                  *
C      ASE     REAL     ??IOU*      -                                  *
C      PREW    REAL     ??IOU*      -                                  *
C      SPACE   REAL     ??IOU*  (*) -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 96/02/08  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 96/02/08  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CROSS  -                                                        *
C      EUREKB -                                                        *
C      FOLD   -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE SHAPE(LB,B,LD,D,LA,A,LC,C,ASE,PREW,SPACE)
 
#include <f77/iounit.h>
C
C     THIS IS A CONFIDENTIAL PAN AMERICAN PETROLEUM CORPORATION SUBROUTINE
      DIMENSION B(*),D(*)
      DIMENSION A(*),C(*)
      DIMENSION SPACE(*)
 
C     THIS SUBROUTINE FINDS THE LEAST-SQUARES WIENER SHAPING FILTER
C     BY SETTING UP AND SOLVING THE NORMAL EQUATIONS.
C
C
C     SUBROUTINE INPUTS ARE
C         LB = LENGTH OF B
C         B  = INPUT WAVELET
C         LD = LENGTH OF D
C         D  = DESIRED OUTPUT WAVELET
C         LA = LENGTH OF A
C         PREW = PREWHITENING FACTOR, 1.0= 100 PERCENT
C
C     SUBROUTINE OUTPUTS ARE
C         A  = FILTER
C         LC = LENGTH OF C
C         C  = ACTUAL OUTPUT WAVELET
C         ASE= AVERAGE SQUARED ERROR
C                            2
C             SUM (D(I)-C(I))        SUM(A(I)*G(I))
C            =---------------- =1 -  --------------
C                       2                      2
C              SUM(D(I))              SUM(D(I))
C
C     WHERE (D(I))**2=ZEROTH LAG OF AUTOPRODUCT OF D(I)=POWER OF D(I)
C
C         SPACE = AUTOCORRELATION OF B = R           (IN FIRST LA CELLS)
C               = CROSS CORRELATION OF D WITH B = G  (IN NEXT LA CELLS)
C         SPACE NEEDS 4*LA CELLS
C     MAY BE EQUIVALENCE (C,D)
 
      CALL CROSS(LB,B,LB,B,LA,SPACE)
      SPACE(1)=SPACE(1) + PREW*SPACE(1)
      CALL CROSS(LD,D,LB,B,LA,sPACE(LA+1))
      CALL EUREKb(LA,SPACE,SPACE(LA+1),A,SPACE(2*LA+1))
c     call dotpr (d,1,d,1,dd,ld)
      dd = 0.
      do  1  i = 1, ld
             dd = dd + d(i)*d(i)
1     continue
c     CALL DOT(LD,D,D,DD)
c     call dotpr (a,1,space(la+1),1,ag,la)
      ag = 0.
      do  2  i = 1, la
             ag = ag + a(i) * space(i+la)
2     continue
c     CALL DOT(LA,A,SPACE(LA+1),AG)
      ASE=(DD-AG)/DD
      CALL FOLD(LA,A,LB,B,LC,C)
 
      RETURN
      END
