/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
*   Completely rehacked code to C language to use the save.h
*   include file directly without having to build a new fortran
*   include file from it. Speed is also gained because we can
*   make calls directly to saver2, which does not have to do
*   a search on the keyword. Modifications to save.h should
*   be immediately reflected in output generated by this 
*   subroutine upon re-compilation.
*
*					Joe M. Wade  10-8-92
*
c   Changed calls to internal routines in saver to calls to saver
c   itself. I have rewritten saver in c-language and didn't want 
c   to declare all those entry points. I also changed the handling
c   of character data in saver. It is no longer passed back in the
c   low order byte of a word. I have changed it to expect a 
c   character variable or else it gets put in the high order byte
c   of whatever variable you give it. See saver.c for more 
c   details.
c                                       Joe M. Wade  10-11-89
c
c   I also put checks in to skip any entries in save.h which have
c   the same position index as the previous entry. This is because
c   I changed the indexes and duplicates exist which point to the
c   same header values. This also means that multi-character entries
c   are printed out in their entirety instead of one character at 
c   a time
c					Joe M. Wade  10-27-89
c
c   Added code to print special floating point entries which occupy
c   two adjacent half-words and are treated as integer in the Cray 
c   translation schemes. Also bypass printing of entries with a 
c   zero-length mnemonic.
c					Joe M. Wade  4-14-95
c
c   Changed subroutine arguments for direct entry from C. Fortan 
c   entry point was added for backward compatibility.
c
c   Added capability for printing SEGY header information.
c   Also modified code to find maximum key string length and format
c   output lines accordingly.
c					Joe M. Wade  3-10-99
*/
#include <localsys.h>
#include <stdio.h>
#include <ut_defs.h>

#define MAX(a,b) (a>b ? a : b);

void F_SHWHED(itr,lintrc,mbs)
int itr[];
int *lintrc;
int *mbs;
{
	void C_SHWHED();
	C_SHWHED(itr,*lintrc,*mbs);
}
void C_SHWHED(itr,lintrc,mbs)
int itr[];
int lintrc;
int mbs;		/* =1 - use MBS mneumonics rather than USP */
{
	struct hdr *hd;
	struct hdr *hdprev;
	struct hdr *hdnull = NULL;

	static char *mbs_name[] = { "Dy1000", "RefVel", "AnglSt", "AngInc",
				"Dx1000", "Dz1000",  "MinVel", "MaxVel" };
	int mbs_count = 0;
	int maxkeylength = 0;
	struct hdr **mbs_hd;
	int ix,ival;
	float fval;
        char chval;
#include <save.h>
        char blank = ' ';
	char zee = 'z';
	int line_count;

	char *format1 = "%*s         %c%4d( C) ";
	char *format2 = "%*s%10d%4d(I2) ";
	char *format3 = "%*s%10d%4d(I4) ";
	char *format4 = "%*s%10.3g%4d(R4) ";

	if (lintrc == LINEHEADER) {
	  hd = lhdr;
	  fprintf(stdout,"LINEHEADER\n");
	  }
	else if (lintrc == TRACEHEADER) {
	  hd = thdr;
	  fprintf(stdout,"TRACEHEADER\n");
	  }
	else if (lintrc == SEGYLINEHEADER) {
	  hd = segy_lhdr;
	  fprintf(stdout,"LINEHEADER\n");
	  }
	else if (lintrc == SEGYTRACEHEADER) {
	  hd = segy_thdr;
	  fprintf(stdout,"TRACEHEADER\n");
	  }

	line_count = 0;
	hdprev = hd;

	if (mbs != 0) {
	  mbs_count = sizeof(mbs_name)/sizeof(char *);
	  mbs_hd = (struct hdr **) malloc(mbs_count*sizeof(struct hdr *));
	  if (mbs_hd == NULL) {
	    fprintf(stderr,"Memory allocation failure in shwhed\n");
	    exit(1);
	    }

	  for (ix=0; ix<mbs_count; ix++) {
	    hd = hdprev;
	    *(mbs_hd+ix) = hdnull;
	    while( hd->pos >= 0 ) {
	      if (strcmp(hd->str,mbs_name[ix]) == 0) {
		*(mbs_hd+ix) = hd;
		break;
		}
	      hd++;
	      }
	     }
	   }

	hd = hdprev;
	  
	while( hd->pos >= 0 ) {
/*
	  if (strlen(hd->str) > maxkeylength) maxkeylength = strlen(hd->str);
*/
	  maxkeylength = MAX(maxkeylength,strlen(hd->str));
	  hd++;
	  }

	hd = hdprev;
	hdprev = hdnull;
	while( hd->pos >= 0 ) {
#ifdef DEBUG
fprintf(stdout,"index=%d length=%d format=%d\n",hd->pos,hd->length,hd->ind);
#endif
/*
** - this skips duplicate pointers to the same item, only first is printed
*/
	  if (mbs != 0) {
	    for (ix=0; ix<mbs_count; ix++) {
	      if (*(mbs_hd+ix) != hdnull) {
		if (*(mbs_hd+ix) == hd) {
		  hdprev = hdnull;
		  break;
		  }
		else if ((((*(mbs_hd+ix))->ind == hd->ind) &&
		    ((*(mbs_hd+ix))->pos == hd->pos) &&
		    ((*(mbs_hd+ix))->length == hd->length))) {
		  hdprev = hd;
		  break;
		  }
		}
	      }
	    }

	  if ((hdprev == hdnull) ||
	    (!((hdprev->ind == hd->ind) && (hdprev->pos == hd->pos)
		&& (hdprev->length == hd->length)))) {
/*
** - we still print multiple entry items by individual entries
*/
	    if (hd->length == 1) {
	      switch( hd->ind ) {
		case (SAVE_DUMMY_DEF):
		    break;
		case (SAVE_CHAR_DEF):
		    C_SAVER2(itr,hd->ind,hd->pos,hd->length,&chval,lintrc);
 		    if ((strncmp(&chval,&blank,1) < 0) ||
     			(strncmp(&chval,&zee,1) > 0)) chval=blank;
		    line_count +=
			fprintf(stdout,format1,maxkeylength,hd->str,chval,hd->pos+1);
		    break;
		case (SAVE_SHORT_DEF):
		    C_SAVER2(itr,hd->ind,hd->pos,hd->length,&ival,lintrc);
		    line_count +=
			fprintf(stdout,format2,maxkeylength,hd->str,ival,hd->pos+1);
		    break;
		case (SAVE_LONG_DEF):
		    C_SAVER2(itr,hd->ind,hd->pos,hd->length,&ival,lintrc);
		    line_count +=
			fprintf(stdout,format3,maxkeylength,hd->str,ival,hd->pos+1);
		    break;
		case (SAVE_FLOAT_DEF):
		    C_SAVER2(itr,hd->ind,hd->pos,hd->length,&fval,lintrc);
		    line_count +=
			fprintf(stdout,format4,maxkeylength,hd->str,fval,hd->pos+1);
		    break;
		case (SAVE_FKFLT_DEF):
		    C_GETFP2(itr,hd->ind,hd->pos,hd->length,&fval,lintrc);
		    line_count +=
			fprintf(stdout,format4,maxkeylength,hd->str,fval,hd->pos+1);
		    break;
	    	}
	      }
/* this kludge is to match the old fortran printout which was 80 cols */
	    if (line_count > 80-19-maxkeylength) {
		fprintf(stdout,"%*c",80-line_count,blank);
		fprintf(stdout,"\n");
		line_count = 0;
		}
	    }
	  hdprev = hd;
	  hd++;
	  }

	if (line_count != 0) fprintf(stdout,"\n");
}
