/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*	Partial Fortran wrapper for C sscanf function		*/
/*								*/
/*	int_ret = sscanf ( line, format, arg1, arg2,..., argn )	*/
/*		int_ret = integer returned flag			*/
/*			>0 - # of args read			*/
/*			<0 - arg # producing error		*/
/*		line	= char string of line to be unformatted	*/
/*		format	= char string of format	 "%d %f %s %nc"	*/
/*			%d  - integer value			*/
/*			%f  - float value			*/
/*			%s  - string(length checked, not cleared*/
/*			%nc - n characters (")			*/
/*								*/
/*	sscanf is a partial fortran wrapper.  It does not allow	*/
/*	for other characters in line, assuming that each arg	*/
/*	is separated by white space (blank or tab), and it does */
/*	not allow for long values (%ld or %lf) or for maximum	*/
/*	widths in the format (%5f).  It does however attempt to	*/
/*	check for string lengths and valid formats to avoid	*/
/*	hang and overwrite problems inherent in sscanf.		*/
/*								*/
/*	Author:	Kathleen Mathieu				*/
/*		Minnesota Supercomputer Center, Inc.		*/
/****************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <localsys.h>
#include <ut_defs.h>

#include <stdarg.h>

#ifdef CRAYSYSTEM
#include <fortran.h>
#endif

va_list aplen;

#ifdef CRAYSYSTEM
int F_SSCANF ( str, fmt, ... )
_fcd   str;
_fcd   fmt;
#else
int F_SSCANF ( char * line, ... )
#endif


/* arg1, .... argn */
{
	int narg;
	int arg_typ;
	int ier=0;
	int i;
	int end_chr;
	int str_chr;
	int str_len;
	int fmt_len;
	int fmt_ptr;
	int s_ptr;
	int s_len;
	va_list ap;
	char * format;

/* get input string lengths */

#ifdef CRAYSYSTEM
	char * line;

	str_len = _fcdlen(str);
	line = (char *)_fcdtocp(str);

	fmt_len = _fcdlen(fmt);
	format = (char *)_fcdtocp(fmt);
	va_start ( ap, fmt );
	va_start ( aplen, fmt );
#else
	va_start ( ap, line );
	va_start ( aplen, line );
	format = (char *) va_arg( ap, char * );
	va_arg( aplen, char * );
	fmt_len = strlen(format);
	narg = 0;
	fmt_ptr = 0;
	while ( fmt_ptr < fmt_len ) {
	   if ( format[fmt_ptr++] == '%' ) {
	      narg++;
	      if ( format[fmt_ptr] == 'f' ) {
		va_arg ( aplen, float * );
	      }
	      if ( format[fmt_ptr] == 'd' ) {
		va_arg ( aplen, int * );
	      }
	      if ( format[fmt_ptr] == 's' ) {
		va_arg ( aplen, char * );
	      }
              while ( format[fmt_ptr] >= '0' && format[fmt_ptr] <= '9' ) {
		if ( fmt_ptr >= fmt_len ) break;
		fmt_ptr++ ;
		}
	      if ( format[fmt_ptr] == 'c' ) {
		va_arg ( aplen, char * );
	      }
	   }
	}
	/* skip line and format string lengths */
	str_len = va_arg ( aplen, int );
/*
   these were previously commented out - now I know why -
   if the string has leading blanks, this check fails - joe m wade 8/28/01
*/
/*
	if ( fmt_len != va_arg (aplen,int) ) {
	   fprintf ( stderr, "SSCANF error : fmt_len incorrect: %d\n",fmt_len );
	}
	if ( narg > 50 ) {
	   fprintf ( stderr, "SSCANF error : too many args : %d \n", narg );
	}
*/

#endif

	fmt_ptr = 0;

	end_chr = str_len-1;
	str_chr = 0;

/* loop over each %f in format, unformatting appropriately */

	i = 0;
	narg = 0;
	while ( fmt_ptr < fmt_len ) {
	   while ( format[fmt_ptr] != '%' && fmt_ptr < fmt_len ) {
	      fmt_ptr++;
	   }
	   if ( fmt_ptr >= fmt_len ) break;
	   fmt_ptr++;

/*
	   dval = va_arg(ap, double);
*/
	   if ( format[fmt_ptr] == 's' ) {
/* %s - string format */
#ifdef CRAYSYSTEM
		ier = char_arg
		   ( line, &str_chr, &end_chr, va_arg(ap,_fcd), 0 );
#else
		ier = char_arg
		   ( line, &str_chr, &end_chr, va_arg(ap, char *), 0 );
#endif
	   } else if ( format[fmt_ptr] == 'f' ) {
/* %f - real format */
		ier = real_arg
		   ( line, &str_chr, &end_chr, va_arg(ap, float *) );
	   } else if ( format[fmt_ptr] == 'd' ) {
/* %d - integer format */
		ier = int_arg
		   ( line, &str_chr, &end_chr, va_arg(ap, int *) );
	   } else {
	      s_ptr = fmt_ptr;
	      while ( s_ptr < fmt_len && ( format[s_ptr] == 'c' ||
		( format[s_ptr] >= '0' && format[s_ptr] <= '9' ) ) ) {
		if ( format[s_ptr] == 'c' ) {
		  s_len = atoi ( &format[fmt_ptr] );
		  fmt_ptr = s_ptr;
/* %nc - character format */
#ifdef CRAYSYSTEM
		  ier = char_arg
		   ( line, &str_chr, &end_chr, va_arg(ap,_fcd), s_len );
#else
		  ier = char_arg
		   ( line, &str_chr, &end_chr, va_arg(ap, char *), s_len );
#endif
		  break;
		}
		s_ptr++;
	      }
/*	      if ( format[fmt_ptr] != 'c' ) {
		fprintf ( stderr,
		  "SSCANF error : invalid format %d : %c\n",
		  i+1, format[fmt_ptr] );
		  ier = -(i+1);
		break;
	      }
*/	      
	   }
/* this was commented out for some reason and caused bad data to get
   by - I'm putting it back in. - joe m. wade 5/20/98 */

	   if ( ier < 0 ) {
	      fprintf ( stderr,
	     "SSCANF error : insufficient or invalid data format variable %d\n",
	     i+1 );
	     ier = -(i+1);
	     break;
	   }
   
	   i++;
	   narg++;
	}
	va_end ( ap );
#ifndef CRAYSYSTEM
	va_end ( aplen );
#endif

	if ( ier == 0 ) ier = narg;
	return(ier);
}

/* function to read characters */

int char_arg ( line, str_chr, end_chr, arg, maxlen )
char    line[];
int   * str_chr;
int   * end_chr;
#ifdef CRAYSYSTEM
_fcd    arg;
#else
char  * arg;
#endif
int     maxlen;
{
	int first;
	int last;
	int length;
	int arg_len;
	int i;

/* get length of string to hold output characters */

#ifdef CRAYSYSTEM
	arg_len = _fcdlen(arg);
#else
	arg_len = va_arg(aplen,int);
#endif

	length = get_str ( line, *str_chr, *end_chr, &first, &last );
	if ( maxlen > 0 ) {
	   length = maxlen;
	   last = first + length - 1;
	   if ( ( first + length ) > *end_chr ) {
	      last = *end_chr;
	      length = last - first + 1;
	   }
	}
	*str_chr = last+1;

	if ( length > arg_len ) length = arg_len;
#ifdef CRAYSYSTEM
	strncpy ( _fcdtocp(arg), &line[first], length );
#else
	strncpy ( arg, &line[first], length );
#endif
	return( 0 );
}

/* function to read real arg */

/* int real_arg ( char line[], int *str_chr, int *end_chr, float *arg ) */
int real_arg ( line, str_chr, end_chr, arg )
char line[];
int *str_chr;
int *end_chr;
float *arg;
{
	int first;
	int last;
	int length;
	int i;
	int dec=0;
	int exp=0;
	int sign=1;
	va_list ap;
	
/*
	va_start(ap, end_chr);
	arg = va_arg(ap, float  *);
*/
	length = get_str ( line, *str_chr, *end_chr, &first, &last );
	*str_chr = last+1;

	if ( length > 0 ) {
	   for ( i=first; i<=last; i++ ) {
	      if ( line[i] < '0' || line[i] > '9' ) {
		if ( ( line[i] == '+' || line[i] == '-' ) && sign == 1 )  {
		} else if ( line[i] == '.' && dec == 0 ) {
		   dec = 1;
		} else if ( ( line[i] == 'e' || line[i] == 'E' ) && exp == 0 ) {
		   dec = 1;
		   exp = -1;
		} else {
		   return ( -1 );
		}
	      }
	      sign = 0;
	      if ( exp == -1 ) {
		sign = 1;
		exp = 1;
	      }
	   }

	   *arg = atof ( &line[first] );
	   return ( 0 );
	} else {
/* error if at end of input line */
	   return ( -1 );
	}
}

/* function to read real arg */

int int_arg ( line, str_chr, end_chr, arg )
char    line[];
int   * str_chr;
int   * end_chr;
int   * arg;
{
	int first;
	int last;
	int length;
	int i;

	length = get_str ( line, *str_chr, *end_chr, &first, &last );
	*str_chr = last+1;

	if ( length > 0 ) {
	   for ( i=first; i<=last; i++ ) {
/* modified check to allow + and - signs          -  joe m. wade 5/20/98 */
	      if (( line[i] < '0' || line[i] > '9' ) && 
		( line[i] != '+' && line[i] != '-' )) return ( -1 );
	   }
	   *arg = atoi ( &line[first] );
	   return ( 0 );
	} else {
/* error if at end of input line */
	   return ( -1 );
	}
}

int get_str ( line, str_chr, end_chr, first, last )
char  line[];
int   str_chr;
int   end_chr;
int * first;
int * last;
{
	int  i=str_chr;

	while ( line[i] == ' ' || line[i] == '\t' || line[i] == '\n'
	    && i <= end_chr ) {
		i++;
	}
	*first = i;
	while ( line[i] != ' ' && line[i] != '\t' && line[i] != '\n'
	    && i <= end_chr ) {
		i++;
	}
	*last = i-1;

	return ( *last - *first + 1 );
}
