/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

#include <stdio.h>
#include <sys/time.h>

#include <localsys.h>
#include <ut_defs.h>

#define COMBINE(a,b) ((double)(a) + ((double)(b) / 1000000.))

static int first_time = 1;
static double offset;

void F_WALCLK(w)
double *w;
{
struct timeval tp;
struct timezone tzp;

if (first_time) {
   first_time = 0;
   gettimeofday(&tp, &tzp);
   offset = COMBINE(tp.tv_sec, tp.tv_usec);
}

if (gettimeofday(&tp, &tzp)) {
   printf("Error using timer (gettimeofday)...\n");
   *w = 0.0;
}
else {
   *w = COMBINE(tp.tv_sec, tp.tv_usec) - offset;
}
}

void xc_timstr_(v1,w1)
double *v1, *w1;
{
struct timeval tp;
struct timezone tzp;

if (first_time) {
   first_time = 0;
   gettimeofday(&tp, &tzp);
   offset = COMBINE(tp.tv_sec, tp.tv_usec);
}

if (gettimeofday(&tp, &tzp)) {
   printf("Error using timer (gettimeofday)...\n");
   *v1 = *w1 = 0.0;
}
else {
   *v1 = *w1 = COMBINE(tp.tv_sec, tp.tv_usec) - offset;
}
}

void xc_timend_(cpu,v1,v2,wal,w1,w2)
double *cpu, *v1, *v2;
double *wal, *w1, *w2;
{
struct timeval tp;   /* Time in seconds (tp.tv_sec) and msecs (tp.tv_usec) */
struct timezone tzp; /* Not used */

if (gettimeofday(&tp, &tzp)) {
   printf("Error using timer (gettimeofday)...\n");
   *cpu = *v2 = 0.0;
   *wal = *w2 = 0.0;
}
else {
   *v2 = *w2 = COMBINE(tp.tv_sec, tp.tv_usec) - offset;
   *cpu = *wal = *w2 - *w1;
}
}

void test_main()
{
int i;
double v1, v2, w1, w2, cpu, wal;

xc_timstr_(&v1, &w1);
printf("v1 = %lf, w1 = %lf\n", v1, w1);

for (i = 0; i < 4000000; i++);

xc_timend_(&cpu,&v1,&v2,&wal,&w1,&w2);
printf("v2 = %lf, w2 = %lf\n", v2, w2);
printf("Total cpu = %lf, wall = %lf\n", cpu, wal);
}
