C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine vsii(rs,re,indv,np,inters,intere,isp,is,ie)
c
c      Velocity Space Interpolating Index
c      finding velocity space interpolation index
c
c      rs,re: start and end data records
c      indv : 1D array to store velocity record index
c      np : Number of velocity pick segments
c      inters,intere: Space Interpolation Indices
c      isp  : =0, no interpolation is needed
c             inters=intere=indv
c             =record index, interpolation is needed, 
c             isp E [inters,intere]
c      is,ie: begining and ending pointers to the velocity index
c             for the space interpolation at isp trace
c             is isp(i) != 0         
c             EX: data trace = I, the available velocity traces
c                 are traces J1 and J2, respectively. The corresponding
c                 numbers of velocity picks are n1 and n2. Then V(is), V(is+1),
c                 ..., V(is+n1-1) will be the values for the velocity trace J1,
c                 and V(ie),V(ie+1),...,V(ie+n2-1) will be the values for
c                 the velocity trace J2. These values can be retrieved for
c                 use of space interpolation.
c
       integer rs,re,indv(1),isp(1),inters(1),intere(1),is(1),ie(1)
c
       irec=re-rs+1
c
c      rs=indv(1), re=indv(np), and re-rs+1=indv(1)-indv(np)+1
c
       if(rs .eq. indv(1) .AND.
     1    re .eq. indv(np) .AND.
     2    irec .eq. np) then
               write(*,*) 'No space interpolation is necessary'
               do 100 i=rs,re
                  isp(i)=0
                  inters(i) = i
                  intere(i) = i
                  is(i)=i
                  ie(i)=i
100            continue
               return
       endif
c
       call findind(indv,np,rs,i,j)
       if(i .eq. -1) then
          write(*,*) 'rs=',rs,' is less than ',indv(1)
          write(*,*) 'ONE Vel is used from rec#',rs,' to rec#',indv(1)
          do 110 k=rs,indv(1)
             isp(k)=0
             inters(k)=indv(1)
             intere(k)=indv(1)
                  is(k)=1
                  ie(k)=1
110       continue
       else if(i .gt. 0 .AND. i .eq. j) then
          write(*,*) 'rs=',rs,' =',indv(i)
          isp(rs)=0
          inters(rs)=indv(i)
          intere(rs)=indv(i)
                  is(rs)=i
                  ie(rs)=i
       else if(i .gt. 0 .AND. i .ne. j ) then
          write(*,*) 'rs =',rs,' is between ', indv(i),' and ',indv(j)
          isp(rs)=rs
          inters(rs)=indv(i)
          intere(rs)=indv(j)
                  is(rs)=i
                  ie(rs)=j
       else if(i .eq. 0) then
          write(*,*) 'rs=',rs,' > ',indv(np)
          write(*,*) 'WARING: only velocity will be used'
          do 120 k=rs,re
             isp(k)=0
             inters(k)=indv(np)
             intere(k)=indv(np)
                  is(k)=np
                  ie(k)=np
120       continue
       return
       endif
c
c      check re
c
       call findind(indv,np,re,i,j)
       if(i .eq. 0) then
          write(*,*) 're=',re,' > ',indv(np)
          write(*,*) 'ONE vel is used from rec#',indv(np),' to rec#', re
          do 130 k=indv(np),re
             isp(k)=0
             inters(k)=indv(np)
             intere(k)=indv(np)
                  is(k)=np
                  ie(k)=np
130       continue
       else if(i .gt. 0 .AND. i .eq. j) then
          write(*,*) 're=',re,' =',indv(i)
          isp(re)=0
          inters(re)=indv(i)
          intere(re)=indv(i)
                  is(k)=i
                  ie(k)=i
       else if(i .gt. 0 .AND. i .ne. j ) then
          write(*,*) 're =',re,' is between ', indv(i),' and ',indv(j)
          isp(re)=re
          inters(re)=indv(i)
          intere(re)=indv(j)
                  is(k)=i
                  ie(k)=j
       else if(i .eq. -1) then
          write(*,*) 're=',re,' < ',indv(1)
          write(*,*) 'WARING: only  ONE velocity will be used'
          do 140 k=rs,re
             isp(k)=0
             inters(k)=indv(1)
             intere(k)=indv(1)
                  is(k)=1
                  ie(k)=1
140       continue
          return
       endif
       ivs=rs
       if(ivs .lt. indv(1)) ivs=indv(1)
       ive=re
       if(ive .gt. indv(np)) ive=indv(np)
c       write(*,*) 'IVS=',ivs,' IVE=',ive
       write(*,148) rs,re
       write(*,149) indv(1),indv(np)
       if(ivs .NE. indv(1) .OR. ive .ne. indv(np)) 
     1         write(*,147) ivs,ive,indv(1),indv(np)
147    format(2x,'(',i4,',',i5,'), a subset of (vs,ve) = (',i4,
     2                        ',',i5,') is used in PSNMO')
148    format(2x,'Data record boundary  :  rs=',i4,' re=',i5)
149    format(2x,'Velocity pick boundary:  vs=',i4,' ve=',i5)
       do 150 k=ivs,ive
          call findind(indv,np,k,i,j)
          isp(k)=k
          if(i .eq. j) isp(k)=0
          inters(k)=indv(i)
          intere(k)=indv(j)
                  is(k)=i
                  ie(k)=j
150    continue
       return
       end


       subroutine chkascent(index,n,ibad)
       integer index(1)
       logical ibad
       ibad = .false.
       if(n .le. 1) return
       do 10 i=2,n
          if(index(i) .lt. index(i-1)) then
             ibad = .true.
             return
          endif
10     continue
       return
       end

       subroutine findind(ia,n,index,j,k)
c
c      find i in the array, ia
c      if index < ia(1), j=k=-1
c      if index > ia(1), j=k=0
c      if index = ia(m), j=k=m
c      if ia(ms) < index < ia(me), j=ms, k=me
c
       integer ia(1)
       logical found
       found = .false.
c
       if(index .lt. ia(1)) then
          j=-1
          k=-1
          go to 200
       else if(index .gt. ia(n)) then
          j=0
          k=0
          go to 200
       else if(index .eq. ia(1)) then
          j=1
          k=1
          found = .true.
          go to 200
       endif
       j=-1
       k=-1
       do 100 i=2,n
          if(index .eq. ia(i)) then
             j=i
             k=i
             found = .true.
             go to 200
          else if(index .gt. ia(i-1) .AND. index .lt. ia(i)) then
            j=i-1
            k=i
            found = .true.
            go to 200
          endif
100    continue
200    continue
c       if(found) then
c            write(*,*) 'index was found'
c            write(*,*) index,' belong to [',ia(j),',',ia(k),']'
c       endif
       return
       end
       
       subroutine tp2tps(tp,tps,g,n)
       dimension tp(1),tps(1)
       if(g .eq. 0.0) then
         write(*,*) 'Vs/Vp = 0.0, Not possible!'
         return
       endif
       if(g .eq. 1.0) then
          do 10 i=1,n
          tps(i)=tp(i)
10        continue
       else
          do 20 i=1,n
c          tps(i)=0.5*(1.0+g)*tp(i)/g
          tps(i)=tptps(tp(i),g)
20        continue
       endif
       return
       end


       function tptps(tp,g)
       real tp,g
       tptps=0.5*(1.0+g)*tp/g
       return 
       end

       subroutine tp2tps1(vp,g,tps0,dt,nsamp,vptps)
       dimension vp(1),vptps(1)
       integer dt
       do i=1,nsamp
          tp=2.0*(tps0+(i-1)*dt)*g/(1.0+g)
          ntp=tp/dt+1
          vptps(i)=vp(ntp)
       enddo
       return
       end


       subroutine tp2tps2(vp,g,tps0,dt,nsamp,vptps,vstps)
       dimension vp(1),g(1),vptps(1),vstps(1)
       integer dt
       do i=1,nsamp
          tp=2.0*(tps0+(i-1)*dt)*g(i)/(1.0+g(i))
          ntp=tp/dt+1
          vptps(i)=vp(ntp)
          vstps(i)=vp(ntp)*g(i)
c          vstps(i)=g(i)
       enddo
       return
       end

c
c      create a velocity-time trace
c
       subroutine vinterp(rt,rv,nsmp,dt,nn,tt,v,jrec)
c
c      rt: time function
c      rv: velocity function
c      nsmp: number of samples in the trace
c      dt: Time Sample interval (in ms)
c      nn: number of velocity picks
c      v: interpolated velocity function
c
       dimension rt(1), rv(1),v(1),tt(1)
       integer dt
c       write(24,*) 'nn=',nn,' dt=',dt
c       do 10 i=1,nn
c          write(24,*) 'rt-rv(',i,')=',rt(i),rv(i),jrec
c10     continue
       do 2000 i = 1,nsmp
              t  = dt * float(i)
              if(t .le. rt(1))then
                vel = rv(1)
              else if(t.ge.rt(nn))then
                vel = rv(nn)
              else
                do 1000 j=2,nn
                   if(t.ge.rt(j-1) .and. t.le.rt(j))then
                       fac = (t-rt(j-1))/(rt(j)-rt(j-1))
                       vel = rv(j-1)+fac*(rv(j)-rv(j-1))
                       go to 1002
                   endif
1000            continue
              endif
1002         continue
c              tt(i)=(i-1)*dt
              tt(i)=i*dt
              v(i) = vel
2000         continue
c            do i=1,nsmp
c                write(26,*) i,tt(i),v(i)
c            enddo
       return
       end


       subroutine linterp(n,xs,ys,xe,ye,x,y)
c
c      linear interpolation 
c
c           ye - ys
c      y = --------- (x - xs) + ys
c           xe - xs
c
        dimension ys(1),ye(1),y(1)
       if(xs .eq. xe) then
          do 10 i=1,n
             y(i)=0.5*(ys(i)+ye(i))
10        continue
       else
          do 20 i=1,n
             b = (ye(i)-ys(i))/(xe-xs)
             y(i) = b*(x-xs) + ys(i)
20        continue
       endif
       return
       end


         subroutine mvdat(x,n,y)
         dimension x(1),y(1)
c
c    Move n data samples from x to y
c
         do 10 i=1,n
             y(i)=x(i)
10       continue
         return
         end
