/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* declare all keywords and corresponding routines to handle them */
/* 08dec93 phil fincannon - added uppercase option */
void dobegin(), doname(), dotype(), dorow(), docol(), dominval(), domaxval(),
	doprompt(), doinitval(), doscript(), dosuffix(), doend(),
	doread(), dowrite(), doexec(), dotag(), dolength(), docomment(),
	doptreg(), doptdir(), doptchar(), doptblock(), doptsoc(),
	doptfifo(), doptconsol(), doon(), dooff(), doprecision(),
	doselect(), dopick(), douppercase();

struct keyent {char *keyword; void (*func)();} keytable[] =
{
	"begin",	dobegin,
	"name",		doname,
	"type",		dotype,
	"tag",		dotag,
	"prompt",	doprompt,
	"row",		dorow,
	"col",		docol,
	"length",	dolength,
	"minval",	dominval,
	"maxval",	domaxval,
	"initval",	doinitval,
	"script",	doscript,
	"suffix",	dosuffix,
	"read",		doread,
	"write",	dowrite,
	"execute",	doexec,
	"regular-file",	doptreg,
	"directory",	doptdir,
	"char-device",	doptchar,
	"block-device",	doptblock,
	"socket",	doptsoc,
	"named-pipe",	doptfifo,
	"console",	doptconsol,	
	"end",		doend,
	"on",           doon,
	"off",          dooff,
	"precision",    doprecision, 
	"comment",      docomment,
	"select",       doselect,
	"pick",         dopick,
	"uppercase",    douppercase,
	0,		0,
};
