/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* xalert.c -- a simple program to give the user a message  */
/* written 20apr91 by Phil Fincannon */

/* Here's what I came up with. I took out the Error Dialog and substituted */
/* a MessageBox child of the toplevel. (Basically the same thing, just using */
/* the real toplevel shell rather than a new one..) There's really not that */
/* much changed from the original. -- joe wade 21jan94 */

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>

#define XDEF(str)   XmStringCreate((str),XmSTRING_DEFAULT_CHARSET)

extern XmString xs_str_array_to_xmstr();
extern void centermap();

void exitCB();

main (argc, argv)
    int argc;
    char *argv[];
{
    Widget    toplevel, message;
    XmString  okstr, xmstr;
    char *getclass(), *classnm = getclass(&argc,argv);
    char *basename();

    toplevel = XtInitialize (argv[0], classnm, NULL, 0, &argc, argv);
    XtVaSetValues(toplevel,
    		XmNmappedWhenManaged, FALSE,
		NULL);

/* prepare dialog message  */
    if (argc > 2) xmstr = xs_str_array_to_xmstr (&argv[2], argc-2);
             else xmstr = XDEF ("xalert: no message??");
    if (argc > 1) okstr = XDEF (argv[1]);
             else okstr = XDEF ("OK");
  
/* create dialog message  */
    message = (Widget) XmCreateMessageBox (toplevel, "alert", NULL, 0);
    XtVaSetValues (message,
                   XmNdialogTitle, XDEF("ALERT!"),
                   XmNmessageString, xmstr,
                   XmNokLabelString, okstr,
                   XmNdialogType, XmDIALOG_ERROR,
		   XmNdefaultPosition, TRUE,
                   XmNnoResize, TRUE, 
		   NULL);
    XtAddCallback (message, XmNokCallback, exitCB, 0);
    XtUnmanageChild (XmMessageBoxGetChild (message, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild (XmMessageBoxGetChild (message, XmDIALOG_HELP_BUTTON));
    XtManageChild (message);
    XtRealizeWidget (toplevel);
    centermap (toplevel);

/* Check and dispatch events forever */
    XtMainLoop();
}

/* ----------------------------------------------------------------- */

void
exitCB (w, client_data, call_data)
    Widget  w;
    caddr_t  client_data;
    XmAnyCallbackStruct  *call_data;
{
      XtUnmanageChild (w);
      exit (1);
} 

