/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
 * REQUIRED MOTIF INCLUDE FILES
 */
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/MenuShell.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include  "HelpObject.h"

#include <sys/stat.h>


/*
 * EXTERNAL PROCEDURE DECLARATIONS
 */
/*
extern void XuHelper();
extern void XuHelp_Index();
extern void XuHelp_On_Version();
extern void XuHelp_On_Context();
extern void XuHelp_On_Help();
extern void XuSet_Help();
*/



void
XuCreateHelpPulldown(menuBar)
Widget  menuBar;
{
    Arg    	args[20];
    int    	argcnt;
    Widget	menuShell;
    Widget	pulldownMenu;
    Widget	toggleButton;
    Widget	toggleButton1;
    Widget	toggleButton2;
    Widget	toggleButton3;
    Widget	toggleButton4;
    Widget	toggleButton5;
    Widget	toggleButton6;
    Widget	cascadeButton;
 

/*  create menu shell in menuBar     */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell = XtCreatePopupShell("menuShell", xmMenuShellWidgetClass,
		menuBar, args, argcnt);
    XtManageChild(menuShell);

 
/*  create pulldownMenu in menuShell  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldownMenu = XtCreateWidget("pulldownMenu", xmRowColumnWidgetClass,
		menuShell, args, argcnt);

 
/*  create toggleButton On Help   */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    toggleButton = XtCreateWidget("On Help", xmToggleButtonWidgetClass,
		pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelp_On_Help, (caddr_t)0);
    XuSet_Help( toggleButton, "On_Help_Help" ); 
    XtManageChild(toggleButton);
 

/*  create toggleButton  Index   */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'I'); argcnt++;
    toggleButton1 = XtCreateWidget("Index", xmToggleButtonWidgetClass,
		pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton1, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelp_Index, (caddr_t)0);
    XuSet_Help( toggleButton1, "On_Index_Help" ); 
    XtManageChild(toggleButton1);
 

/*  create toggleButton Version  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'V'); argcnt++;
    toggleButton2 = XtCreateWidget("Version", xmToggleButtonWidgetClass,
		pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton2, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelp_On_Version, (caddr_t)0);
    XuSet_Help( toggleButton2, "On_Version_Help" ); 
    XtManageChild(toggleButton2);


/*  create toggleButton On Context  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'C'); argcnt++;
    toggleButton3 = XtCreateWidget("On Context", xmToggleButtonWidgetClass,
                pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton3, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelp_On_Context, (caddr_t)0);
    XuSet_Help( toggleButton3, "On_Context_Help" ); 
    XtManageChild(toggleButton3);


/*  create toggleButton On Keys  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'K'); argcnt++;
    toggleButton4 = XtCreateWidget("On Keys", xmToggleButtonWidgetClass,
                pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton4, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelper, "On_Keys_Text");
    XuSet_Help( toggleButton4, "On_Keys_Help" ); 
    XtManageChild(toggleButton4);


/*  create toggleButton Tutorial   */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'T'); argcnt++;
    toggleButton5 = XtCreateWidget("Tutorial", xmToggleButtonWidgetClass,
                pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton5, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelper, "On_Tutorial_Text");
    XuSet_Help( toggleButton5, "On_Tutorial_Help" ); 
    XtManageChild(toggleButton5);


/*  create toggleButton On Windows   */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNindicatorOn, False); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'W'); argcnt++;
    toggleButton6 = XtCreateWidget("On Windows", xmToggleButtonWidgetClass,
                pulldownMenu, args, argcnt);
    XtAddCallback(toggleButton6, XmNvalueChangedCallback,
	(XtCallbackProc) XuHelper, "On_Windows_Text");
    XuSet_Help( toggleButton6, "On_Windows_Help" ); 
    XtManageChild(toggleButton6);


/* create cascadeButton with sub_menu = pulldownMenu   */
/*        pulldownMenu is parent of all toggleButtons  */
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldownMenu); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    cascadeButton = XtCreateWidget("Help", xmCascadeButtonWidgetClass,
		menuBar, args, argcnt);
    XuSet_Help( cascadeButton, "On_Help_Help" ); 


/*  force the Help button to be located to the far right in menuBar  */
/*  comment if not wanted  */
    argcnt=0;
    XtSetArg (args[argcnt], XmNmenuHelpWidget, cascadeButton); argcnt++;
    XtSetValues(menuBar, args, argcnt);

    XtManageChild(cascadeButton);

}

