/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*      I wrote this program to handle input coming across coming
	in on standard input and display in to an X window (actually
	a Motif text widget if you want to get technical ) The 
	window will not come up until input is actually received.
						- Joe M. Wade */
/* 15may91 Phil Fincannon - added scroll/kill/print/dismiss push buttons */
/* 15may91 Phil Fincannon - added execute option */
/* 15may91 Phil Fincannon - added file concatenation option */
/* 26feb92 Joe M. Wade    - added options for special character printing,
			    line numbering, blank line compression,
			    line end flagging. */
/* 06mar92 Phil Fincannon - added selection processing option */
/* 16jun94 Joe M. Wade    - added -man option for taking care of boldface
			    and underscored characters 		*/
/* 09jun95 Joe M. Wade    - modified execute option to allow for selection
			    imbedding in the command    */
/* 09jun95 Joe M. Wade    - modified printing section to allow for LPDEST
			    and lp Unix printing on appropriate systems */
/* 07jul95 Joe M. Wade    - changed to non-blocking I/O rather than select()
			    due to varying nature of named pipes ; changed
			    dismiss button to always allow termination
			    until all input has been received		*/
/* 11jul95 Joe M. Wade    - modified code to handle sequences of underscores
			    and boldface on the same character; text will 
			    be shown with whichever property appeared last */
/* 02nov95 Joe M. Wade    - added "-kill" option to specify the kill signal
			    to be sent to a child process by ascii name 
			    (see "kill -l") or by signal number. */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include "HelpObject.h"
#include "help_defs.h"
#include "version.h"
#include "resources.h"
#include "xcat.xbm"
#include <localsys.h>
#include <eventnames.h>

#ifdef sun
#include <sys/filio.h>
#include <sys/time.h>
#else
#ifdef CRAY
#include <sys/ioctl.h>
#include <sys/time.h>
#else
#ifdef __convex__
#include <sys/time.h>
#else
#ifdef _IBMR2
#include <sys/select.h>
#else
#ifdef __hpux
#include <sys/time.h>
#else
#ifdef __sgi
#include <sys/time.h>
#endif
#endif
#endif
#endif
#endif
#endif

#include <xcat_defs.h>

#define PRINTCMD  "XCAT_PRINT_CMD"
static char *printcmd = NULL;

static XrmOptionDescRec options[] = {
	{"-rows",	"*rows",	XrmoptionSepArg,	"24"},
	{"-columns",	"*columns",	XrmoptionSepArg,	"80"},
	{"-buffer",	"*buffer",	XrmoptionSepArg,	"0"},
	{"-interval",	"*interval",	XrmoptionSepArg,	"1000"},
	{"-iconfile",	"*iconfile",	XrmoptionSepArg,	NULL},
	{"-sc",		"*scroll",	XrmoptionNoArg,		"TRUE"},
	{"-scroll",	"*scroll",	XrmoptionNoArg,		"TRUE"},
	{"+sc",		"*scroll",	XrmoptionNoArg,		"FALSE"},
	{"-noscroll",	"*scroll",	XrmoptionNoArg,		"FALSE"},
	{"-ed",		"*editable",	XrmoptionNoArg,		"TRUE"},
	{"-edit",	"*editable",	XrmoptionNoArg,		"TRUE"},
	{"+ed",		"*editable",	XrmoptionNoArg,		"FALSE"},
	{"-noedit",	"*editable",	XrmoptionNoArg,		"FALSE"},
	{"-am",		"*automap",	XrmoptionNoArg,		"TRUE"},
	{"-automap",	"*automap",	XrmoptionNoArg,		"TRUE"},
	{"+am",		"*automap",	XrmoptionNoArg,		"FALSE"},
	{"-noautomap",	"*automap",	XrmoptionNoArg,		"FALSE"},
	{"-ct",		"*center",	XrmoptionNoArg,		"TRUE"},
	{"-center",	"*center",	XrmoptionNoArg,		"TRUE"},
	{"+ct",		"*center",	XrmoptionNoArg,		"FALSE"},
	{"-kill",	"*killSignal",	XrmoptionSepArg,	"9"},
	{"-nocenter",	"*center",	XrmoptionNoArg,		"FALSE"},
	{"-tr",		"*transient",	XrmoptionNoArg,		"TRUE"},
	{"-transient",	"*transient",	XrmoptionNoArg,		"TRUE"},
	{"+tr",		"*transient",	XrmoptionNoArg,		"FALSE"},
	{"-notransient","*transient",	XrmoptionNoArg,		"FALSE"},
	{"-pc",		"*printCmd",	XrmoptionSepArg,	NULL},
	{"-pl",		"*printLabel",	XrmoptionSepArg,	NULL},
	{"-p1",		"*printOnce",	XrmoptionNoArg,		"TRUE"},
	{"-xc",		"*xCmd",	XrmoptionSepArg,	NULL},
	{"-xl",		"*xLabel",	XrmoptionSepArg,	NULL},
	{"-xf",		"*xForce",	XrmoptionNoArg,		"TRUE"},
	{"-sl1",	"*scrollLabel1", XrmoptionSepArg,	NULL},
	{"-sl2", 	"*scrollLabel2", XrmoptionSepArg,	NULL},
	{"-stl",	"*stopLabel",	XrmoptionSepArg,	NULL},
	{"-qtl",	"*quitLabel",	XrmoptionSepArg,	NULL},
	{"+busy",	"*busy",	XrmoptionNoArg,		"FALSE"},
	{"-busy",	"*busy",	XrmoptionNoArg,		"TRUE"},
	{"-debug",	"*debug",	XrmoptionNoArg,		"TRUE"},
	{"-ve",		"*lineEnd",	XrmoptionNoArg,		"TRUE"},
	{"-n",		"*numbering",	XrmoptionNoArg,		"TRUE"},
	{"-b",		"*blankNumbering",	XrmoptionNoArg,	"FALSE"},
	{"-t",		"*tabPrinting",	XrmoptionNoArg,		"TRUE"},
	{"-v",		"*nonPrinting",	XrmoptionNoArg,		"TRUE"},
	{"-man",	"*manPrinting",	XrmoptionNoArg,		"TRUE"},
	{"-menu",	"*menuBar",	XrmoptionNoArg,		"TRUE"},
	{"-s",		"*blankCompress", XrmoptionNoArg,	"TRUE"},
	{"-e",		NULL,		XrmoptionSkipLine,	NULL}};

static XtResource resources[] = {
	{ XmNrows, XmCRows, XtRShort, sizeof(short),
	    XtOffset(ApplicationDataPtr,rows),
	    XtRImmediate, (XtPointer) 24},
	{ XmNcolumns, XmCColumns, XtRShort, sizeof(short),
	    XtOffset(ApplicationDataPtr,columns),
	    XtRImmediate, (XtPointer) 80},
	{ "buffer", "Buffer", XtRInt, sizeof(int),
	    XtOffset(ApplicationDataPtr,memory_allocation),
	    XtRImmediate, (XtPointer) 0},
	{ "interval", "Interval", XtRShort, sizeof(short),
	    XtOffset(ApplicationDataPtr,max_time_interval),
	    XtRImmediate, (XtPointer) 1000},
	{ "iconfile", "Iconfile", XtRString, sizeof(String),
	    XtOffset(ApplicationDataPtr,iconfile),
	    XtRString, NULL},
	{ "lineEnd", "LineEnd", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,lineEnd),
	    XtRString, "FALSE"},
	{ "numbering", "Numbering", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,numbering),
	    XtRString, "FALSE"},
	{ "tabPrinting", "TabPrinting", XtRBoolean,
	    sizeof(Boolean), XtOffset(ApplicationDataPtr,tabPrinting),
	    XtRString, "FALSE"},
	{ "nonPrinting", "NonPrinting", XtRBoolean,
	    sizeof(Boolean), XtOffset(ApplicationDataPtr,nonPrinting),
	    XtRString, "FALSE"},
	{ "manPrinting", "ManPrinting", XtRBoolean,
	    sizeof(Boolean), XtOffset(ApplicationDataPtr,manPrinting),
	    XtRString, "FALSE"},
	{ "menuBar", "MenuBar", XtRBoolean,
	    sizeof(Boolean), XtOffset(ApplicationDataPtr,menuBar),
	    XtRString, "FALSE"},
	{ "blankNumbering", "BlankNumbering", XtRBoolean,
	    sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,blankNumbering),
	    XtRString, "TRUE"},
	{ "blankCompress", "BlankCompress", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,blankCompress),
	    XtRString, "FALSE"},
	{ "scroll", "Scroll", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,scroll),
	    XtRString, "TRUE"},
	{ "transient", "Transient", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,transient),
	    XtRString, "FALSE"},
	{ "printCmd", "PrintCmd", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,printCmd),
	    XtRString, NULL},
	{ "printLabel", "PrintLabel", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,printLabel),
	    XtRString, "print"},
	{ "printOnce", "PrintOnce", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,printOnce),
	    XtRString, "FALSE"},
	{ "xCmd", "XCmd", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,xCmd),
	    XtRString, NULL},
	{ "xLabel", "XLabel", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,xLabel),
	    XtRString, "edit"},
	{ "xForce", "XForce", XtRBoolean,
	    sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,xForce),
	    XtRString, "FALSE"},
	{ "scrollLabel1", "ScrollLabel1", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,scrollLabel1),
	    XtRString, "disable scrolling"},
	{ "scrollLabel2", "ScrollLabel2", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,scrollLabel2),
	    XtRString, "enable scrolling"},
	{ "stopLabel", "StopLabel", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,stopLabel),
	    XtRString, "kill input"},
	{ "quitLabel", "QuitLabel", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,quitLabel),
	    XtRString, "dismiss"},
	{ XmNeditable, XmCEditable, XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,editable),
	    XtRString, "FALSE"},
	{ "automap", "Automap", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,automap),
	    XtRString, "TRUE"},
	{ "center", "Center", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,center),
	    XtRString, "TRUE"},
	{ "killSignal", "KillSignal", XtRString, sizeof(char *),
	    XtOffset(ApplicationDataPtr,killSignal),
	    XtRString, "9"},
	{ "busy", "Busy", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,busy),
	    XtRString, "FALSE"},
	{ "debug", "Debug", XtRBoolean, sizeof(Boolean),
	    XtOffset(ApplicationDataPtr,debug),
	    XtRString, "FALSE"} };

static  Arg arg[20];
static  int ac;
static  Widget toplevel, form, text, scroll, quit, xselect;
static  pid_t pid=0;
static  pid_t grppid=0;
static  int tee=0, exec=0, concat=0, exitstat=0;
static  Memory memory;
static  int argc2;
static  char *argv2[90];
static  ApplicationData data;

/* - go with a dynamic sizing scheme		- j.m.wade 4/21/92
#define MAXCMDBUF 4096
static  char cmdbuf[MAXCMDBUF];
*/
static  char *cmdbuf;

   extern char *getenv();
   extern char *strsav();
   extern char *optarg;
   extern int optind, opterr;

   extern void alert_init(), alert();
   extern void oldfile();
   extern void newfile();

   void xselectCB();

/*------------------------------------------------------------*/

main (argc, argv)
   int argc;
   char **argv;
{
   extern char* mybasename();
#ifndef __hpux
   extern void seticon();
#endif
   extern void execute();
   extern void centermap();
   extern void adios();
   extern char *getclass();

/* XtTimerCallbackProc input(); */
   void input();
   void kill_input();
   void sc_toggle();
   void print_disable();
   void catch_signal();

   Pixmap bitmap;
   XmString label,accel_label;
   XtAppContext app_con;
   XEvent event;
   Screen  *scrn;
   char *class;
   char cmd[200];
   Display *dpy;
   unsigned long mask;
   XSetWindowAttributes attr;
   Widget menubar,file_but,file_pd,menu_quit;

   int i, j, opt;
   int cmdbuf_lng;

   char *help_path;

	setbuf (stdout, NULL); 
	setbuf (stderr, NULL); 

/*	This is a bug fix for the R4 Intrinsics. Problems were encountered
	if the arguments following the "-e" option contained anything which
	was a valid Intrinsics argument. What this loop does is take all 
	those arguments following the "-e" and parse them into one large
	argument. This also takes care of setting up cmdbuf, which needs
	to be done anyway. This code may be deleted after conversion to
	R5 and the code which sets up cmdbuf after all the argument
	parsing is done may be uncommented.
						- j.m.wade 11/22/91 */
/*	Modified this piece of code to dynamically allocate memory for
	the character string containing all of the subcommand which 
	will be passed to the execute subroutine. Even though it was 
	fairly large, I managed to blow out the top side.
						- j.m.wade 4/21/92 */
	for (i=0; i<argc; i++) {
	  if (strcmp("-e",argv[i]) == 0) {
	    cmdbuf = (char *) malloc((strlen(argv[i+1])+1) * sizeof(char));
	    cmdbuf_lng = strlen(argv[i+1])+1;
	    strcpy(cmdbuf,argv[i+1]);

	    for (j=i+2; j<argc; j++ ) {
	      cmdbuf_lng += strlen(argv[j])+1,
	      cmdbuf = (char *) realloc(cmdbuf, cmdbuf_lng * sizeof(char)),

	      strcat(cmdbuf," ");
	      strcat(cmdbuf,argv[j]);
	      }
	    argv[i+1] = cmdbuf;
	    argc = i+2;
	    break;
	    }
	  }

	class = getclass(&argc,argv);

	toplevel = XtAppInitialize (&app_con, class, options,
			XtNumber(options), &argc, argv, app_defs, NULL, 0);

	XtGetApplicationResources (toplevel, &data, resources, 
				   XtNumber(resources), NULL, 0);

        alert_init (toplevel);

/* Take care of cases where one option implies another */

	if (!data.blankNumbering) data.numbering = TRUE;
	if (data.tabPrinting || data.lineEnd || data.manPrinting)
		data.nonPrinting = TRUE;

	if (data.debug)
	  for (i=0; i<argc; i++) 
	    fprintf(stderr,"argv[%d] = %s\n",i,argv[i]);

	while ((opt = getopt(argc,argv,"S:hpe")) != -1) 
	switch (opt) {
	  case 'h':
	    fprintf (stderr,"Purpose: display stdout of a batch program or ");
	    fprintf (stderr,	"a process run as a child\n");
	    fprintf (stderr,"Usage:   ls | xcat [options] \n");
	    fprintf (stderr,"         xcat [options] filename(s)\n");
	    fprintf (stderr,"         xcat [options] -e command\n");
	    fprintf (stderr,"\nOptions:\n");
	    fprintf (stderr,"  -/+am\tenable/disable forced mapping, ie. ");
	    fprintf (stderr,   " map window to\n\t\tscreen immediately. ");
	    fprintf (stderr,   "(default=enabled)\n");
	    fprintf (stderr,"  -buffer #\tinitial buffer size ");
	    fprintf (stderr,   "(default=BUFSIZ, ");
	    fprintf (stderr,	"where BUFSIZ\n\t\tis the machine's ");
	    fprintf (stderr,	"internal i/o buffer size)\n");
	    fprintf (stderr,"  -/+busy\tenable/disable busy cursor.");
	    fprintf (stderr,   "(default=disabled)\n");
	    fprintf (stderr,"  -/+ct\tenable/disable window centering ");
	    fprintf (stderr,   "on screen (default=centered)\n");
	    fprintf (stderr,"  -iconfile fn\tname of bitmap file ");
	    fprintf (stderr,    "(default=NULL)\n");
	    fprintf (stderr,"  -interval #\tmax interval in ms for checking ");
	    fprintf (stderr,	"input stream (default=1000)\n");
	    fprintf (stderr,"  -p\t\tcopy text to stdout ");
	    fprintf (stderr,   "(default=no stdout)\n");
	    fprintf (stderr,"  -pc cmd\tcommand which will receive ");
	    fprintf (stderr,	"data if the environment variable\n\t\t");
	    fprintf (stderr,    "XCAT_PRINT_CMD is not set (default=lpr)\n");
	    fprintf (stderr,"  -pc cmd\tcommand which will receive ");
	    fprintf (stderr,	"data if the environment variable\n\t\t");
	    fprintf (stderr,    "XCAT_PRINT_CMD is not set (default=lpr)\n");
	    fprintf (stderr,"  -p1\t\ttoggles behaviour so that print ");
	    fprintf (stderr,	"button may only be activated once.\n\t\t");
	    fprintf (stderr,"  -kill signal\tspecify signal (text or number) ");
	    fprintf (stderr,	"to send to child process when\n\t\t\"kill ");
	    fprintf (stderr,    "input\" is selected (default=SIGKILL)\n");
	    fprintf (stderr,"  -/+sc\tenable/disable initial scrolling ");
	    fprintf (stderr,	"(default=enabled)\n");
	    fprintf (stderr,"  -/+tr\tenable/disable transient command ");
	    fprintf (stderr,   "window, ie. window goes\n\t\taway when data ");
	    fprintf (stderr,   "end of file is received. (default=disabled)\n");
	    fprintf (stderr,"  -e cmd\texecute command as child process\n");
	    fprintf (stderr,"\nText widget behaviour options:\n");
	    fprintf (stderr,"  -/+ed\tenable/disable text editing. ");
	    fprintf (stderr,   "(default=disabled)\n");
	    fprintf (stderr,"  -rows\t\tnumber of rows (default=24)\n");
	    fprintf (stderr,"  -columns\tnumber of columns (default=80)\n");
	    fprintf (stderr,"\ncat(1) compatability options:\n");
	    fprintf (stderr,"  -b\t\tsequentially number all but blank ");
	    fprintf (stderr,   "lines.\n");
	    fprintf (stderr,"  -n\t\tsequentially number each output line.\n");
	    fprintf (stderr,"  -s\t\tSubstitue a single blank line for ");
	    fprintf (stderr,	"multiple adjacent blank lines.\n");
	    fprintf (stderr,"  -t\t\tmake non-printing characters visible, as");
	    fprintf (stderr,	" -v, also showing\n\t\tTAB as ^I (CTRL-I).\n");
	    fprintf (stderr,"  -v\t\tmake non-printing characters visible ");
	    fprintf (stderr,	"(except TAB and NEWLINE).\n");
	    fprintf (stderr,"  -ve\t\tmake non-printing characters visible, ");
	    fprintf (stderr,	"as -v, also showing\n\t\tnewline ");
	    fprintf (stderr,	"character (\\n) as $. ");
	    fprintf (stderr,	"(-e option of cat(1))\n");
	    exit (1);
	  case 'p':
	    tee++;
	    break;
	  case 'e':
	    exec++;
	    break;
	}

	if (exec) {

/*	The bug fix for R4 takes care of setting up cmdbuf. When and
	if we ever get to R5, this can be reinstated and the above 
	section removed.			
						- j.m.wade 11/22/91

	   cmdbuf[0] = '\0';

	   for (i = 0; optind < argc; optind++, i++) {
	        if (strlen(argv[optind]) + i + 1 >= MAXCMDBUF) {
			fprintf(stderr,"xcat -e: too many argument chars\n");
			exit(1);
	  	}
		strcat(cmdbuf,argv[optind]);
		strcat(cmdbuf," ");
		i += strlen(argv[optind]);
	   }
*/

	   if (data.debug)
	     fprintf(stderr,"execute >>%s<<\n",cmdbuf);
	   execute (cmdbuf);
	   goto setup;
	}

	if (optind < argc) {
	   memory.filename = argv[optind];
	   if (freopen(argv[optind], "r", stdin)==NULL) {
	      fprintf (stderr, "%s: can't open %s for input\n",
		       mybasename(argv[0]), argv[optind]);
	      exit (1);
	   }
	   concat = 1;
	   argc2 = argc;
	   for (i=0; i<argc; ++i) argv2[i] = argv[i];
	   optind++;
	}

	if (isatty(fileno(stdin))) {
	   fprintf (stderr, "%s: can't read input from keyboard\n",
		    mybasename(argv[0]));
	   exit (1);
	}

setup:
	if (data.debug) {
	 fprintf(stderr,"print out the data structure:\n");
	 fprintf(stderr,"\t\trows - %d\n",data.rows);
	 fprintf(stderr,"\t\tcolumns - %d\n",data.columns);
	 fprintf(stderr,"\t\tmemory allocaction - %d\n",data.memory_allocation);
	 fprintf(stderr,"\t\tmax time interval - %d\n",data.max_time_interval);
	 fprintf(stderr,"\t\teditable - %d\n",data.editable);
	 fprintf(stderr,"\t\teditMode - %d\n",data.editMode);
	 fprintf(stderr,"\t\tlineEnd - %d\n",data.lineEnd);
	 fprintf(stderr,"\t\tnumbering - %d\n",data.numbering);
	 fprintf(stderr,"\t\tblankNumbering - %d\n",data.blankNumbering);
	 fprintf(stderr,"\t\tblankCompress - %d\n",data.blankCompress);
	 fprintf(stderr,"\t\tscroll - %d\n",data.scroll);
	 fprintf(stderr,"\t\ttransient - %d\n",data.transient);
	 fprintf(stderr,"\t\tautomap - %d\n",data.automap);
	 fprintf(stderr,"\t\tcenter - %d\n",data.center);
	 if (data.iconfile != NULL)
	   fprintf(stderr,"\t\ticonfile - %s\n",data.iconfile);
	 else
	   fprintf(stderr,"\t\ticonfile - NULL\n");
	 if (data.killSignal != NULL)
	   fprintf(stderr,"\t\tkillSignal - %s\n",data.killSignal);
	 else
	   fprintf(stderr,"\t\tkillSignal - NULL\n");
	 fprintf(stderr,"\t\tdebug - %d\n",data.debug);
	 if (data.printCmd != NULL)
	   fprintf(stderr,"\t\tprintCmd - %s\n",data.printCmd);
	 else
	   fprintf(stderr,"\t\tprintCmd - NULL\n");
	 if (data.printLabel != NULL)
	   fprintf(stderr,"\t\tprintLabel - %s\n",data.printLabel);
	 else
	   fprintf(stderr,"\t\tprintLabel - NULL\n");
	 if (data.scrollLabel1 != NULL)
	   fprintf(stderr,"\t\tscrollLabel1 - %s\n",data.scrollLabel1);
	 else
	   fprintf(stderr,"\t\tscrollLabel1 - NULL\n");
	 if (data.scrollLabel2 != NULL)
	   fprintf(stderr,"\t\tscrollLabel2 - %s\n",data.scrollLabel2);
	 else
	   fprintf(stderr,"\t\tscrollLabel2 - NULL\n");
	 if (data.stopLabel != NULL)
	   fprintf(stderr,"\t\tstopLabel - %s\n",data.stopLabel);
	 else
	   fprintf(stderr,"\t\tstopLabel - NULL\n");
	 if (data.quitLabel != NULL)
	   fprintf(stderr,"\t\tquitLabel - %s\n",data.quitLabel);
	 else
	   fprintf(stderr,"\t\tquitLabel - NULL\n");
	 if (data.xLabel != NULL)
	   fprintf(stderr,"\t\textLabel - %s\n",data.xLabel);
	 else
	   fprintf(stderr,"\t\textLabel - NULL\n");
	 if (data.xCmd != NULL)
	   fprintf(stderr,"\t\textCmd - %s\n",data.xCmd);
	 else
	   fprintf(stderr,"\t\textCmd - NULL\n");
	 fprintf(stderr,"\t\textCmdForce - %d\n",data.xForce);
	 }

	form = XmCreateForm (toplevel, "form", NULL, 0);

	menubar = XmCreateMenuBar(form,"menubar",NULL,0);
	XtVaSetValues(menubar,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			NULL);

	file_pd = XmCreatePulldownMenu(menubar,"FilePD",NULL,0);

	file_but = XtVaCreateManagedWidget("File",
		xmCascadeButtonWidgetClass, menubar,
			XmNmnemonic,		'F',
			XmNsubMenuId,		file_pd,
			NULL);

	label = XmStringCreate("Save",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+S",XmSTRING_DEFAULT_CHARSET);
	memory.save = XtVaCreateManagedWidget("savePB",
		xmPushButtonWidgetClass, file_pd,
			XmNlabelString, label,
			XmNmnemonic, 'S',
			XmNacceleratorText, accel_label,
			XmNaccelerator, "Ctrl<Key>s",
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	label = XmStringCreate("Save As",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+A",XmSTRING_DEFAULT_CHARSET);
	memory.save_as = XtVaCreateManagedWidget("saveasPB",
		xmPushButtonWidgetClass, file_pd,
			XmNlabelString, label,
			XmNmnemonic, 'A',
/*
			XmNmappedWhenManaged, FALSE,
*/
			XmNacceleratorText, accel_label,
			XmNaccelerator, "Ctrl<Key>a",
			NULL);
	XmStringFree(label);
	XmStringFree(accel_label);

	label = XmStringCreate("Quit",XmSTRING_DEFAULT_CHARSET);
	accel_label = XmStringCreate("Ctrl+Q",XmSTRING_DEFAULT_CHARSET);
	menu_quit = XtVaCreateManagedWidget("menu_quit",
		xmPushButtonWidgetClass, file_pd,
			XmNlabelString, label,
			XmNmnemonic, 'Q',
			XmNacceleratorText, accel_label,
			XmNaccelerator, "Ctrl<Key>q",
			NULL);
	XtAddCallback (menu_quit, XmNactivateCallback, adios, NULL);

	XtManageChild(file_but);

	if (!data.menuBar)		/* shrink it so it's invisible */
		XtVaSetValues(menubar,
			XmNmappedWhenManaged,	TRUE,
			XmNbottomAttachment, XmATTACH_OPPOSITE_FORM,
			NULL);

	XtManageChild(menubar);

/*
   go ahead and allow termination of input even if data is coming from files
*/ /*
 	if (exec)
		label = XmStringCreate(data.stopLabel,XmSTRING_DEFAULT_CHARSET);
 	else
		label = XmStringCreate(concat ? data.quitLabel : data.stopLabel,
			XmSTRING_DEFAULT_CHARSET);
*/
	label = XmStringCreate(data.stopLabel,XmSTRING_DEFAULT_CHARSET);

	quit = XtVaCreateManagedWidget("dismissPB",
		xmPushButtonWidgetClass, form,
			XmNlabelString, label,
			XmNresizable, FALSE,
			XmNrightAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_POSITION,
			XmNleftPosition, 50,
			XmNtopAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_FORM,
			XmNmnemonic, 'C',
			XmNaccelerator, "Ctrl<Key>c",
			NULL);
	XtAddCallback (quit, XmNactivateCallback,
		kill_input, (XtPointer) &memory);
	XmStringFree(label);
	XtManageChild (quit);
	XuSet_Help(quit,"PanelButDsc.help");

	XuCreateHelpPulldown(menubar);
	XuSet_Help_Shell(toplevel);
	help_path = getenv("XCAT_HELPDIR");
	if (help_path == (char *)NULL) help_path = ".";
	XuSet_Help_Path(help_path);
	XuSet_Help_Index(help_items,(sizeof(help_items)/sizeof(char *))/2);
	XuSet_Help_Version(version);
	XuSet_Help(menubar,"MenuB_Dsc.help");

	if (data.scroll)
	  label = XmStringCreate(data.scrollLabel1,XmSTRING_DEFAULT_CHARSET);
	else
	  label = XmStringCreate(data.scrollLabel2,XmSTRING_DEFAULT_CHARSET);

	scroll = XtVaCreateManagedWidget("printPB",
	  	        xmPushButtonWidgetClass, form,
			XmNlabelString, label,
			XmNresizable, FALSE,
			XmNleftAttachment, XmATTACH_FORM,
			XmNrightAttachment, XmATTACH_POSITION,
			XmNrightPosition, 50,
			XmNtopAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);
	XmStringFree(label);
	XtManageChild (scroll);
	XuSet_Help(scroll,"PanelButDsc.help");
	
	ac = 0;
	XtSetArg(arg[ac], XmNrows, data.rows);				ac++;
	XtSetArg(arg[ac], XmNcolumns, data.columns);			ac++;
	XtSetArg(arg[ac], XmNautoShowCursorPosition, data.scroll);	ac++;
/* - don't let the user edit it until all data is received */
	XtSetArg(arg[ac], XmNeditable, FALSE);				ac++;
	XtSetArg(arg[ac], XmNeditMode, XmMULTI_LINE_EDIT);		ac++;
	XtSetArg(arg[ac], XmNleftAttachment, XmATTACH_FORM);		ac++;
	XtSetArg(arg[ac], XmNrightAttachment, XmATTACH_FORM);		ac++;
	if (data.menuBar) {
	  XtSetArg(arg[ac], XmNtopAttachment, XmATTACH_WIDGET);		ac++;
	  XtSetArg(arg[ac], XmNtopWidget, menubar);			ac++;
	  }
	else {
	  XtSetArg(arg[ac], XmNtopAttachment, XmATTACH_FORM);		ac++;
	  }
	XtSetArg(arg[ac], XmNbottomAttachment, XmATTACH_WIDGET);	ac++;
	XtSetArg(arg[ac], XmNbottomWidget, scroll);			ac++;
	text = XmCreateScrolledText (form, "window", arg, ac);
	XtManageChild (text);
	XuSet_Help(text,"Text_Dsc.help");

	XtAddCallback (scroll, XmNactivateCallback,sc_toggle,(XtPointer)text);

/* 06mar92 pf+ process selection option */
        if (data.xCmd) {
	    label = XmStringCreate(data.xLabel,XmSTRING_DEFAULT_CHARSET);
	    xselect = XtVaCreateManagedWidget("xselectPB",
	  	        xmPushButtonWidgetClass, form,
			XmNlabelString, label,
			XmNresizable, FALSE,
			XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, scroll,
			XmNrightAttachment, XmATTACH_WIDGET,
			XmNrightWidget, quit,
			XmNtopAttachment, XmATTACH_NONE,
			XmNbottomAttachment, XmATTACH_FORM,
			NULL);
	    XmStringFree(label);
	    XtManageChild (xselect);
	    XtSetSensitive (xselect, FALSE);
	    XtVaSetValues (quit, XmNleftPosition, 67, NULL);
	    XtVaSetValues (scroll, XmNrightPosition, 33, NULL);
	    XtAddCallback (xselect, XmNactivateCallback,xselectCB,
			   (caddr_t)text);
	    XuSet_Help(xselect,"PanelButDsc.help");
	}
/* 06mar92 pf+ process selection option */
	
	for (i=0; i<strlen(data.killSignal); i++) { 
	   if ( isdigit(data.killSignal[i]) == 0) break;
	   }

	if (i == strlen(data.killSignal))
	  memory.kill_signal =  atoi(data.killSignal);
	else {
	  memory.kill_signal = siglu(data.killSignal);
/*
	  fprintf(stderr,"xcat error: unable to translate %s to a numeric signal\n",data.killSignal);
*/
	  }

	signal(memory.kill_signal, catch_signal);

	memory.toplevel = toplevel;
	memory.source = fileno(stdin);
	memory.app_con = &app_con;
	memory.widget = text;
	memory.kill = quit;
	memory.first = TRUE;
	memory.debug = data.debug;
	memory.buf_size = data.memory_allocation;
	if (memory.buf_size == 0) memory.buf_size = BUFSIZ;
	memory.max_interval = data.max_time_interval;
	memory.buffer = (char *) malloc ((memory.buf_size +1) * sizeof(char));
 	if (memory.buffer == NULL) {
		fprintf(stderr," xcat: unable to allocate buffer area - ");
		fprintf(stderr,"%d bytes requested\n",memory.buf_size+1);
		exit(1);
	}

/* added to prevent blocking on read and eliminate need for select() */

	if (fcntl(memory.source,F_SETFL,O_NONBLOCK) == -1) {
	  perror("xcat");
	  exit(1);
	  }

	memory.interval_id = XtAppAddTimeOut(app_con,1000,  /* was 0 */
		(XtTimerCallbackProc) input,(XtPointer) &memory);

	XtManageChild (form);

	XtVaSetValues (toplevel, XmNmappedWhenManaged, FALSE, NULL);
	XtRealizeWidget (toplevel);
/*
#ifndef __hpux
	if (data.iconfile) seticon (toplevel, data.iconfile);
#endif
	if (data.iconfile) XtVaSetValues(toplevel,
		XmNiconPixmap,	*data.iconfile,
		NULL);
*/
	if (data.iconfile)
	  seticon (toplevel, data.iconfile);
	else {
	  bitmap = XCreatePixmapFromBitmapData (XtDisplay (toplevel),
				  RootWindowOfScreen (XtScreen (toplevel)),
				  (char *) xcat_bits,
				  xcat_width, xcat_height,
				  BlackPixelOfScreen (XtScreen (toplevel)),
				  WhitePixelOfScreen (XtScreen (toplevel)),
				  1);

	  XtVaSetValues (toplevel, XmNiconPixmap, bitmap, NULL);
	  }

	dpy = XtDisplay(memory.toplevel);

	if (data.debug) {
	  XTextProperty tp;
	  XGetWMName(dpy,XtWindow(toplevel),&tp);
	  fprintf(stderr,"name of toplevel shell window = %s\n",tp.value);
	  }
	if (data.automap) {
	  if (data.center)
	    centermap (memory.toplevel);
	  else
	    XtMapWidget(memory.toplevel);
	  }

     /* Ignore device events while the busy cursor is displayed. */

	if (data.busy) {
	  mask = CWDontPropagate | CWCursor;
	  attr.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
		ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	  attr.cursor = XCreateFontCursor(dpy, XC_watch);

	  memory.busy_win = XCreateWindow(dpy,
		XtWindow(text), 0, 0,
		DisplayWidth(dpy,DefaultScreen(dpy)),
		DisplayHeight(dpy,DefaultScreen(dpy)),
		(unsigned int) 0, CopyFromParent, InputOnly,
		CopyFromParent, mask, &attr);
	  XMapRaised(dpy,memory.busy_win);
	  }

/*
	while(TRUE) {
	  XtAppNextEvent(app_con,&event);
	  fprintf(stderr,
	    "main: event type = %s  window = %8x \n",
	      event_names[event.type],event.xany.window);
	  XtDispatchEvent(&event);
	  }
*/
	XtAppMainLoop (app_con);
}

/*------------------------------------------------------------*/

char *mybasename(path) /* return filename sans leading path */
char *path;
{
	register char *p = path, c;

	while (c = *p++) if (c == '/') path = p;

	return (path);
}

/*------------------------------------------------------------*/

/* static XtTimerCallbackProc */
void
input (clientdata, input_id)
   caddr_t	clientdata;
   XtIntervalId	*input_id;
{
/* Boolean data_to_be_read(); */
   void kill_input();
   void centermap();
   int     bytes_read,knt,knt_bump,ls_bump;
   static short line_number;
   static Boolean new_line = TRUE;
   static Boolean prev_blank_line = FALSE,blank_line = FALSE;
   static unsigned long timer_interval = 1;
   static XmTextPosition  pos = 0;
   static char *line_start;
   static char null_char  = (char) 0;
   static Boolean flush = FALSE;
   char masked_char,saved_char;
   static char prev_bold_char,old_prev_char,prev_char,next_char;
   static char special_char[8];
   char line_number_text[10];
   XmHighlightMode highlight_style;
   static Boolean highlight = FALSE;
   Memory  *memory = (Memory *)clientdata;
   static int prev_line_feed_pos = 0;
#ifdef CRAY
   static int line_counter = 0;
#endif

/*
	if (data_to_be_read(memory->source)) {
*/
	  bytes_read = read(memory->source,memory->buffer,memory->buf_size);

	  if (memory->first) {
	    memory->first = FALSE;
/*
fprintf(stderr,"buffer\tknt\told_prev_char\tprev_char\tsaved_char\tnext_char\tpos\tflush\thighlight\n");
*/
	    if (data.center)
	      centermap (memory->toplevel);
	    else
	      XtMapWidget(memory->toplevel);
	    XFlush (XtDisplay(memory->toplevel));
	    }

	  switch (bytes_read) {
	   case (-1):
	     if ((errno != 0) && (errno != (int) EAGAIN) && 
		(errno != (int) EWOULDBLOCK)) {
	       perror("xcat");
	       exit(1);
	       }
	     break;
	   case 0:
	   /*  if (memory->first) exit(0); */
	     if (concat && optind < argc2) {
		if (freopen(argv2[optind], "r", stdin)==NULL) {
		   fprintf (stderr, "%s: can't open %s for input\n",
			    mybasename(argv2[0]), argv2[optind]);
		   exit (1);
		}
		optind++;
	     } else {
		XtCallCallbacks (memory->kill, XmNactivateCallback, NULL);
		return;
	     }
	     break;
	   default:

	      if (tee) write (1, memory->buffer, bytes_read);
	      *(memory->buffer + bytes_read) = '\0';
	      for (knt=0, line_start=memory->buffer; knt<bytes_read; knt++) {
/*
	added this section of code for special character printing 
					- j.m.wade 2/26/92
*/
	 	if (data.nonPrinting) {
/*
	highlight means the last char of the prev buffer was a backspace;
	step back a character and handle it.
*/
		  if (highlight) {
		    knt--;
/* 	we flushed out a character that wasn't special yet */
		    if ((bytes_read == 1) && 
			(prev_bold_char == '\0')) pos--;
		    saved_char = prev_char;
		    prev_char = old_prev_char;
		    old_prev_char = '\0';  
		    }
		  else {
		    old_prev_char = '\0';
		    strcpy(special_char,"");
		    saved_char = (char) *(memory->buffer + knt);
		    }

	  	  if ((masked_char =  saved_char & 0177) != saved_char) {
		    strcat(special_char, "M-");
		    flush = TRUE;
		    prev_bold_char = '\0';
		    }
		  if (masked_char == 0177) {
		    strcat(special_char, "^");
		    masked_char = '?';
		    flush = TRUE;
		    prev_bold_char = '\0';
		    }
		  else if ((masked_char < ' ') && (saved_char != 0012)) {
		    if (data.tabPrinting || (saved_char != 0011)) {
		      masked_char = masked_char + '@';
		      if (masked_char != 'H' || !data.manPrinting) {
		        strcat(special_char, "^");
		        prev_bold_char = '\0';
			}
		      else {
/*
	Take care of special highlighted characters (man pages)
*/
			strcat(special_char,"");
			highlight = TRUE;
			if (knt > 0) {
			  if (prev_char == '\0') {
			    prev_char = (char) *(memory->buffer + knt - 1);
			    }
			  *(memory->buffer + knt - 1) = '\0';
			  }

			if (knt+1 < bytes_read) {
			  next_char = (char) *(memory->buffer + knt + 1);
	                  *(memory->buffer + knt + 1) = '\0';
			 if (prev_char == next_char) {
		          old_prev_char = '\0';
			  masked_char = prev_char;
/*
	if knt=0, we already decrement below for flushed characters
*/
			  if ((knt != 0) &&
				(prev_bold_char == masked_char)) pos--;
			  highlight_style = XmHIGHLIGHT_SELECTED;
			  knt_bump = 1;
			  ls_bump = 1;
			  }
			 else if (next_char == '_') {
			  masked_char = prev_char;
			  if ((knt != 0) &&
				(prev_bold_char == masked_char)) pos--;
			  highlight_style = XmHIGHLIGHT_SECONDARY_SELECTED;
			  knt_bump = 1;
			  ls_bump = 2;
			  }
			 else if (prev_char == '_') {
			  masked_char = next_char;
			  if (knt != 0) {
			    if (prev_bold_char == masked_char) pos--;
			    else if (prev_bold_char == '_') pos--;
			    }
			  highlight_style = XmHIGHLIGHT_SECONDARY_SELECTED;
		          prev_char = next_char;
			  knt_bump = 1;
			  ls_bump = 2;
			  }
			 else {
			  fprintf(stderr,"overstriking not allowed (%c^H%c)\n",
				prev_char,next_char);
			  highlight_style = XmHIGHLIGHT_SELECTED;
			  masked_char = prev_char;
			  knt_bump = 1;
			  ls_bump = 2;
			  }
			 }
/* backspace is last character in buffer */
			else {
			  masked_char = '\0';
			  old_prev_char = prev_char;
			  prev_char = saved_char;
			  }

/* check for backspace at first of buffer */

			if (knt == 0) {
			  if (bytes_read != 1) pos--;
			  ls_bump-=sizeof(old_prev_char);
			  }
			}		/* end of ^H condition */
		      flush = TRUE;
		      }
		    }
		  else {
/* normal character */
		    if (flush) line_start = memory->buffer+knt;
		    flush = FALSE;
		    prev_bold_char = '\0';
		    }

		  if (flush) {
		    strncat(special_char,&masked_char,1);
		    if (knt >= 0)	/* already done for knt < 0 */
		      strncpy((memory->buffer + knt),&null_char,1);
		    if (new_line) {
		      if (data.numbering) {
			line_number++;
			sprintf(line_number_text,"%6d  ",line_number);
			XmTextInsert (memory->widget, pos, line_number_text);
			pos += strlen(line_number_text);
			}
		      prev_blank_line = blank_line;
		      blank_line = FALSE;
		      new_line = FALSE;
	  	      }
		    if (strlen(line_start) != 0) {  /* june 16 14:50 */
	              XmTextReplace (memory->widget, pos,
		      XmTextGetLastPosition(memory->widget), line_start);
		      pos += strlen(line_start);
		      line_start += strlen(line_start);
		      }
		    if ( !highlight ) line_start ++;	/* 7/11/95 */
		    if (strlen(special_char) != 0) {
	              XmTextReplace (memory->widget, pos,
		      XmTextGetLastPosition(memory->widget), special_char);
		      if (highlight) {
		        knt+=knt_bump;
		        line_start+=ls_bump;
			prev_bold_char = masked_char;
		        XmTextSetHighlight(memory->widget,
				pos,pos+strlen(special_char),highlight_style);
		        if (old_prev_char == '\0') {
		          highlight = FALSE;
			  }
		        }
		      else {
		        prev_char = '\0';
		        }
		      pos += strlen(special_char);
		      }
	  	    }				/* end of flush */
		  else {
		    prev_char = '\0';
		    }
		  }		/* end of loop for non-printing chars */
/*
	even if we weren't doing special character printing, we
	need to change null characters to blanks	- j.m.wade 2/26/92
*/
		else if (strncmp((memory->buffer + knt),&null_char,1) == 0)
		  strncpy((memory->buffer + knt)," ",1);

/*
	Now we need to take care of line numbering, blank line compression,
	and line end flagging.				- j.m.wade 2/26/92
*/
		if (strncmp((memory->buffer + knt),"\n",1) == 0) {
		  strncpy((memory->buffer + knt),&null_char,1);
		  if (new_line) {
		    prev_blank_line = blank_line;
		    }
/*
	See if the line feeds had any text between them.
*/
		  blank_line = (pos+strlen(line_start) == prev_line_feed_pos+1);

		  if (!data.blankCompress ||
			!prev_blank_line || !blank_line) {
		    if (new_line) {
		      if (data.numbering) {
			if (!(blank_line && !(data.blankNumbering))) {
			  line_number++;
			  sprintf(line_number_text,"%6d  ",line_number);
			  XmTextInsert (memory->widget, pos, line_number_text);
			  pos += strlen(line_number_text);
			  }
			}
		      }
		    XmTextInsert (memory->widget, pos, line_start);
#ifdef CRAY
		    if (line_counter == 20) {
	              XtVaSetValues (memory->widget, XmNcursorPosition,
			pos-1, NULL);
		      XmUpdateDisplay(memory->widget);
		      line_counter = 0;
		      }
		    else
		      line_counter++;
#endif
		    pos += strlen(line_start); 
		    prev_line_feed_pos = pos;

		    if (data.lineEnd) {
		      XmTextInsert (memory->widget, pos, "$\n");
		      pos += 2;
		      }
		    else {
		      XmTextInsert (memory->widget, pos, "\n");
		      pos += 1;
		      }
	            new_line = TRUE;
		    }
		  line_start += strlen(line_start)+1;
		  }
		}  /* end of for loop handling single bytes */

	      if (prev_char == '\0') 
		prev_char = saved_char;

	      if (line_start < (memory->buffer + bytes_read)) {
		if (new_line) {
		  prev_blank_line = blank_line;
		  blank_line = !strlen(line_start);
		  if (data.numbering) {
		    line_number++;
		    sprintf(line_number_text,"%6d  ",line_number);
		    XmTextInsert (memory->widget, pos, line_number_text);
		    pos += strlen(line_number_text);
		    }
		  }
		else
		  blank_line += !strlen(line_start);
	        new_line = FALSE;
	        XmTextInsert (memory->widget, pos, line_start);
	        XtVaSetValues (memory->widget, XmNcursorPosition, pos-1, NULL);
	        pos += strlen(line_start); 
		}
	      timer_interval = 1;
	      XtVaSetValues (memory->widget, XmNcursorPosition, pos-1, NULL);
	      XmUpdateDisplay(memory->widget);
	    }

	  if (memory->first) {
	    memory->first = FALSE;
	    if (data.center)
	      centermap (memory->toplevel);
	    else
	      XtMapWidget(memory->toplevel);
	    XFlush (XtDisplay(memory->toplevel));
	    }

/*	  }  */

	timer_interval = timer_interval<<1;
	if (timer_interval > memory->max_interval) 
		timer_interval = memory->max_interval;
	
	memory->interval_id = XtAppAddTimeOut(*memory->app_con,
		timer_interval,(XtTimerCallbackProc) input,
		(XtPointer) clientdata);

	return;
}

/*------------------------------------------------------------*/

void
execute (cmd)
   char *cmd;
{
   extern int errno;
   int std[2], fd, fdlim;
   char *blankloc;
   char *cmdptr;
   char *newcmd;
   char **cmdargs;
   int indx;

/*
	pid = getpid();
	grppid = getpgrp();
	fprintf(stderr,"xcat process pid = %d, process group = %d\n",pid,grppid);
*/

	if (pipe(std) < 0) {
	  perror ("xcat: execute (pipe)");
	  exit (1);
	  }

	if ((pid = fork()) < 0) {
	  perror ("xcat: execute (fork)");
	  exit (1);
	  }

	if (pid == 0) {    /* in the child process */
	  close (1);
	  dup (std[1]);
	  close (2);    /* new */
	  dup(std[1]); /* new */
	  close (std[0]);
	  close (std[1]);
	  for (fd = 3, fdlim = getdtablesize() + 1; fd < fdlim; fd++)
	    if (close(fd) == -1 && errno != EBADF) perror ("execcmd (close)");
	  if (pid = getpid() < 0) perror("xcat: execute (getpid)");
	  if (setpgid(pid,pid) < 0) perror ("xcat: execute (setpgid)");
	  execlp ("sh", "sh", "-c", cmd, NULL);
	  perror ("xcat: execute (exec)");
	  exit (127);
	}

	/* set group id of children to child's pid */

/*
	grppid = getpgid(pid);
	fprintf(stderr,"child process pid = %d\n",pid);
	fprintf(stderr,", process group = %d\n",grppid);
	fprintf(stderr,"setting process group id = %d\n",pid);
*/
	close (0);
	dup (std[0]);
	close (std[0]);
	close (std[1]);
	return;
}

/*------------------------------------------------------------*/

static void
sc_toggle (widget, clientdata, calldata)
   Widget widget;
   XtPointer clientdata, calldata;
{
	Boolean flag;
	XmString label;

	XtVaGetValues (clientdata, XmNautoShowCursorPosition, &flag, NULL);
	XtVaSetValues (clientdata, XmNautoShowCursorPosition, !flag, NULL);

/*
	strcpy(label, data.scrollLabel1);
	if (flag) strcpy(label, data.scrollLabel2);
*/
	label = XmStringCreate(flag ? data.scrollLabel2 : data.scrollLabel1,
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues (widget, XmNlabelString, label, NULL);
	XmStringFree(label);

	return;
}

/*------------------------------------------------------------*/

static XtTimerCallbackProc
print_enable (clientdata, input_id)
   XtPointer clientdata;
   XtIntervalId *input_id;
{
	XtSetSensitive((Widget) clientdata,TRUE);
}

/*------------------------------------------------------------*/

static void
print_disable (widget, clientdata, calldata) /* send win contents to ext command */
   Widget widget;
   XtPointer clientdata, calldata;
{
	int gray_time = 3000;
  	Boolean printCB();
	XtSetSensitive(widget,FALSE);
	if ( !data.printOnce ) 
	XtAppAddTimeOut(*memory.app_con,gray_time,
		(XtTimerCallbackProc) print_enable, widget);
	XSync(XtDisplay(widget),FALSE);
	XtAppAddWorkProc(*memory.app_con,
		(XtWorkProc) printCB, clientdata);
}

/*------------------------------------------------------------*/

/*
static void
printCB (widget, clientdata, calldata) 
   Widget widget;
   XtPointer clientdata, calldata;
*/
Boolean 
printCB (clientdata) /* send win contents to ext command */
   XtPointer clientdata;
{
	FILE *stream, *popen();
	char *text_string;
	int i;

	if ((stream=popen(printcmd,"w"))==NULL) {
		fprintf(stderr,"can't open pipe for: %s\n",printcmd);
		return(TRUE);
	}

	(void) signal (SIGPIPE, SIG_IGN);

	text_string = XmTextGetString(memory.widget);
	for (i=0; (text_string[i])!=0; ++i) putc (text_string[i], stream);

	if (ferror(stream))
	   fprintf(stderr,"error writing to %s.\n",printcmd);

	free(text_string);
	pclose (stream);

	(void) signal (SIGPIPE, SIG_DFL);
	return(TRUE);
}

/*------------------------------------------------------------*/

static void
xselectCB (widget, clientdata, calldata) 
   Widget widget, clientdata;
   XtPointer calldata;
{
    extern void runcmd();

    char *insert_pnt,*string_start;
    char *selection;
    static char *cmd;
    int stat;
    int gray_time = 3000;
    int insertions = 0;

    selection = XmTextGetSelection (clientdata);

    if (selection && strlen(selection)) {
	insert_pnt = data.xCmd;
	do {
	   insert_pnt  = strstr(insert_pnt,"%");
	   if (insert_pnt != NULL) {
	     if (*(insert_pnt+1) != '%') {
		insert_pnt += 1;
		insertions++;
		}
	     else {
		insert_pnt += 2;
		}
	     }
	   } while (insert_pnt != NULL);

	if (insertions != 0) {
	  cmd = (char *) XtMalloc(strlen(data.xCmd) +
		(insertions * strlen(selection)) + 1);

	  string_start = data.xCmd;
	  cmd[0] = '\0';
	  while ((insert_pnt = strstr(string_start,"%")) != NULL) {
	     if (*(insert_pnt+1) != '%') {
	        strncat(cmd,string_start,insert_pnt-string_start);
		string_start = insert_pnt+1;
		strcat(cmd,selection);
		}
	     else {
	        strncat(cmd,string_start,insert_pnt+1-string_start);
		string_start = insert_pnt+2;
		}
	     }

	  strncat(cmd,string_start,data.xCmd+strlen(data.xCmd)-string_start);
	  }
	else {
	  cmd = (char *) XtMalloc(strlen(data.xCmd) +  strlen(selection) + 2);
	  sprintf (cmd, "%s %s", data.xCmd, selection);
	  }

	runcmd (cmd);
	XtSetSensitive (widget, FALSE);
	XmUpdateDisplay (widget);
	XtAppAddTimeOut (*memory.app_con, gray_time, 
		(XtTimerCallbackProc) print_enable, widget);
    } else if ( data.xForce ) {
	sprintf (cmd, "%s", data.xCmd);
	runcmd (cmd);
	XtSetSensitive (widget, FALSE);
	XmUpdateDisplay (widget);
	XtAppAddTimeOut (*memory.app_con, gray_time,
		(XtTimerCallbackProc) print_enable, widget);
    } else {
	alert ("no selection was made");
    }
    XtFree(cmd);
}

/*------------------------------------------------------------*/

static void
adios (widget, clientdata, calldata)
   Widget widget;
   XtPointer clientdata, calldata;
{
	fclose (stdin);
	close (0);
	exit (exitstat);
}

/*------------------------------------------------------------*/

static void
kill_input (widget, clientdata, calldata)
   Widget widget;
   XtPointer clientdata, calldata;
{
	int code;
	extern int errno;
	XmString label;
	Memory  *memory = (Memory *)clientdata;

	XtRemoveTimeOut (memory->interval_id);
	XtRemoveCallback (widget, XmNactivateCallback, kill_input, clientdata);
	XtAddCallback (widget, XmNactivateCallback, adios, NULL);

	label = XmStringCreate(data.quitLabel,XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues (widget, XmNlabelString, label, NULL);
	XmStringFree(label);

	label = XmStringCreate(data.printLabel,XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues (scroll, XmNlabelString, label, NULL);
	XmStringFree(label);

	XtRemoveCallback (scroll,XmNactivateCallback,sc_toggle,(XtPointer)text);

	if (data.busy)
	  XUnmapWindow(XtDisplay(widget),memory->busy_win);

	if (!(printcmd = getenv (PRINTCMD)) || !strlen(printcmd))
	  if (!(printcmd = data.printCmd) || !strlen(printcmd))
/*
  LPR_PRINT_CMD should be defined in the Makefile if lpr is used and
  the PRINTER variable is expected. Otherwise, assume lp and LPDEST.
					- joe m. wade 6/9/95
*/
#ifdef LPR_PRINT_CMD
	    printcmd = ((printcmd =
		getenv("PRINTER")) && strlen(printcmd)) ? "lpr" : NULL;
#else
	    printcmd = ((printcmd =
		getenv("LPDEST")) && strlen(printcmd)) ? "lp" : NULL;
#endif

	if (printcmd) {
	   XtAddCallback (scroll, XmNactivateCallback, print_disable, NULL);
	} else {
	   XtSetSensitive (scroll, FALSE);
	}
	
        if (data.xCmd) XtSetSensitive (xselect, TRUE);  /* 06mar92 pf+ option */

/* - I take care of this with the -scroll option now - j.m.wade
	if (top) XtVaSetValues (text,
			        XmNcursorPosition, (XmTextPosition)1,
	                        XmNautoShowCursorPosition, TRUE, NULL); */

	if (data.editable == TRUE) {
		XtVaSetValues (text,
			XmNeditable, TRUE,
			XmNeditMode, XmMULTI_LINE_EDIT,
			NULL);
		}
	XtManageChild (text);

/* - if we were doing an exec, there is no known file, so we change the 
     save button to perform in the same manner as "save as"
*/

	if (!exec)
	  XtAddCallback(memory->save, XmNactivateCallback, oldfile, memory);
	else 
	  XtAddCallback(memory->save, XmNactivateCallback, newfile, memory);

	XtAddCallback(memory->save_as, XmNactivateCallback, newfile, memory);

	if (tee) {
	  fclose(stdout);
	  }

	if (pid && exec) {
		/* if (kill(-pid,9) < 0 && errno != ESRCH) */
		if (memory->debug) {
		  fprintf(stderr,"send signal %d to process group %d\n",
			 memory->kill_signal,pid);
			}
		if (kill(-pid,memory->kill_signal) < 0 && errno != ESRCH) {
			perror("xcat (kill)");
			}
		if ((exitstat=waiton(pid)) == 0 && data.transient)
			exit(0);
	  }
	else if (data.transient)	/* blow away transients - jmw 92043 */
		exit(0);

	if (memory->first && !data.automap)
		exit(exitstat);
			
/*	fclose (stdin);
	close (0); */
/* reopen to /dev/null to get around an apparent bug in popen */
	freopen("/dev/null","r",stdin);
	return;
}
void catch_signal()
/* because of apparent bugs in signal handling on certain architectures,
   I go ahead and catch the signal sent to the children and just ignore
   it.
*/
{
	return;
}
