/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#define DCLONLY
#include "field.h"
#include "global.h"
#include "checks.h"

/* 20dec91 phil fincannon - make name field optional if tag is defined  */
/* 20dec91 phil fincannon - make prompt field optional (defaults " ")   */
/* 20dec91 phil fincannon - added toggle button type                    */
/* 20dec91 phil fincannon - added slider type                           */
/* 23dec91 phil fincannon - removed string default min lth = 1          */

void doend(f) /* finish up a field and do final syntax checks */
Field *f;
{
	Field *fclone();

	char *tagval, *findval();

	if (infield == NO) {
		synerr("end","begin expected. field ignored.");
		return;
	}

	infield = NO;

	if (f->f_type == FTLABEL) {
		f->f_script = f->f_tag = f->f_iniv = NULL;
		f->f_name = "label";
	}

	if (!(f->f_name)) {
	    if (f->f_tag && f->f_type != FTLABEL) {   /* 20dec91 pf added */
		f->f_name = f->f_tag;
	    } else {
		synerr("end","name expected. field ignored.");
		return;
	    }
	}
		
	if (!(f->f_prompt)) f->f_prompt = " ";        /* 20dec91 pf added */
	
	if (!(f->f_prompt)) {
		synerr("end","prompt expected. field ignored.");
		return;
	}

	if (!(f->f_tag) && f->f_type != FTLABEL) {
		synerr("end","tag expected. field ignored.");
		return;
	}

	if (f->f_type == FTNONE) f->f_type = FTSTRING;

	if (f->f_row < 0) f->f_row = currow;

	if (f->f_col < 0) f->f_col = curcol;

	if ((f->f_read || f->f_write || f->f_exec) && f->f_type != FTPATH) {
		synwarn("read/write/execute ignored for non-path field.");
		f->f_read = f->f_write = f->f_exec = 0;
	}

	if (f->f_ptype && f->f_type != FTPATH) {
		synwarn("file type checking ignored for non-path field.");
		f->f_ptype = PTANY;
	}

	if (f->f_ptype != PTANY && !(f->f_read || f->f_write || f->f_exec)) {
		synwarn("file type checking without read/write/execute check ignored.");
		f->f_ptype = PTANY;
	}

	if (f->f_tag && (tagval=findval(f->f_tag))!=NULL) f->f_iniv=tagval;
			
	switch (f->f_type) {
		case FTSTRING:                          /* 20dec91 pf+ */
		case FTPWORD:				/* 20jul93 slf */
	            /*    if (!f->f_iniv) f->f_iniv = "_"; 14feb92 pf- */
			addckfun(f,strcktype);
			if (f->f_suffix) addckfun(f,strcksufx);
			if (f->f_minv) addckfun(f,strckmin);  /* 23dec91 pf c*/
			if (f->f_maxv) addckfun(f,strckmax);
			break;
		case FTINTEGER:
			if (f->f_iniv && !isint(f->f_iniv)) {
				synwarn("non int initial val ignored.");
				f->f_iniv = NULL;
			}
			if (f->f_suffix) {
				synwarn("suffix for integer field ignored.");
				f->f_suffix = NULL;
			}
			addckfun(f,intcktype);
			if (f->f_minv) addckfun(f,intckmin);
			if (f->f_maxv) addckfun(f,intckmax);
			break;
		case FTREAL:
		case FTSLIDER:                           /* 20dec91 pf added */
			if (f->f_type == FTSLIDER) {     /* 20dec91 pf added */
			    if (!f->f_minv) f->f_minv = "0"; 
			    if (!f->f_maxv) f->f_maxv = "100";
			    if (!f->f_prec) f->f_prec = 0;
			}
			if (f->f_iniv && !isreal(f->f_iniv)) {
				synwarn("non real initial val ignored.");
				f->f_iniv = NULL;
			}
			if (f->f_suffix) {
				synwarn("suffix for real field ignored.");
				f->f_suffix = NULL;
			}
			addckfun(f,realcktype);
			if (f->f_minv) addckfun(f,realckmin);
			if (f->f_maxv) addckfun(f,realckmax);
			break;
		case FTPATH:
			addckfun(f,pathcktype);
			if (f->f_suffix) addckfun(f,pathcksufx);
			if (!(f->f_minv)) f->f_minv = "1";
			addckfun(f,pathckmin);
			if (f->f_maxv) addckfun(f,pathckmax);
			if (f->f_read) addckfun(f,pathckread);
			if (f->f_write) addckfun(f,pathckwrite);
			if (f->f_exec) addckfun(f,pathckexec);
			break;	
		case FTYESNO:
			if (f->f_suffix) {
				synwarn("suffix for yes/no field ignored.");
				f->f_suffix = NULL;
			}
			addckfun(f,yesnock);
			break;
		case FTTOGGLE:                  /* 20dec91 pf added */
			if (!f->f_on) f->f_on = "X";     /* 14feb92 pf+ */
			if (!f->f_off) f->f_off = " ";   /* 14feb92 pf+ */
			if (!f->f_iniv) f->f_iniv = " "; /* 14feb92 pf+ */
			break;
		case FTLABEL:
			break;
		default:
			fprintf(stderr,"doend: impossible type!.\n");
			break;
	}

	if (f->f_script) addckfun(f,scriptck);

	currow = f->f_row + 1;

	curcol = f->f_col;

	flist[nfields++] = fclone(f); 

}
