/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <ctype.h>

int lineno = 1;

gettok(token,toksiz) /* get next token from input stream */
char *token;
int toksiz;
{
	int c, q, i;

	char *term;

	*token = '\0';

	do {
		if ((c = ngetc()) == '#')
			while ((c = ngetc()) != '\n' && c != EOF)
				;
		if (c == '\n')
			lineno++;
	}  while(isspace(c));

	if (c == EOF) {
		putbak(c);
		return(c);
	}

	if (c == '"' || c == '\'') {
		for (q = c, i = 0; i < toksiz; i++) {
			if ((c = ngetc()) == '\\') {
				/* grab escaped char unless eof */
				if ((c = ngetc()) == EOF || c == '\\') 
					putbak(c);
			}
			else if (c == q || c == EOF)
				break;
			token[i] = c;
		}
		if (isspace(c)) {
			synerr(NULL,"missing quote.");
			putbak(c);
			token[0] = '\0';
		}
		if (i > toksiz - 1)
			synerr(NULL,"token too long.");
		token[i] = '\0';
		return(c=token[0]);
	}

	putbak(c);

	for (i = 0; i < toksiz; i++)
		if (!isgraph(token[i] = ngetc())) {
			putbak(c=token[i]);
			break;
		}

	if (i > toksiz -1)
		synerr(NULL,"token too long.");

	token[i] = '\0';

	return(c=token[0]);

}

synerr(token,msg) /* syntax error message */
char *token, *msg;
{
	fprintf(stderr,"syntax error at line %d: ",lineno);

	if (token != NULL && *token != '\0')
		fprintf(stderr,"<%s> ", token);

	if (msg != NULL && *msg != '\0')
		fprintf(stderr,"%s", msg);

	fprintf(stderr,"\n");

}

synwarn(msg) /* syntax warning message */
char *msg;
{
	fprintf(stderr,"warning at line %d: %s\n",lineno,msg);
}

fatal(token,msg) /* print token, message, then croak */
char *token, *msg;
{
	fprintf(stderr,"fatal error ");

	if (token != NULL && *token != '\0')
		fprintf(stderr,"<%s> ", token);

	if (msg != NULL && *msg != '\0')
		fprintf(stderr,"%s", msg);

	fprintf(stderr,"\n");

	abort();
}
