/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <localsys.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "field.h"

#ifdef CRAYSYSTEM
#define S_ISBLK(m)      (((m)&S_IFMT) == S_IFBLK)
#define S_ISCHR(m)      (((m)&S_IFMT) == S_IFCHR)
#define S_ISDIR(m)      (((m)&S_IFMT) == S_IFDIR)
#define S_ISFIFO(m)     (((m)&S_IFMT) == S_IFIFO)
#define S_ISREG(m)      (((m)&S_IFMT) == S_IFREG)
#define S_ISLNK(m)      (((m)&S_IFMT) == S_IFLNK)
#define S_ISSOCK(m)     (((m)&S_IFMT) == S_IFSOCK)
#endif
#ifdef CONVEXSYSTEM
#define S_ISSOCK(m)     (_S_ISSOCK(m))
#endif

pathckptype(f,path,mustread) /* check type of path */
Field *f; char *path; int mustread;
{
	char *kind, msg[255];

	struct stat buf;

	void doalert();

	if (stat(path,&buf) == -1) {
		sprintf(msg,"can't stat %s. get help.",path);
		doalert(msg);
		return 1;
	}

	if (mustread && S_ISREG(buf.st_mode) && buf.st_size <= 0) {
		sprintf(msg,"%s: specified file is empty.",f->f_name);
		doalert(msg);
		return 1;
	}

	if (f->f_ptype == PTANY)
		return 0;

	kind = "unknown file type";

	if (S_ISREG(buf.st_mode)) {
		if ((f->f_ptype & PTREG) == PTREG)
			return 0;
		kind = "regular file";
	}

	if (S_ISDIR(buf.st_mode)) {
		if ((f->f_ptype & PTDIR) == PTDIR)
			return 0;
		kind = "directory";
	}

	if (S_ISCHR(buf.st_mode)) {
		if ((f->f_ptype & PTCHAR) == PTCHAR)
			return 0;
		if ((f->f_ptype & PTCONSOL) == PTCONSOL &&
				strcmp(path,"/dev/console") == 0)
			return 0;

		kind = "character device";
	}

	if (S_ISBLK(buf.st_mode)) {
		if ((f->f_ptype & PTBLOCK) == PTBLOCK)
			return 0;
		kind = "block device";
	}

	if (S_ISSOCK(buf.st_mode)) {
		if ((f->f_ptype & PTSOC) == PTSOC)
			return 0;
		kind = "socket";
	}

	if (S_ISFIFO(buf.st_mode)) {
		if ((f->f_ptype & PTFIFO) == PTFIFO)
			return 0;
		kind = "socket";
	}

	sprintf(msg,"%s: specified file is a %s.",f->f_name,kind);

	doalert(msg);

	return 1;

}
